/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.model.listener;

import com.liferay.change.tracking.internal.background.task.CTPublishBackgroundTaskExecutor;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTProcess;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTSchemaVersionLocalService;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class BackgroundTaskModelListener
extends BaseModelListener<BackgroundTask> {
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTSchemaVersionLocalService _ctSchemaVersionLocalService;

    public void onAfterUpdate(BackgroundTask originalBackgroundTask, BackgroundTask backgroundTask) {
        if (backgroundTask == null || !Objects.equals(backgroundTask.getTaskExecutorClassName(), CTPublishBackgroundTaskExecutor.class.getName())) {
            return;
        }
        if (backgroundTask.getStatus() == 5 || backgroundTask.getStatus() == 2) {
            String name = backgroundTask.getName();
            if (name.contains("_")) {
                return;
            }
            CTCollection ctCollection = this._ctCollectionLocalService.fetchCTCollection(Long.valueOf(backgroundTask.getName()).longValue());
            if (ctCollection != null) {
                int status = 2;
                if (!this._ctSchemaVersionLocalService.isLatestCTSchemaVersion(ctCollection.getSchemaVersionId())) {
                    status = 3;
                }
                ctCollection.setStatus(status);
                this._ctCollectionLocalService.updateCTCollection(ctCollection);
            }
        }
        if (backgroundTask.getStatus() != originalBackgroundTask.getStatus()) {
            this._reindexCTProcess(backgroundTask);
        }
    }

    private void _reindexCTProcess(BackgroundTask backgroundTask) {
        long ctProcessId = MapUtil.getLong((Map)backgroundTask.getTaskContextMap(), (String)"ctProcessId");
        if (ctProcessId <= 0L) {
            return;
        }
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CTProcess.class);
            indexer.reindex(CTProcess.class.getName(), ctProcessId);
        }
        catch (SearchException searchException) {
            throw new ModelListenerException((Throwable)searchException);
        }
    }
}

