/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.session.AuthenticatedSessionManagerUtil;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"key=servlet.service.events.pre"}, service={LifecycleAction.class})
public class CTOnDemandUserPreAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(CTOnDemandUserPreAction.class);
    @Reference
    private Portal _portal;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        block3: {
            if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-187436")) {
                return;
            }
            try {
                this._run(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
    }

    private boolean _isPublicationsPortletRequest(HttpServletRequest httpServletRequest) {
        String portletId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_id");
        if (Validator.isNull((String)portletId)) {
            portletId = HttpComponentsUtil.getParameter((String)httpServletRequest.getHeader("referer"), (String)"p_p_id", (boolean)false);
        }
        if (Objects.equals(portletId, "com_liferay_change_tracking_web_portlet_PublicationsPortlet")) {
            return true;
        }
        long previewCTCollectionId = GetterUtil.getLong((String)HttpComponentsUtil.getParameter((String)httpServletRequest.getHeader("referer"), (String)"previewCTCollectionId", (boolean)false), (long)-1L);
        return previewCTCollectionId >= 0L;
    }

    private void _run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        User user = this._portal.getUser(httpServletRequest);
        if (user == null || !user.isOnDemandUser()) {
            return;
        }
        if (!this._isPublicationsPortletRequest(httpServletRequest)) {
            AuthenticatedSessionManagerUtil.logout((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            httpServletRequest.setAttribute("LOGOUT", (Object)Boolean.TRUE);
            httpServletResponse.sendRedirect(this._portal.getCurrentURL(httpServletRequest));
        }
    }
}

