/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.conflict;

import com.liferay.change.tracking.conflict.CTEntryConflictHelper;
import com.liferay.change.tracking.conflict.ConflictInfo;
import com.liferay.change.tracking.internal.CTRowUtil;
import com.liferay.change.tracking.internal.conflict.AdditionConflictInfo;
import com.liferay.change.tracking.internal.conflict.ConstraintResolverConflictInfo;
import com.liferay.change.tracking.internal.conflict.DefaultConstraintConflictInfo;
import com.liferay.change.tracking.internal.conflict.DeletionModificationConflictInfo;
import com.liferay.change.tracking.internal.conflict.MissingRequirementConflictInfo;
import com.liferay.change.tracking.internal.conflict.ModificationConflictInfo;
import com.liferay.change.tracking.internal.conflict.ModificationDeletionConflictInfo;
import com.liferay.change.tracking.internal.reference.TableJoinHolder;
import com.liferay.change.tracking.internal.reference.TableReferenceDefinitionManager;
import com.liferay.change.tracking.internal.reference.TableReferenceInfo;
import com.liferay.change.tracking.internal.resolver.ConstraintResolverContextImpl;
import com.liferay.change.tracking.internal.resolver.ConstraintResolverKey;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.model.CTEntryTable;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.spi.display.CTDisplayRenderer;
import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.query.WhereStep;
import com.liferay.petra.sql.dsl.spi.ast.DefaultASTNodeListener;
import com.liferay.petra.sql.dsl.spi.query.Join;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class CTConflictChecker<T extends CTModel<T>> {
    private static final int _BATCH_SIZE = 1000;
    private final ClassNameLocalService _classNameLocalService;
    private final ServiceTrackerMap<ConstraintResolverKey, ConstraintResolver<?>> _constraintResolverServiceTrackerMap;
    private final ServiceTrackerMap<String, CTDisplayRenderer<?>> _ctDisplayRendererServiceTrackerMap;
    private final Set<CTEntry> _ctEntries = new HashSet<CTEntry>();
    private final ServiceTrackerMap<String, CTEntryConflictHelper> _ctEntryConflictHelperServiceTrackerMap;
    private final CTEntryLocalService _ctEntryLocalService;
    private final CTService<T> _ctService;
    private final long _modelClassNameId;
    private Map<Serializable, CTEntry> _modificationCTEntries;
    private final long _sourceCTCollectionId;
    private final TableReferenceDefinitionManager _tableReferenceDefinitionManager;
    private final long _targetCTCollectionId;

    public CTConflictChecker(ClassNameLocalService classNameLocalService, ServiceTrackerMap<ConstraintResolverKey, ConstraintResolver<?>> constraintResolverServiceTrackerMap, ServiceTrackerMap<String, CTDisplayRenderer<?>> ctDisplayRendererServiceTrackerMap, ServiceTrackerMap<String, CTEntryConflictHelper> ctEntryConflictHelperServiceTrackerMap, CTEntryLocalService ctEntryLocalService, CTService<T> ctService, long modelClassNameId, long sourceCTCollectionId, TableReferenceDefinitionManager tableReferenceDefinitionManager, long targetCTCollectionId) {
        this._classNameLocalService = classNameLocalService;
        this._constraintResolverServiceTrackerMap = constraintResolverServiceTrackerMap;
        this._ctDisplayRendererServiceTrackerMap = ctDisplayRendererServiceTrackerMap;
        this._ctEntryConflictHelperServiceTrackerMap = ctEntryConflictHelperServiceTrackerMap;
        this._ctEntryLocalService = ctEntryLocalService;
        this._ctService = ctService;
        this._modelClassNameId = modelClassNameId;
        this._sourceCTCollectionId = sourceCTCollectionId;
        this._tableReferenceDefinitionManager = tableReferenceDefinitionManager;
        this._targetCTCollectionId = targetCTCollectionId;
    }

    public void addCTEntry(CTEntry ctEntry) {
        if (ctEntry.getChangeType() == 2) {
            if (this._modificationCTEntries == null) {
                this._modificationCTEntries = new HashMap<Serializable, CTEntry>();
            }
            this._modificationCTEntries.put(Long.valueOf(ctEntry.getModelClassPK()), ctEntry);
        }
        this._ctEntries.add(ctEntry);
    }

    public List<ConflictInfo> check() throws PortalException {
        return (List)this._ctService.updateWithUnsafeFunction(this::_check);
    }

    private List<ConflictInfo> _check(CTPersistence<T> ctPersistence) throws PortalException {
        List uniqueIndexColumnNames;
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)ctPersistence.getDataSource());
        Set primaryKeyNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.PK);
        if (primaryKeyNames.size() != 1) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{ctPersistence=", ctPersistence, ", primaryKeyNames=", primaryKeyNames, "}"}));
        }
        Iterator iterator = primaryKeyNames.iterator();
        String primaryKeyName = (String)iterator.next();
        ArrayList<ConflictInfo> conflictInfos = new ArrayList<ConflictInfo>();
        this._checkAdditions(connection, ctPersistence, conflictInfos, primaryKeyName);
        this._checkDeletions(connection, ctPersistence, conflictInfos, primaryKeyName);
        if (this._modificationCTEntries != null) {
            this._checkModifications(connection, ctPersistence, conflictInfos, primaryKeyName);
        }
        if (!(uniqueIndexColumnNames = ctPersistence.getUniqueIndexColumnNames()).isEmpty()) {
            for (String[] columnNames : uniqueIndexColumnNames) {
                this._checkConstraint(connection, ctPersistence, conflictInfos, primaryKeyName, columnNames);
            }
        }
        this._checkMissingRequirements(connection, ctPersistence, conflictInfos);
        this._checkCTEntries(ctPersistence, conflictInfos);
        return conflictInfos;
    }

    private void _checkAdditions(Connection connection, CTPersistence<T> ctPersistence, List<ConflictInfo> conflictInfos, String primaryKeyName) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select publication.", primaryKeyName, " from ", ctPersistence.getTableName(), " publication inner join CTEntry on CTEntry.modelClassPK ", "= publication.", primaryKeyName, " where CTEntry.ctCollectionId = ", this._sourceCTCollectionId, " and CTEntry.modelClassNameId = ", this._modelClassNameId, " and CTEntry.changeType = ", 0, " and publication.ctCollectionId = ", this._targetCTCollectionId}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                conflictInfos.add(new AdditionConflictInfo(resultSet.getLong(1)));
            }
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
    }

    private void _checkConstraint(Connection connection, CTPersistence<T> ctPersistence, List<ConflictInfo> conflictInfos, String primaryKeyName, String[] columnNames) throws PortalException {
        String constraintConflictsSQL = CTRowUtil.getConstraintConflictsSQL(ctPersistence.getTableName(), primaryKeyName, columnNames, this._targetCTCollectionId);
        List<Map.Entry<Long, Long>> nextPrimaryKeys = this._getConflictingPrimaryKeys(connection, ctPersistence.getTableName(), primaryKeyName, columnNames, constraintConflictsSQL);
        if (nextPrimaryKeys.isEmpty()) {
            return;
        }
        ConstraintResolver constraintResolver = (ConstraintResolver)this._constraintResolverServiceTrackerMap.getService((Object)new ConstraintResolverKey(ctPersistence.getModelClass(), columnNames));
        if (constraintResolver == null) {
            StringBundler sb = new StringBundler(2 * columnNames.length);
            for (String columnName : columnNames) {
                sb.append(columnName);
                sb.append(", ");
            }
            sb.setIndex(sb.index() - 1);
            String columnNamesString = sb.toString();
            for (Map.Entry<Long, Long> currentPrimaryKeys : nextPrimaryKeys) {
                conflictInfos.add(new DefaultConstraintConflictInfo(currentPrimaryKeys.getKey(), currentPrimaryKeys.getValue(), columnNamesString));
            }
            return;
        }
        ConstraintResolverContextImpl<T> constraintResolverContextImpl = new ConstraintResolverContextImpl<T>(this._ctService, this._sourceCTCollectionId, this._targetCTCollectionId);
        HashSet<Map.Entry<Long, Long>> attemptedPrimaryKeys = new HashSet<Map.Entry<Long, Long>>();
        HashSet<Map.Entry<Long, Long>> resolvedPrimaryKeys = new HashSet<Map.Entry<Long, Long>>(nextPrimaryKeys);
        while (!nextPrimaryKeys.isEmpty()) {
            Map.Entry<Long, Long> currentPrimaryKeys = nextPrimaryKeys.get(0);
            constraintResolverContextImpl.setPrimaryKeys(currentPrimaryKeys.getKey(), currentPrimaryKeys.getValue());
            constraintResolver.resolveConflict(constraintResolverContextImpl);
            Session session = ctPersistence.getCurrentSession();
            session.flush();
            session.clear();
            attemptedPrimaryKeys.add(currentPrimaryKeys);
            nextPrimaryKeys = this._getConflictingPrimaryKeys(connection, ctPersistence.getTableName(), primaryKeyName, columnNames, constraintConflictsSQL);
            resolvedPrimaryKeys.addAll(nextPrimaryKeys);
            nextPrimaryKeys.removeAll(attemptedPrimaryKeys);
        }
        List<Map.Entry<Long, Long>> unresolvedPrimaryKeys = this._getConflictingPrimaryKeys(connection, ctPersistence.getTableName(), primaryKeyName, columnNames, constraintConflictsSQL);
        resolvedPrimaryKeys.removeAll(unresolvedPrimaryKeys);
        for (Map.Entry entry : resolvedPrimaryKeys) {
            conflictInfos.add(new ConstraintResolverConflictInfo(constraintResolver, true, (Long)entry.getKey(), (Long)entry.getValue()));
        }
        if (unresolvedPrimaryKeys.isEmpty()) {
            return;
        }
        for (Map.Entry entry : unresolvedPrimaryKeys) {
            conflictInfos.add(new ConstraintResolverConflictInfo(constraintResolver, false, (Long)entry.getKey(), (Long)entry.getValue()));
        }
    }

    private void _checkCTEntries(CTPersistence<T> ctPersistence, List<ConflictInfo> conflictInfos) {
        Class clazz = ctPersistence.getModelClass();
        CTEntryConflictHelper ctEntryConflictHelper = (CTEntryConflictHelper)this._ctEntryConflictHelperServiceTrackerMap.getService((Object)clazz.getName());
        if (ctEntryConflictHelper == null) {
            return;
        }
        for (CTEntry ctEntry : this._ctEntries) {
            if (ctEntryConflictHelper.hasModificationConflict(ctEntry, this._targetCTCollectionId)) {
                conflictInfos.add(new ModificationConflictInfo(ctEntry.getModelClassPK(), false));
            }
            if (!ctEntryConflictHelper.hasDeletionModificationConflict(ctEntry, this._targetCTCollectionId)) continue;
            conflictInfos.add(new DeletionModificationConflictInfo(ctEntry.getModelClassPK()));
        }
    }

    private void _checkDeletions(Connection connection, CTPersistence<T> ctPersistence, List<ConflictInfo> conflictInfos, String primaryKeyName) {
        Throwable throwable;
        ResultSet resultSet2;
        Throwable throwable2;
        PreparedStatement preparedStatement;
        try {
            preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select publication.", primaryKeyName, " from ", ctPersistence.getTableName(), " publication inner join CTEntry on CTEntry.modelClassPK ", "= publication.", primaryKeyName, " where CTEntry.ctCollectionId = ", this._sourceCTCollectionId, " and CTEntry.modelClassNameId = ", this._modelClassNameId, " and CTEntry.changeType = ", 1, " and (publication.ctCollectionId = ", this._targetCTCollectionId, " or publication.ctCollectionId = ", 0L, ") and CTEntry.modelMvccVersion != ", "publication.mvccVersion"}));
            throwable2 = null;
            try {
                resultSet2 = preparedStatement.executeQuery();
                throwable = null;
                try {
                    while (resultSet2.next()) {
                        conflictInfos.add(new ModificationDeletionConflictInfo(resultSet2.getLong(1), false));
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (resultSet2 != null) {
                        if (throwable != null) {
                            try {
                                resultSet2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            resultSet2.close();
                        }
                    }
                }
            }
            catch (Throwable resultSet2) {
                throwable2 = resultSet2;
                throw resultSet2;
            }
            finally {
                if (preparedStatement != null) {
                    if (throwable2 != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable resultSet2) {
                            throwable2.addSuppressed(resultSet2);
                        }
                    } else {
                        preparedStatement.close();
                    }
                }
            }
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
        try {
            preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select distinct ctEntry1.modelClassPK from CTEntry ", "ctEntry1 inner join CTCollection on ", "ctEntry1.ctCollectionId = CTCollection.ctCollectionId ", "and CTCollection.status = ", 2, " inner join CTEntry ", "ctEntry2 on ctEntry1.modelClassNameId = ", "ctEntry2.modelClassNameId and ctEntry1.modelClassPK = ", "ctEntry2.modelClassPK where ctEntry1.modelClassNameId = ", this._modelClassNameId, " and ctEntry1.changeType = ", 1, " and ctEntry1.ctCollectionId = ", this._sourceCTCollectionId, " and ctEntry2.changeType = ", 2, " and ctEntry2.ctCollectionId != ", this._sourceCTCollectionId}));
            throwable2 = null;
            try {
                resultSet2 = preparedStatement.executeQuery();
                throwable = null;
                try {
                    while (resultSet2.next()) {
                        conflictInfos.add(new ModificationDeletionConflictInfo(resultSet2.getLong(1), true));
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (resultSet2 != null) {
                        if (throwable != null) {
                            try {
                                resultSet2.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            resultSet2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                if (preparedStatement != null) {
                    if (throwable2 != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable8) {
                            throwable2.addSuppressed(throwable8);
                        }
                    } else {
                        preparedStatement.close();
                    }
                }
            }
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
    }

    private void _checkMissingRequirements(Connection connection, CTPersistence<T> ctPersistence, List<ConflictInfo> conflictInfos) throws PortalException {
        if (this._ctEntries.isEmpty()) {
            return;
        }
        GroupByStep ctEntryDSLQuery = DSLQueryFactoryUtil.select((Expression[])new Expression[]{CTEntryTable.INSTANCE.modelClassPK}).from((Table)CTEntryTable.INSTANCE).where(CTEntryTable.INSTANCE.ctCollectionId.eq((Object)this._sourceCTCollectionId).and((Expression)CTEntryTable.INSTANCE.modelClassNameId.eq((Object)this._modelClassNameId)).and((Expression)CTEntryTable.INSTANCE.changeType.eq((Object)0)));
        Map<Long, TableReferenceInfo<?>> combinedTableReferenceInfos = this._tableReferenceDefinitionManager.getCombinedTableReferenceInfos();
        TableReferenceInfo<?> tableReferenceInfo = combinedTableReferenceInfos.get(this._modelClassNameId);
        if (tableReferenceInfo == null) {
            throw new IllegalArgumentException("No table reference definition for " + ctPersistence.getModelClass());
        }
        DSLQuery dslQuery = null;
        Map<Table<?>, List<TableJoinHolder>> parentTableJoinHoldersMap = tableReferenceInfo.getParentTableJoinHoldersMap();
        for (List<TableJoinHolder> tableJoinHolders : parentTableJoinHoldersMap.values()) {
            for (TableJoinHolder tableJoinHolder : tableJoinHolders) {
                if (tableJoinHolder.isReversed()) continue;
                DSLQuery nextDSLQuery = this._getMissingRequirementsDSLQuery((DSLQuery)ctEntryDSLQuery, tableJoinHolder);
                if (dslQuery == null) {
                    dslQuery = nextDSLQuery;
                    continue;
                }
                dslQuery = dslQuery.union(nextDSLQuery);
            }
        }
        if (dslQuery != null) {
            try (PreparedStatement preparedStatement = this._getPreparedStatement(connection, dslQuery);
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long modelClassPK = resultSet.getLong(1);
                    String tableName = resultSet.getString(2);
                    ClassName className = this._classNameLocalService.getClassName(this._tableReferenceDefinitionManager.getClassNameId(tableName));
                    String classNameValue = className.getValue();
                    conflictInfos.add(new MissingRequirementConflictInfo(classNameValue, modelClassPK, (CTDisplayRenderer)this._ctDisplayRendererServiceTrackerMap.getService((Object)classNameValue)));
                }
            }
            catch (SQLException sqlException) {
                throw new ORMException("Unable to execute query: " + dslQuery, (Throwable)sqlException);
            }
        }
    }

    private void _checkModifications(Connection connection, CTPersistence<T> ctPersistence, List<ConflictInfo> conflictInfos, String primaryKeyName) {
        List<Long> resolvedPrimaryKeys = this._getModifiedPrimaryKeys(connection, ctPersistence, primaryKeyName, true);
        for (Long l : resolvedPrimaryKeys) {
            conflictInfos.add(new ModificationConflictInfo(l, true));
        }
        this._resolveModificationConflicts(connection, ctPersistence, primaryKeyName, resolvedPrimaryKeys);
        List<Long> unresolvedPrimaryKeys = this._getModifiedPrimaryKeys(connection, ctPersistence, primaryKeyName, false);
        for (Long unresolvedPrimaryKey : unresolvedPrimaryKeys) {
            conflictInfos.add(new ModificationConflictInfo(unresolvedPrimaryKey, false));
        }
        this._updateModelMvccVersion(connection, primaryKeyName, ctPersistence.getTableName(), unresolvedPrimaryKeys);
        List<Long> list = this._getDeletionModificationPKs(connection, ctPersistence, primaryKeyName);
        for (long deletionModificationPK : list) {
            conflictInfos.add(new DeletionModificationConflictInfo(deletionModificationPK));
        }
    }

    private void _copyModificationConflictCTRow(Connection connection, CTPersistence<?> ctPersistence, String primaryKeyName, long primaryKey, long tempCTCollectionId) {
        StringBundler sb = new StringBundler("select ");
        Set ignoredColumnNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.IGNORE);
        Set maxColumnNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.MAX);
        Set minColumnNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.MIN);
        Map tableColumnsMap = ctPersistence.getTableColumnsMap();
        for (String name : tableColumnsMap.keySet()) {
            if (name.equals("ctCollectionId")) {
                sb.append(this._sourceCTCollectionId);
                sb.append(" as ");
            } else if (name.equals("mvccVersion")) {
                sb.append("(publication.mvccVersion + 1) ");
            } else if (ignoredColumnNames.contains(name)) {
                sb.append("production.");
            } else if (maxColumnNames.contains(name) || minColumnNames.contains(name)) {
                sb.append("composite.");
            } else {
                sb.append("publication.");
            }
            sb.append(name);
            sb.append(", ");
        }
        sb.setStringAt(" from ", sb.index() - 1);
        sb.append(ctPersistence.getTableName());
        sb.append(" production inner join ");
        sb.append(ctPersistence.getTableName());
        sb.append(" publication on production.");
        sb.append(primaryKeyName);
        sb.append(" = publication.");
        sb.append(primaryKeyName);
        if (!maxColumnNames.isEmpty() || !minColumnNames.isEmpty()) {
            sb.append(" inner join (select ");
            sb.append(primaryKeyName);
            for (String maxColumnName : maxColumnNames) {
                sb.append(", max(");
                sb.append(maxColumnName);
                sb.append(") ");
                sb.append(maxColumnName);
            }
            for (String minColumnName : minColumnNames) {
                sb.append(", min(");
                sb.append(minColumnName);
                sb.append(") ");
                sb.append(minColumnName);
            }
            sb.append(" from ");
            sb.append(ctPersistence.getTableName());
            sb.append(" where ctCollectionId in (");
            sb.append(this._targetCTCollectionId);
            sb.append(", ");
            sb.append(tempCTCollectionId);
            sb.append(") group by ");
            sb.append(primaryKeyName);
            sb.append(") composite on composite.");
            sb.append(primaryKeyName);
            sb.append(" = production.");
            sb.append(primaryKeyName);
        }
        sb.append(" where publication.ctCollectionId = ");
        sb.append(tempCTCollectionId);
        sb.append(" and production.ctCollectionId = ");
        sb.append(this._targetCTCollectionId);
        sb.append(" and publication.");
        sb.append(primaryKeyName);
        sb.append(" = ");
        sb.append(primaryKey);
        sb.append(" and production.");
        sb.append(primaryKeyName);
        sb.append(" = ");
        sb.append(primaryKey);
        try {
            CTRowUtil.copyCTRows(ctPersistence, connection, sb.toString());
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
    }

    private List<Map.Entry<Long, Long>> _getConflictingPrimaryKeys(Connection connection, String tableName, String primaryKeyName, String[] columnNames, String constraintConflictsSQL) {
        ArrayList<Map.Entry<Long, Long>> primaryKeys;
        block54: {
            HashSet<Long> verifyPrimaryKeys = new HashSet<Long>();
            HashSet<Long> ignorablePrimaryKeys = new HashSet<Long>();
            for (CTEntry ctEntry : this._ctEntries) {
                if (ctEntry.getChangeType() != 0) {
                    ignorablePrimaryKeys.add(ctEntry.getModelClassPK());
                    continue;
                }
                verifyPrimaryKeys.add(ctEntry.getModelClassPK());
            }
            if (verifyPrimaryKeys.isEmpty()) {
                return Collections.emptyList();
            }
            String constraintEntriesSQL = CTRowUtil.getConstraintEntitiesSQL(tableName, primaryKeyName, columnNames, this._sourceCTCollectionId, verifyPrimaryKeys);
            primaryKeys = new ArrayList<Map.Entry<Long, Long>>();
            try (PreparedStatement preparedStatement1 = connection.prepareStatement(constraintEntriesSQL);){
                ResultSet resultSet1 = preparedStatement1.executeQuery();
                Throwable throwable = null;
                block41: while (true) {
                    try {
                        if (!resultSet1.next()) break block54;
                        long sourcePK = resultSet1.getLong(1);
                        try {
                            PreparedStatement preparedStatement2 = connection.prepareStatement(constraintConflictsSQL);
                            Throwable throwable2 = null;
                            try {
                                preparedStatement2.setObject(1, sourcePK);
                                for (int i = 2; i < columnNames.length + 2; ++i) {
                                    preparedStatement2.setObject(i, resultSet1.getObject(i));
                                }
                                ResultSet resultSet2 = preparedStatement2.executeQuery();
                                Throwable throwable3 = null;
                                try {
                                    while (true) {
                                        if (!resultSet2.next()) continue block41;
                                        long targetPK = resultSet2.getLong(1);
                                        if (ignorablePrimaryKeys.contains(targetPK)) continue;
                                        primaryKeys.add(new AbstractMap.SimpleImmutableEntry<Long, Long>(sourcePK, targetPK));
                                    }
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (resultSet2 == null) continue;
                                    if (throwable3 != null) {
                                        try {
                                            resultSet2.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable3.addSuppressed(throwable5);
                                        }
                                        continue;
                                    }
                                    resultSet2.close();
                                }
                            }
                            catch (Throwable throwable6) {
                                throwable2 = throwable6;
                                throw throwable6;
                            }
                            finally {
                                if (preparedStatement2 == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        preparedStatement2.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                    continue;
                                }
                                preparedStatement2.close();
                            }
                        }
                        catch (SQLException sqlException) {
                            throw new ORMException((Throwable)sqlException);
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                }
                finally {
                    if (resultSet1 != null) {
                        if (throwable != null) {
                            try {
                                resultSet1.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                        } else {
                            resultSet1.close();
                        }
                    }
                }
            }
            catch (SQLException sqlException) {
                throw new ORMException((Throwable)sqlException);
            }
        }
        return primaryKeys;
    }

    /*
     * Exception decompiling
     */
    private List<Long> _getDeletionModificationPKs(Connection connection, CTPersistence<T> ctPersistence, String primaryKeyName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DSLQuery _getMissingRequirementsDSLQuery(DSLQuery ctEntryDSLQuery, TableJoinHolder tableJoinHolder) {
        Join join;
        WhereStep whereStep = tableJoinHolder.getMissingRequirementWhereStep();
        LinkedList<Join> joins = new LinkedList<Join>();
        WhereStep astNode = whereStep;
        while (astNode instanceof Join) {
            join = (Join)astNode;
            joins.push(join);
            astNode = join.getChild();
        }
        join = null;
        JoinStep joinStep = (JoinStep)astNode;
        while ((join = (Join)joins.poll()) != null) {
            Predicate predicate = join.getOnPredicate();
            Table table = join.getTable();
            predicate = predicate.and(() -> {
                Column ctCollectionIdColumn = table.getColumn("ctCollectionId", Long.class);
                if (ctCollectionIdColumn != null) {
                    if (this._targetCTCollectionId == 0L) {
                        return ctCollectionIdColumn.in((Object[])new Long[]{this._sourceCTCollectionId, this._targetCTCollectionId});
                    }
                    return ctCollectionIdColumn.in((Object[])new Long[]{this._sourceCTCollectionId, this._targetCTCollectionId, 0L});
                }
                return null;
            });
            joinStep = joinStep.leftJoinOn(table, predicate);
        }
        Column<?, Long> childPKColumn = tableJoinHolder.getChildPKColumn();
        Table childTable = childPKColumn.getTable();
        Column ctCollectionIdColumn = childTable.getColumn("ctCollectionId", Long.class);
        Predicate missingRequirementWherePredicate = tableJoinHolder.getMissingRequirementWherePredicate();
        return joinStep.where(missingRequirementWherePredicate.and((Expression)childPKColumn.in(ctEntryDSLQuery).and((Expression)ctCollectionIdColumn.eq((Object)this._sourceCTCollectionId))));
    }

    /*
     * Exception decompiling
     */
    private List<Long> _getModifiedPrimaryKeys(Connection connection, CTPersistence<T> ctPersistence, String primaryKeyName, boolean resolved) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PreparedStatement _getPreparedStatement(Connection connection, DSLQuery dslQuery) throws SQLException {
        DefaultASTNodeListener defaultASTNodeListener = new DefaultASTNodeListener();
        PreparedStatement preparedStatement = connection.prepareStatement(SQLTransformer.transform((String)dslQuery.toSQL((ASTNodeListener)defaultASTNodeListener)));
        List scalarValues = defaultASTNodeListener.getScalarValues();
        for (int i = 0; i < scalarValues.size(); ++i) {
            preparedStatement.setObject(i + 1, scalarValues.get(i));
        }
        return preparedStatement;
    }

    private void _resolveModificationConflicts(Connection connection, CTPersistence<T> ctPersistence, String primaryKeyName, List<Long> resolvedPrimaryKeys) {
        PreparedStatement preparedStatement;
        if (resolvedPrimaryKeys.isEmpty()) {
            return;
        }
        long tempCTCollectionId = -this._sourceCTCollectionId;
        StringBundler sb = new StringBundler(2 * resolvedPrimaryKeys.size() + 9);
        sb.append("update ");
        sb.append(ctPersistence.getTableName());
        sb.append(" set ctCollectionId = ");
        sb.append(tempCTCollectionId);
        sb.append(" where ctCollectionId = ");
        sb.append(this._sourceCTCollectionId);
        sb.append(" and ");
        sb.append(primaryKeyName);
        sb.append(" in (");
        int i = 0;
        for (long primaryKey : resolvedPrimaryKeys) {
            if (i == 1000) {
                sb.setStringAt(")", sb.index() - 1);
                sb.append(" or ");
                sb.append(primaryKeyName);
                sb.append(" in (");
                i = 0;
            }
            sb.append(primaryKey);
            sb.append(", ");
            ++i;
        }
        sb.setStringAt(")", sb.index() - 1);
        try {
            preparedStatement = connection.prepareStatement(sb.toString());
            Throwable primaryKey = null;
            try {
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable) {
                primaryKey = throwable;
                throw throwable;
            }
            finally {
                if (preparedStatement != null) {
                    if (primaryKey != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable) {
                            primaryKey.addSuppressed(throwable);
                        }
                    } else {
                        preparedStatement.close();
                    }
                }
            }
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
        for (long primaryKey : resolvedPrimaryKeys) {
            this._copyModificationConflictCTRow(connection, ctPersistence, primaryKeyName, primaryKey, tempCTCollectionId);
        }
        ctPersistence.clearCache(new HashSet<Long>(resolvedPrimaryKeys));
        sb = new StringBundler();
        sb.append("delete from ");
        sb.append(ctPersistence.getTableName());
        sb.append(" where ctCollectionId = ");
        sb.append(tempCTCollectionId);
        sb.append(" and ");
        sb.append(primaryKeyName);
        sb.append(" in (");
        i = 0;
        for (long primaryKey : resolvedPrimaryKeys) {
            if (i == 1000) {
                sb.setStringAt(")", sb.index() - 1);
                sb.append(" or ");
                sb.append(primaryKeyName);
                sb.append(" in (");
                i = 0;
            }
            sb.append(primaryKey);
            sb.append(", ");
            ++i;
        }
        sb.setStringAt(")", sb.index() - 1);
        try {
            preparedStatement = connection.prepareStatement(sb.toString());
            Throwable throwable = null;
            try {
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (preparedStatement != null) {
                    if (throwable != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        preparedStatement.close();
                    }
                }
            }
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
    }

    private void _updateModelMvccVersion(Connection connection, String primaryKeyName, String tableName, List<Long> unresolvedPrimaryKeys) {
        StringBundler sb = new StringBundler(2 * unresolvedPrimaryKeys.size() + 18);
        sb.append("select publication.");
        sb.append(primaryKeyName);
        sb.append(", publication.mvccVersion from ");
        sb.append(tableName);
        sb.append(" publication inner join CTEntry on publication.");
        sb.append(primaryKeyName);
        sb.append(" = CTEntry.modelClassPK and CTEntry.changeType = ");
        sb.append(2);
        sb.append(" and CTEntry.ctCollectionId = ");
        sb.append(this._sourceCTCollectionId);
        sb.append(" and CTEntry.modelClassNameId = ");
        sb.append(this._modelClassNameId);
        sb.append(" and publication.mvccVersion != CTEntry.modelMvccVersion");
        sb.append(" where publication.ctCollectionId = ");
        sb.append(this._targetCTCollectionId);
        if (!unresolvedPrimaryKeys.isEmpty()) {
            sb.append(" and publication.");
            sb.append(primaryKeyName);
            sb.append(" not in (");
            for (Long unresolvedPrimaryKey : unresolvedPrimaryKeys) {
                sb.append((Object)unresolvedPrimaryKey);
                sb.append(", ");
            }
            sb.setStringAt(")", sb.index() - 1);
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long pk = resultSet.getLong(1);
                CTEntry ctEntry = this._modificationCTEntries.get(pk);
                if (ctEntry == null) continue;
                this._ctEntryLocalService.updateModelMvccVersion(ctEntry.getCtEntryId(), resultSet.getLong(2));
            }
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
    }
}

