/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.background.task;

import com.liferay.change.tracking.conflict.ConflictInfo;
import com.liferay.change.tracking.exception.CTPublishConflictException;
import com.liferay.change.tracking.internal.CTServiceRegistry;
import com.liferay.change.tracking.internal.background.task.CTServicePublisher;
import com.liferay.change.tracking.internal.background.task.display.CTPublishBackgroundTaskDisplay;
import com.liferay.change.tracking.internal.helper.CTTableMapperHelper;
import com.liferay.change.tracking.internal.helper.CTUserNotificationHelper;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.service.CTSchemaVersionLocalService;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BaseBackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"background.task.executor.class.name=com.liferay.change.tracking.internal.background.task.CTPublishBackgroundTaskExecutor"}, service={AopService.class})
public class CTPublishBackgroundTaskExecutor
extends BaseBackgroundTaskExecutor
implements AopService {
    private static final Log _log = LogFactoryUtil.getLog(CTPublishBackgroundTaskExecutor.class);
    private BackgroundTaskExecutor _backgroundTaskExecutor;
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTSchemaVersionLocalService _ctSchemaVersionLocalService;
    @Reference
    private CTServiceRegistry _ctServiceRegistry;
    @Reference
    private CTUserNotificationHelper _ctUserNotificationHelper;
    @Reference
    private MultiVMPool _multiVMPool;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public CTPublishBackgroundTaskExecutor() {
        this.setIsolationLevel(2);
    }

    public BackgroundTaskExecutor clone() {
        return this._backgroundTaskExecutor;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        String toCTCollectionName;
        Map taskContextMap = backgroundTask.getTaskContextMap();
        long fromCTCollectionId = GetterUtil.getLong(taskContextMap.get("fromCTCollectionId"));
        CTCollection fromCTCollection = this._ctCollectionLocalService.getCTCollection(fromCTCollectionId);
        String fromCTCollectionName = fromCTCollection.getName();
        long toCTCollectionId = GetterUtil.getLong(taskContextMap.get("toCTCollectionId"));
        if (toCTCollectionId == 0L) {
            toCTCollectionName = "Production";
        } else {
            CTCollection toCTCollection = this._ctCollectionLocalService.getCTCollection(toCTCollectionId);
            toCTCollectionName = toCTCollection.getName();
        }
        if (!this._ctSchemaVersionLocalService.isLatestCTSchemaVersion(fromCTCollection.getSchemaVersionId())) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Unable to publish from ", fromCTCollectionName, " to ", toCTCollectionName, " because it is out of date with the current release"}));
        }
        if (toCTCollectionId == 0L) {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)fromCTCollectionId);){
                this._ctServiceRegistry.onBeforePublish(fromCTCollectionId);
            }
        }
        List ctEntries = null;
        long[] ctEntryIds = (long[])taskContextMap.get("ctEntryIds");
        ctEntries = ctEntryIds != null ? this._ctCollectionLocalService.getRelatedCTEntries(fromCTCollectionId, ctEntryIds) : this._ctEntryLocalService.getCTCollectionCTEntries(fromCTCollectionId);
        Map conflictInfosMap = this._ctCollectionLocalService.checkConflicts(fromCTCollection.getCompanyId(), ctEntries, fromCTCollectionId, fromCTCollectionName, toCTCollectionId, toCTCollectionName);
        if (!conflictInfosMap.isEmpty()) {
            ArrayList<ConflictInfo> unresolvedConflictInfos = new ArrayList<ConflictInfo>();
            for (Map.Entry entry : conflictInfosMap.entrySet()) {
                for (ConflictInfo conflictInfo : (List)entry.getValue()) {
                    if (conflictInfo.isResolved()) continue;
                    unresolvedConflictInfos.add(conflictInfo);
                }
            }
            if (!unresolvedConflictInfos.isEmpty()) {
                throw new CTPublishConflictException(StringBundler.concat((Object[])new Object[]{"Unable to publish from ", fromCTCollectionName, " to ", toCTCollectionName, " because of unresolved conflicts: ", unresolvedConflictInfos}));
            }
        }
        HashMap<Long, CTServicePublisher> ctServicePublishers = new HashMap<Long, CTServicePublisher>();
        for (CTEntry cTEntry : ctEntries) {
            CTServicePublisher ctServicePublisher = ctServicePublishers.computeIfAbsent(cTEntry.getModelClassNameId(), modelClassNameId -> {
                CTService<?> ctService = this._ctServiceRegistry.getCTService((long)modelClassNameId);
                if (ctService != null) {
                    return new CTServicePublisher(this._ctEntryLocalService, ctService, (long)modelClassNameId, fromCTCollectionId, toCTCollectionId);
                }
                throw new SystemException(StringBundler.concat((Object[])new Object[]{"Unable to publish from ", fromCTCollectionName, " to ", toCTCollectionName, " because service for ", modelClassNameId, " is missing"}));
            });
            ctServicePublisher.addCTEntry(cTEntry);
        }
        for (CTServicePublisher cTServicePublisher : ctServicePublishers.values()) {
            cTServicePublisher.publish();
        }
        for (CTTableMapperHelper cTTableMapperHelper : this._ctServiceRegistry.getCTTableMapperHelpers()) {
            cTTableMapperHelper.publish(fromCTCollectionId, toCTCollectionId, this._multiVMPool.getPortalCacheManager());
        }
        if (toCTCollectionId == 0L) {
            Date modifiedDate = new Date();
            fromCTCollection.setModifiedDate(modifiedDate);
            fromCTCollection.setStatus(0);
            fromCTCollection.setStatusByUserId(backgroundTask.getUserId());
            fromCTCollection.setStatusDate(modifiedDate);
            this._ctCollectionLocalService.updateCTCollection(fromCTCollection);
            this._ctServiceRegistry.onAfterPublish(fromCTCollectionId);
        } else {
            for (CTEntry cTEntry : ctEntries) {
                cTEntry.setCtCollectionId(toCTCollectionId);
                this._ctEntryLocalService.updateCTEntry(cTEntry);
            }
        }
        return BackgroundTaskResult.SUCCESS;
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{BackgroundTaskExecutor.class};
    }

    public BackgroundTaskDisplay getBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        return new CTPublishBackgroundTaskDisplay(backgroundTask);
    }

    public String handleException(BackgroundTask backgroundTask, Exception exception) {
        block3: {
            boolean showConflicts = false;
            if (exception instanceof CTPublishConflictException) {
                showConflicts = true;
            }
            long fromCTCollectionId = MapUtil.getLong((Map)backgroundTask.getTaskContextMap(), (String)"fromCTCollectionId");
            try {
                CTCollection fromCTCollection = this._ctCollectionLocalService.getCTCollection(fromCTCollectionId);
                this._ctUserNotificationHelper.sendUserNotificationEvents(fromCTCollection, JSONUtil.put((String)"backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId()).put("ctCollectionId", fromCTCollectionId).put("ctCollectionName", HtmlUtil.escape((String)fromCTCollection.getName())).put("notificationType", 2).put("showConflicts", showConflicts), this._getPublicationRolesUserIds(fromCTCollection, showConflicts));
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)portalException);
            }
        }
        return super.handleException(backgroundTask, exception);
    }

    public void setAopProxy(Object aopProxy) {
        this._backgroundTaskExecutor = (BackgroundTaskExecutor)aopProxy;
    }

    private long[] _getPublicationRolesUserIds(CTCollection ctCollection, boolean showConflicts) {
        Set userIds = SetUtil.fromArray((long[])this._ctUserNotificationHelper.getPublicationRoleUserIds(ctCollection, true, "com_liferay_change_tracking_web_portlet_PublicationsPortlet.admin", "com_liferay_change_tracking_web_portlet_PublicationsPortlet.editor", "com_liferay_change_tracking_web_portlet_PublicationsPortlet.publisher"));
        if (!showConflicts) {
            Role role = this._roleLocalService.fetchRole(ctCollection.getCompanyId(), "Administrator");
            for (long userId : this._userLocalService.getRoleUserIds(role.getRoleId())) {
                userIds.add(userId);
            }
        }
        return ArrayUtil.toLongArray((Collection)userIds);
    }
}

