/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal;

import com.liferay.change.tracking.internal.CTRowUtil;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class CTServiceCopier<T extends CTModel<T>> {
    private static final int _BATCH_SIZE = 1000;
    private List<CTEntry> _ctEntries;
    private final CTService<T> _ctService;
    private final long _sourceCTCollectionId;
    private final long _targetCTCollectionId;

    public CTServiceCopier(CTService<T> ctService, long sourceCTCollectionId, long targetCTCollectionId) {
        this._ctService = ctService;
        this._sourceCTCollectionId = sourceCTCollectionId;
        this._targetCTCollectionId = targetCTCollectionId;
    }

    public void addCTEntry(CTEntry ctEntry) {
        if (this._ctEntries == null) {
            this._ctEntries = new ArrayList<CTEntry>();
        }
        this._ctEntries.add(ctEntry);
    }

    public void copy() throws Exception {
        this._ctService.updateWithUnsafeFunction(this::_copy);
    }

    private Void _copy(CTPersistence<T> ctPersistence) throws Exception {
        String tableName = ctPersistence.getTableName();
        Set primaryKeyNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.PK);
        if (primaryKeyNames.size() != 1) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{primaryKeyNames=", primaryKeyNames, ", tableName=", tableName, "}"}));
        }
        Iterator iterator = primaryKeyNames.iterator();
        String primaryKeyName = (String)iterator.next();
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)ctPersistence.getDataSource());
        Map tableColumnsMap = ctPersistence.getTableColumnsMap();
        StringBundler sb = new StringBundler(3 * tableColumnsMap.size() + 5);
        sb.append("select ");
        for (String name : tableColumnsMap.keySet()) {
            if (name.equals("ctCollectionId")) {
                sb.append(this._targetCTCollectionId);
                sb.append(" as ");
            } else {
                sb.append("t1.");
            }
            sb.append(name);
            sb.append(", ");
        }
        sb.setStringAt(" from ", sb.index() - 1);
        sb.append(ctPersistence.getTableName());
        sb.append(" t1 where t1.ctCollectionId = ");
        sb.append(this._sourceCTCollectionId);
        sb.append(" and t1.");
        sb.append(primaryKeyName);
        sb.append(" in (");
        int i = 0;
        for (CTEntry ctEntry : this._ctEntries) {
            if (i == 1000) {
                sb.setStringAt(")", sb.index() - 1);
                sb.append(" or ");
                sb.append(tableName);
                sb.append(".");
                sb.append(primaryKeyName);
                sb.append(" in (");
                i = 0;
            }
            sb.append(ctEntry.getModelClassPK());
            sb.append(", ");
            ++i;
        }
        sb.setStringAt(")", sb.index() - 1);
        CTRowUtil.copyCTRows(ctPersistence, connection, sb.toString());
        return null;
    }
}

