/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal;

import com.liferay.change.tracking.internal.CTCollectionPreviewThreadLocal;
import com.liferay.change.tracking.model.CTPreferences;
import com.liferay.change.tracking.service.CTPreferencesLocalService;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionIdSupplier;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTCollectionIdSupplier.class})
public class CTCollectionIdSupplierImpl
implements CTCollectionIdSupplier {
    @Reference
    private CTPreferencesLocalService _ctPreferencesLocalService;

    public long getCTCollectionId() {
        long ctCollectionId = CTCollectionPreviewThreadLocal.getCTCollectionId();
        if (ctCollectionId > -1L) {
            return ctCollectionId;
        }
        long companyId = CompanyThreadLocal.getCompanyId();
        long userId = PrincipalThreadLocal.getUserId();
        if (companyId == 0L && userId == 0L) {
            return 0L;
        }
        CTPreferences ctPreferences = null;
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
            ctPreferences = this._ctPreferencesLocalService.fetchCTPreferences(companyId, userId);
        }
        if (ctPreferences == null) {
            return 0L;
        }
        return ctPreferences.getCtCollectionId();
    }
}

