/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.persistence.impl;

import com.liferay.change.tracking.exception.NoSuchSchemaVersionException;
import com.liferay.change.tracking.model.CTSchemaVersion;
import com.liferay.change.tracking.model.CTSchemaVersionTable;
import com.liferay.change.tracking.model.impl.CTSchemaVersionImpl;
import com.liferay.change.tracking.model.impl.CTSchemaVersionModelImpl;
import com.liferay.change.tracking.service.persistence.CTSchemaVersionPersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTSchemaVersionPersistence.class, BasePersistence.class})
public class CTSchemaVersionPersistenceImpl
extends BasePersistenceImpl<CTSchemaVersion>
implements CTSchemaVersionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CTSchemaVersionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "ctSchemaVersion.companyId = ?";
    private BundleContext _bundleContext;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_CTSCHEMAVERSION = "SELECT ctSchemaVersion FROM CTSchemaVersion ctSchemaVersion";
    private static final String _SQL_SELECT_CTSCHEMAVERSION_WHERE = "SELECT ctSchemaVersion FROM CTSchemaVersion ctSchemaVersion WHERE ";
    private static final String _SQL_COUNT_CTSCHEMAVERSION = "SELECT COUNT(ctSchemaVersion) FROM CTSchemaVersion ctSchemaVersion";
    private static final String _SQL_COUNT_CTSCHEMAVERSION_WHERE = "SELECT COUNT(ctSchemaVersion) FROM CTSchemaVersion ctSchemaVersion WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ctSchemaVersion.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CTSchemaVersion exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CTSchemaVersion exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CTSchemaVersionPersistenceImpl.class);
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<CTSchemaVersion> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<CTSchemaVersion> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<CTSchemaVersion> findByCompanyId(long companyId, int start, int end, OrderByComparator<CTSchemaVersion> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<CTSchemaVersion> findByCompanyId(long companyId, int start, int end, OrderByComparator<CTSchemaVersion> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (CTSchemaVersion ctSchemaVersion : list) {
                if (companyId == ctSchemaVersion.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_CTSCHEMAVERSION_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ctSchemaVersion.schemaVersionId DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CTSchemaVersion findByCompanyId_First(long companyId, OrderByComparator<CTSchemaVersion> orderByComparator) throws NoSuchSchemaVersionException {
        CTSchemaVersion ctSchemaVersion = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (ctSchemaVersion != null) {
            return ctSchemaVersion;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchSchemaVersionException(sb.toString());
    }

    public CTSchemaVersion fetchByCompanyId_First(long companyId, OrderByComparator<CTSchemaVersion> orderByComparator) {
        List<CTSchemaVersion> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CTSchemaVersion findByCompanyId_Last(long companyId, OrderByComparator<CTSchemaVersion> orderByComparator) throws NoSuchSchemaVersionException {
        CTSchemaVersion ctSchemaVersion = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (ctSchemaVersion != null) {
            return ctSchemaVersion;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchSchemaVersionException(sb.toString());
    }

    public CTSchemaVersion fetchByCompanyId_Last(long companyId, OrderByComparator<CTSchemaVersion> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<CTSchemaVersion> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CTSchemaVersion[] findByCompanyId_PrevAndNext(long schemaVersionId, long companyId, OrderByComparator<CTSchemaVersion> orderByComparator) throws NoSuchSchemaVersionException {
        CTSchemaVersion ctSchemaVersion = this.findByPrimaryKey(schemaVersionId);
        Session session = null;
        try {
            session = this.openSession();
            CTSchemaVersion[] array = new CTSchemaVersionImpl[]{this.getByCompanyId_PrevAndNext(session, ctSchemaVersion, companyId, orderByComparator, true), ctSchemaVersion, this.getByCompanyId_PrevAndNext(session, ctSchemaVersion, companyId, orderByComparator, false)};
            CTSchemaVersion[] cTSchemaVersionArray = array;
            return cTSchemaVersionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CTSchemaVersion getByCompanyId_PrevAndNext(Session session, CTSchemaVersion ctSchemaVersion, long companyId, OrderByComparator<CTSchemaVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_CTSCHEMAVERSION_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ctSchemaVersion.schemaVersionId DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ctSchemaVersion)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CTSchemaVersion)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (CTSchemaVersion ctSchemaVersion : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)ctSchemaVersion);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_CTSCHEMAVERSION_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CTSchemaVersionPersistenceImpl() {
        this.setModelClass(CTSchemaVersion.class);
        this.setModelImplClass(CTSchemaVersionImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CTSchemaVersionTable.INSTANCE);
    }

    public void cacheResult(CTSchemaVersion ctSchemaVersion) {
        this.entityCache.putResult(CTSchemaVersionImpl.class, (Serializable)Long.valueOf(ctSchemaVersion.getPrimaryKey()), (Serializable)ctSchemaVersion);
    }

    public void cacheResult(List<CTSchemaVersion> ctSchemaVersions) {
        for (CTSchemaVersion ctSchemaVersion : ctSchemaVersions) {
            if (this.entityCache.getResult(CTSchemaVersionImpl.class, (Serializable)Long.valueOf(ctSchemaVersion.getPrimaryKey())) != null) continue;
            this.cacheResult(ctSchemaVersion);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CTSchemaVersionImpl.class);
        this.finderCache.clearCache(CTSchemaVersionImpl.class);
    }

    public void clearCache(CTSchemaVersion ctSchemaVersion) {
        this.entityCache.removeResult(CTSchemaVersionImpl.class, (BaseModel)ctSchemaVersion);
    }

    public void clearCache(List<CTSchemaVersion> ctSchemaVersions) {
        for (CTSchemaVersion ctSchemaVersion : ctSchemaVersions) {
            this.entityCache.removeResult(CTSchemaVersionImpl.class, (BaseModel)ctSchemaVersion);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(CTSchemaVersionImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CTSchemaVersionImpl.class, primaryKey);
        }
    }

    public CTSchemaVersion create(long schemaVersionId) {
        CTSchemaVersionImpl ctSchemaVersion = new CTSchemaVersionImpl();
        ctSchemaVersion.setNew(true);
        ctSchemaVersion.setPrimaryKey(schemaVersionId);
        ctSchemaVersion.setCompanyId(CompanyThreadLocal.getCompanyId());
        return ctSchemaVersion;
    }

    public CTSchemaVersion remove(long schemaVersionId) throws NoSuchSchemaVersionException {
        return this.remove(Long.valueOf(schemaVersionId));
    }

    public CTSchemaVersion remove(Serializable primaryKey) throws NoSuchSchemaVersionException {
        Session session = null;
        try {
            session = this.openSession();
            CTSchemaVersion ctSchemaVersion = (CTSchemaVersion)session.get(CTSchemaVersionImpl.class, primaryKey);
            if (ctSchemaVersion == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchSchemaVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CTSchemaVersion cTSchemaVersion = (CTSchemaVersion)this.remove((BaseModel)ctSchemaVersion);
            return cTSchemaVersion;
        }
        catch (NoSuchSchemaVersionException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CTSchemaVersion removeImpl(CTSchemaVersion ctSchemaVersion) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)ctSchemaVersion)) {
                ctSchemaVersion = (CTSchemaVersion)session.get(CTSchemaVersionImpl.class, ctSchemaVersion.getPrimaryKeyObj());
            }
            if (ctSchemaVersion != null) {
                session.delete((Object)ctSchemaVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (ctSchemaVersion != null) {
            this.clearCache(ctSchemaVersion);
        }
        return ctSchemaVersion;
    }

    public CTSchemaVersion updateImpl(CTSchemaVersion ctSchemaVersion) {
        boolean isNew = ctSchemaVersion.isNew();
        if (!(ctSchemaVersion instanceof CTSchemaVersionModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ctSchemaVersion.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)ctSchemaVersion);
                throw new IllegalArgumentException("Implement ModelWrapper in ctSchemaVersion proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CTSchemaVersion implementation " + ctSchemaVersion.getClass());
        }
        CTSchemaVersionModelImpl ctSchemaVersionModelImpl = (CTSchemaVersionModelImpl)ctSchemaVersion;
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)ctSchemaVersion);
            } else {
                ctSchemaVersion = (CTSchemaVersion)session.merge((Object)ctSchemaVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(CTSchemaVersionImpl.class, (BaseModel)ctSchemaVersionModelImpl, false, true);
        if (isNew) {
            ctSchemaVersion.setNew(false);
        }
        ctSchemaVersion.resetOriginalValues();
        return ctSchemaVersion;
    }

    public CTSchemaVersion findByPrimaryKey(Serializable primaryKey) throws NoSuchSchemaVersionException {
        CTSchemaVersion ctSchemaVersion = (CTSchemaVersion)this.fetchByPrimaryKey(primaryKey);
        if (ctSchemaVersion == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchSchemaVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ctSchemaVersion;
    }

    public CTSchemaVersion findByPrimaryKey(long schemaVersionId) throws NoSuchSchemaVersionException {
        return this.findByPrimaryKey(Long.valueOf(schemaVersionId));
    }

    public CTSchemaVersion fetchByPrimaryKey(long schemaVersionId) {
        return (CTSchemaVersion)this.fetchByPrimaryKey(Long.valueOf(schemaVersionId));
    }

    public List<CTSchemaVersion> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CTSchemaVersion> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CTSchemaVersion> findAll(int start, int end, OrderByComparator<CTSchemaVersion> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CTSchemaVersion> findAll(int start, int end, OrderByComparator<CTSchemaVersion> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_CTSCHEMAVERSION);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_CTSCHEMAVERSION;
                sql = sql.concat(" ORDER BY ctSchemaVersion.schemaVersionId DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CTSchemaVersion ctSchemaVersion : this.findAll()) {
            this.remove((BaseModel)ctSchemaVersion);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_CTSCHEMAVERSION);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "schemaVersionId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_CTSCHEMAVERSION;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CTSchemaVersionModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new CTSchemaVersionModelArgumentsResolver(), (Dictionary)new HashMapDictionary());
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(CTSchemaVersionImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.change.tracking.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.change.tracking.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.change.tracking.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    private static class CTSchemaVersionModelArgumentsResolver
    implements ArgumentsResolver {
        private static Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private CTSchemaVersionModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            CTSchemaVersionModelImpl ctSchemaVersionModelImpl = (CTSchemaVersionModelImpl)baseModel;
            long columnBitmask = ctSchemaVersionModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return this._getValue(ctSchemaVersionModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | CTSchemaVersionModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return this._getValue(ctSchemaVersionModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return CTSchemaVersionImpl.class.getName();
        }

        public String getTableName() {
            return CTSchemaVersionTable.INSTANCE.getTableName();
        }

        private Object[] _getValue(CTSchemaVersionModelImpl ctSchemaVersionModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? ctSchemaVersionModelImpl.getColumnOriginalValue(columnName) : ctSchemaVersionModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

