/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.conflict;

import com.liferay.change.tracking.conflict.ConflictInfo;
import com.liferay.change.tracking.internal.CTRowUtil;
import com.liferay.change.tracking.internal.conflict.AdditionConflictInfo;
import com.liferay.change.tracking.internal.conflict.ConstraintResolverConflictInfo;
import com.liferay.change.tracking.internal.conflict.DefaultConstraintConflictInfo;
import com.liferay.change.tracking.internal.conflict.DeletionModificationConflictInfo;
import com.liferay.change.tracking.internal.conflict.MissingRequirementConflictInfo;
import com.liferay.change.tracking.internal.conflict.ModificationConflictInfo;
import com.liferay.change.tracking.internal.conflict.ModificationDeletionConflictInfo;
import com.liferay.change.tracking.internal.reference.TableJoinHolder;
import com.liferay.change.tracking.internal.reference.TableReferenceDefinitionManager;
import com.liferay.change.tracking.internal.reference.TableReferenceInfo;
import com.liferay.change.tracking.internal.resolver.ConstraintResolverContextImpl;
import com.liferay.change.tracking.internal.resolver.ConstraintResolverKey;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.model.CTEntryTable;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.spi.display.CTDisplayRenderer;
import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.query.WhereStep;
import com.liferay.petra.sql.dsl.spi.ast.DefaultASTNodeListener;
import com.liferay.petra.sql.dsl.spi.query.Join;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class CTConflictChecker<T extends CTModel<T>> {
    private final ClassNameLocalService _classNameLocalService;
    private final ServiceTrackerMap<ConstraintResolverKey, ConstraintResolver<?>> _constraintResolverServiceTrackerMap;
    private final ServiceTrackerMap<String, CTDisplayRenderer<?>> _ctDisplayRendererServiceTrackerMap;
    private final CTEntryLocalService _ctEntryLocalService;
    private final CTService<T> _ctService;
    private final long _modelClassNameId;
    private Map<Serializable, CTEntry> _modificationCTEntries;
    private final long _sourceCTCollectionId;
    private final TableReferenceDefinitionManager _tableReferenceDefinitionManager;
    private final long _targetCTCollectionId;

    public CTConflictChecker(ClassNameLocalService classNameLocalService, ServiceTrackerMap<ConstraintResolverKey, ConstraintResolver<?>> constraintResolverServiceTrackerMap, ServiceTrackerMap<String, CTDisplayRenderer<?>> ctDisplayRendererServiceTrackerMap, CTEntryLocalService ctEntryLocalService, CTService<T> ctService, long modelClassNameId, long sourceCTCollectionId, TableReferenceDefinitionManager tableReferenceDefinitionManager, long targetCTCollectionId) {
        this._classNameLocalService = classNameLocalService;
        this._constraintResolverServiceTrackerMap = constraintResolverServiceTrackerMap;
        this._ctDisplayRendererServiceTrackerMap = ctDisplayRendererServiceTrackerMap;
        this._ctEntryLocalService = ctEntryLocalService;
        this._ctService = ctService;
        this._modelClassNameId = modelClassNameId;
        this._sourceCTCollectionId = sourceCTCollectionId;
        this._tableReferenceDefinitionManager = tableReferenceDefinitionManager;
        this._targetCTCollectionId = targetCTCollectionId;
    }

    public void addCTEntry(CTEntry ctEntry) {
        if (ctEntry.getChangeType() == 2) {
            if (this._modificationCTEntries == null) {
                this._modificationCTEntries = new HashMap<Serializable, CTEntry>();
            }
            this._modificationCTEntries.put(Long.valueOf(ctEntry.getModelClassPK()), ctEntry);
        }
    }

    public List<ConflictInfo> check() throws PortalException {
        return (List)this._ctService.updateWithUnsafeFunction(this::_check);
    }

    private List<ConflictInfo> _check(CTPersistence<T> ctPersistence) throws PortalException {
        List uniqueIndexColumnNames;
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)ctPersistence.getDataSource());
        Set primaryKeyNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.PK);
        if (primaryKeyNames.size() != 1) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{ctPersistence=", ctPersistence, ", primaryKeyNames=", primaryKeyNames, "}"}));
        }
        Iterator iterator = primaryKeyNames.iterator();
        String primaryKeyName = (String)iterator.next();
        ArrayList<ConflictInfo> conflictInfos = new ArrayList<ConflictInfo>();
        this._checkAdditions(connection, ctPersistence, conflictInfos, primaryKeyName);
        this._checkDeletions(connection, ctPersistence, conflictInfos, primaryKeyName);
        if (this._modificationCTEntries != null) {
            this._checkModifications(connection, ctPersistence, conflictInfos, primaryKeyName);
        }
        if (!(uniqueIndexColumnNames = ctPersistence.getUniqueIndexColumnNames()).isEmpty()) {
            for (String[] columnNames : uniqueIndexColumnNames) {
                this._checkConstraint(connection, ctPersistence, conflictInfos, primaryKeyName, columnNames);
            }
        }
        this._checkMissingRequirements(connection, ctPersistence, conflictInfos);
        return conflictInfos;
    }

    private void _checkAdditions(Connection connection, CTPersistence<T> ctPersistence, List<ConflictInfo> conflictInfos, String primaryKeyName) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select publication.", primaryKeyName, " from ", ctPersistence.getTableName(), " publication inner join CTEntry on CTEntry.modelClassPK ", "= publication.", primaryKeyName, " where CTEntry.ctCollectionId = ", this._sourceCTCollectionId, " and CTEntry.modelClassNameId = ", this._modelClassNameId, " and CTEntry.changeType = ", 0, " and publication.ctCollectionId = ", this._targetCTCollectionId}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                conflictInfos.add(new AdditionConflictInfo(resultSet.getLong(1)));
            }
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
    }

    private void _checkConstraint(Connection connection, CTPersistence<T> ctPersistence, List<ConflictInfo> conflictInfos, String primaryKeyName, String[] columnNames) throws PortalException {
        String constraintConflictsSQL = CTRowUtil.getConstraintConflictsSQL(ctPersistence.getTableName(), primaryKeyName, columnNames, this._sourceCTCollectionId, this._targetCTCollectionId);
        List<Map.Entry<Long, Long>> nextPrimaryKeys = this._getConflictingPrimaryKeys(connection, constraintConflictsSQL);
        if (nextPrimaryKeys.isEmpty()) {
            return;
        }
        ConstraintResolver constraintResolver = (ConstraintResolver)this._constraintResolverServiceTrackerMap.getService((Object)new ConstraintResolverKey(ctPersistence.getModelClass(), columnNames));
        if (constraintResolver == null) {
            StringBundler sb = new StringBundler(2 * columnNames.length);
            for (String columnName : columnNames) {
                sb.append(columnName);
                sb.append(", ");
            }
            sb.setIndex(sb.index() - 1);
            String columnNamesString = sb.toString();
            for (Map.Entry<Long, Long> currentPrimaryKeys : nextPrimaryKeys) {
                conflictInfos.add(new DefaultConstraintConflictInfo(currentPrimaryKeys.getKey(), currentPrimaryKeys.getValue(), columnNamesString));
            }
            return;
        }
        ConstraintResolverContextImpl<T> constraintResolverContextImpl = new ConstraintResolverContextImpl<T>(this._ctService, this._sourceCTCollectionId, this._targetCTCollectionId);
        HashSet<Map.Entry<Long, Long>> attemptedPrimaryKeys = new HashSet<Map.Entry<Long, Long>>();
        HashSet<Map.Entry<Long, Long>> resolvedPrimaryKeys = new HashSet<Map.Entry<Long, Long>>(nextPrimaryKeys);
        while (!nextPrimaryKeys.isEmpty()) {
            Map.Entry<Long, Long> currentPrimaryKeys = nextPrimaryKeys.get(0);
            constraintResolverContextImpl.setPrimaryKeys(currentPrimaryKeys.getKey(), currentPrimaryKeys.getValue());
            constraintResolver.resolveConflict(constraintResolverContextImpl);
            Session session = ctPersistence.getCurrentSession();
            session.flush();
            session.clear();
            attemptedPrimaryKeys.add(currentPrimaryKeys);
            nextPrimaryKeys = this._getConflictingPrimaryKeys(connection, constraintConflictsSQL);
            resolvedPrimaryKeys.addAll(nextPrimaryKeys);
            nextPrimaryKeys.removeAll(attemptedPrimaryKeys);
        }
        List<Map.Entry<Long, Long>> unresolvedPrimaryKeys = this._getConflictingPrimaryKeys(connection, constraintConflictsSQL);
        resolvedPrimaryKeys.removeAll(unresolvedPrimaryKeys);
        for (Map.Entry entry : resolvedPrimaryKeys) {
            conflictInfos.add(new ConstraintResolverConflictInfo(constraintResolver, true, (Long)entry.getKey(), (Long)entry.getValue()));
        }
        if (unresolvedPrimaryKeys.isEmpty()) {
            return;
        }
        for (Map.Entry entry : unresolvedPrimaryKeys) {
            conflictInfos.add(new ConstraintResolverConflictInfo(constraintResolver, false, (Long)entry.getKey(), (Long)entry.getValue()));
        }
    }

    private void _checkDeletions(Connection connection, CTPersistence<T> ctPersistence, List<ConflictInfo> conflictInfos, String primaryKeyName) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select publication.", primaryKeyName, " from ", ctPersistence.getTableName(), " publication inner join CTEntry on CTEntry.modelClassPK ", "= publication.", primaryKeyName, " where CTEntry.ctCollectionId = ", this._sourceCTCollectionId, " and CTEntry.modelClassNameId = ", this._modelClassNameId, " and CTEntry.changeType = ", 1, " and publication.ctCollectionId = ", this._targetCTCollectionId, " and CTEntry.modelMvccVersion != ", "publication.mvccVersion"}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                conflictInfos.add(new ModificationDeletionConflictInfo(resultSet.getLong(1)));
            }
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
    }

    private void _checkMissingRequirements(Connection connection, CTPersistence<T> ctPersistence, List<ConflictInfo> conflictInfos) throws PortalException {
        if (!this._ctEntryLocalService.hasCTEntries(this._sourceCTCollectionId, this._modelClassNameId)) {
            return;
        }
        GroupByStep ctEntryDSLQuery = DSLQueryFactoryUtil.select((Expression[])new Expression[]{CTEntryTable.INSTANCE.modelClassPK}).from((Table)CTEntryTable.INSTANCE).where(CTEntryTable.INSTANCE.ctCollectionId.eq((Object)this._sourceCTCollectionId).and((Expression)CTEntryTable.INSTANCE.modelClassNameId.eq((Object)this._modelClassNameId)).and((Expression)CTEntryTable.INSTANCE.changeType.eq((Object)0)));
        Map<Long, TableReferenceInfo<?>> combinedTableReferenceInfos = this._tableReferenceDefinitionManager.getCombinedTableReferenceInfos();
        TableReferenceInfo<?> tableReferenceInfo = combinedTableReferenceInfos.get(this._modelClassNameId);
        if (tableReferenceInfo == null) {
            throw new IllegalArgumentException("No table reference definition for " + ctPersistence.getModelClass());
        }
        DSLQuery dslQuery = null;
        Map<Table<?>, List<TableJoinHolder>> parentTableJoinHoldersMap = tableReferenceInfo.getParentTableJoinHoldersMap();
        for (List<TableJoinHolder> tableJoinHolders : parentTableJoinHoldersMap.values()) {
            for (TableJoinHolder tableJoinHolder : tableJoinHolders) {
                if (tableJoinHolder.isReversed()) continue;
                DSLQuery nextDSLQuery = this._getMissingRequirementsDSLQuery((DSLQuery)ctEntryDSLQuery, tableJoinHolder);
                if (dslQuery == null) {
                    dslQuery = nextDSLQuery;
                    continue;
                }
                dslQuery = dslQuery.union(nextDSLQuery);
            }
        }
        if (dslQuery != null) {
            try (PreparedStatement preparedStatement = this._getPreparedStatement(connection, dslQuery);
                 ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    long modelClassPK = resultSet.getLong(1);
                    String tableName = resultSet.getString(2);
                    ClassName className = this._classNameLocalService.getClassName(this._tableReferenceDefinitionManager.getClassNameId(tableName));
                    String classNameValue = className.getValue();
                    conflictInfos.add(new MissingRequirementConflictInfo(classNameValue, modelClassPK, (CTDisplayRenderer)this._ctDisplayRendererServiceTrackerMap.getService((Object)classNameValue)));
                }
            }
            catch (SQLException sqlException) {
                throw new ORMException("Unable to execute query: " + dslQuery, (Throwable)sqlException);
            }
        }
    }

    private void _checkModifications(Connection connection, CTPersistence<T> ctPersistence, List<ConflictInfo> conflictInfos, String primaryKeyName) {
        List<Long> resolvedPrimaryKeys = this._getModifiedPrimaryKeys(connection, ctPersistence, primaryKeyName, true);
        for (Long l : resolvedPrimaryKeys) {
            conflictInfos.add(new ModificationConflictInfo(l, true));
        }
        this._resolveModificationConflicts(connection, ctPersistence, primaryKeyName, resolvedPrimaryKeys);
        List<Long> unresolvedPrimaryKeys = this._getModifiedPrimaryKeys(connection, ctPersistence, primaryKeyName, false);
        for (Long unresolvedPrimaryKey : unresolvedPrimaryKeys) {
            conflictInfos.add(new ModificationConflictInfo(unresolvedPrimaryKey, false));
        }
        this._updateModelMvccVersion(connection, primaryKeyName, ctPersistence.getTableName(), unresolvedPrimaryKeys);
        List<Long> list = this._getDeletionModificationPKs(connection, ctPersistence, primaryKeyName);
        for (long deletionModificationPK : list) {
            conflictInfos.add(new DeletionModificationConflictInfo(deletionModificationPK));
        }
    }

    /*
     * Exception decompiling
     */
    private List<Map.Entry<Long, Long>> _getConflictingPrimaryKeys(Connection connection, String constraintConflictsSQL) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private List<Long> _getDeletionModificationPKs(Connection connection, CTPersistence<T> ctPersistence, String primaryKeyName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DSLQuery _getMissingRequirementsDSLQuery(DSLQuery ctEntryDSLQuery, TableJoinHolder tableJoinHolder) {
        Column ctCollectionIdColumn;
        Join join;
        WhereStep whereStep = tableJoinHolder.getMissingRequirementWhereStep();
        LinkedList<Join> joins = new LinkedList<Join>();
        WhereStep astNode = whereStep;
        while (astNode instanceof Join) {
            join = (Join)astNode;
            joins.push(join);
            astNode = join.getChild();
        }
        join = null;
        JoinStep joinStep = (JoinStep)astNode;
        while ((join = (Join)joins.poll()) != null) {
            Predicate predicate = join.getOnPredicate();
            Table table = join.getTable();
            ctCollectionIdColumn = table.getColumn("ctCollectionId", Long.class);
            if (ctCollectionIdColumn != null) {
                predicate = predicate.and((Expression)ctCollectionIdColumn.in((Object[])new Long[]{this._sourceCTCollectionId, this._targetCTCollectionId}));
            }
            joinStep = joinStep.leftJoinOn(table, predicate);
        }
        Column<?, Long> childPKColumn = tableJoinHolder.getChildPKColumn();
        Table childTable = childPKColumn.getTable();
        ctCollectionIdColumn = childTable.getColumn("ctCollectionId", Long.class);
        Predicate missingRequirementWherePredicate = tableJoinHolder.getMissingRequirementWherePredicate();
        return joinStep.where(missingRequirementWherePredicate.and((Expression)childPKColumn.in(ctEntryDSLQuery).and((Expression)ctCollectionIdColumn.eq((Object)this._sourceCTCollectionId))));
    }

    /*
     * Exception decompiling
     */
    private List<Long> _getModifiedPrimaryKeys(Connection connection, CTPersistence<T> ctPersistence, String primaryKeyName, boolean resolved) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PreparedStatement _getPreparedStatement(Connection connection, DSLQuery dslQuery) throws SQLException {
        DefaultASTNodeListener defaultASTNodeListener = new DefaultASTNodeListener();
        PreparedStatement preparedStatement = connection.prepareStatement(SQLTransformer.transform((String)dslQuery.toSQL((ASTNodeListener)defaultASTNodeListener)));
        List scalarValues = defaultASTNodeListener.getScalarValues();
        for (int i = 0; i < scalarValues.size(); ++i) {
            preparedStatement.setObject(i + 1, scalarValues.get(i));
        }
        return preparedStatement;
    }

    private void _resolveModificationConflicts(Connection connection, CTPersistence<T> ctPersistence, String primaryKeyName, List<Long> resolvedPrimaryKeys) {
        if (resolvedPrimaryKeys.isEmpty()) {
            return;
        }
        long tempCTCollectionId = -this._sourceCTCollectionId;
        StringBundler sb = new StringBundler(2 * resolvedPrimaryKeys.size() + 9);
        sb.append("update ");
        sb.append(ctPersistence.getTableName());
        sb.append(" set ctCollectionId = ");
        sb.append(tempCTCollectionId);
        sb.append(" where ctCollectionId = ");
        sb.append(this._sourceCTCollectionId);
        sb.append(" and ");
        sb.append(primaryKeyName);
        sb.append(" in (");
        for (Long l : resolvedPrimaryKeys) {
            sb.append((Object)l);
            sb.append(", ");
        }
        sb.setStringAt(")", sb.index() - 1);
        try {
            Throwable throwable = null;
            try (PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());){
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
        sb = new StringBundler("select ");
        Map tableColumnsMap = ctPersistence.getTableColumnsMap();
        Set set = ctPersistence.getCTColumnNames(CTColumnResolutionType.IGNORE);
        Set maxColumnNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.MAX);
        Set minColumnNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.MIN);
        for (String name : tableColumnsMap.keySet()) {
            if (name.equals("ctCollectionId")) {
                sb.append(this._sourceCTCollectionId);
                sb.append(" as ");
            } else if (name.equals("mvccVersion")) {
                sb.append("(publication.mvccVersion + 1) ");
            } else if (set.contains(name)) {
                sb.append("production.");
            } else if (maxColumnNames.contains(name) || minColumnNames.contains(name)) {
                sb.append("composite.");
            } else {
                sb.append("publication.");
            }
            sb.append(name);
            sb.append(", ");
        }
        sb.setStringAt(" from ", sb.index() - 1);
        sb.append(ctPersistence.getTableName());
        sb.append(" production inner join ");
        sb.append(ctPersistence.getTableName());
        sb.append(" publication on production.");
        sb.append(primaryKeyName);
        sb.append(" = publication.");
        sb.append(primaryKeyName);
        if (!maxColumnNames.isEmpty() || !minColumnNames.isEmpty()) {
            sb.append(" inner join (select ");
            sb.append(primaryKeyName);
            for (String maxColumnName : maxColumnNames) {
                sb.append(", max(");
                sb.append(maxColumnName);
                sb.append(") ");
                sb.append(maxColumnName);
            }
            for (String minColumnName : minColumnNames) {
                sb.append(", min(");
                sb.append(minColumnName);
                sb.append(") ");
                sb.append(minColumnName);
            }
            sb.append(" from ");
            sb.append(ctPersistence.getTableName());
            sb.append(" where ctCollectionId in (");
            sb.append(this._targetCTCollectionId);
            sb.append(", ");
            sb.append(tempCTCollectionId);
            sb.append(") group by ");
            sb.append(primaryKeyName);
            sb.append(") composite on composite.");
            sb.append(primaryKeyName);
            sb.append(" = production.");
            sb.append(primaryKeyName);
        }
        sb.append(" where publication.ctCollectionId = ");
        sb.append(tempCTCollectionId);
        sb.append(" and production.ctCollectionId = ");
        sb.append(this._targetCTCollectionId);
        try {
            CTRowUtil.copyCTRows(ctPersistence, connection, sb.toString());
            ctPersistence.clearCache(new HashSet<Long>(resolvedPrimaryKeys));
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"delete from ", ctPersistence.getTableName(), " where ctCollectionId = ", tempCTCollectionId}));){
            preparedStatement.executeUpdate();
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
    }

    private void _updateModelMvccVersion(Connection connection, String primaryKeyName, String tableName, List<Long> unresolvedPrimaryKeys) {
        StringBundler sb = new StringBundler(2 * unresolvedPrimaryKeys.size() + 18);
        sb.append("select publication.");
        sb.append(primaryKeyName);
        sb.append(", publication.mvccVersion from ");
        sb.append(tableName);
        sb.append(" publication inner join CTEntry on publication.");
        sb.append(primaryKeyName);
        sb.append(" = CTEntry.modelClassPK and CTEntry.changeType = ");
        sb.append(2);
        sb.append(" and CTEntry.ctCollectionId = ");
        sb.append(this._sourceCTCollectionId);
        sb.append(" and CTEntry.modelClassNameId = ");
        sb.append(this._modelClassNameId);
        sb.append(" and publication.mvccVersion != CTEntry.modelMvccVersion");
        sb.append(" where publication.ctCollectionId = ");
        sb.append(this._targetCTCollectionId);
        if (!unresolvedPrimaryKeys.isEmpty()) {
            sb.append(" and publication.");
            sb.append(primaryKeyName);
            sb.append(" not in (");
            for (Long unresolvedPrimaryKey : unresolvedPrimaryKeys) {
                sb.append((Object)unresolvedPrimaryKey);
                sb.append(", ");
            }
            sb.setStringAt(")", sb.index() - 1);
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long pk = resultSet.getLong(1);
                long mvccVersion = resultSet.getLong(2);
                CTEntry ctEntry = this._modificationCTEntries.get(pk);
                ctEntry.setModifiedDate(ctEntry.getModifiedDate());
                ctEntry.setModelMvccVersion(mvccVersion);
                this._ctEntryLocalService.updateCTEntry(ctEntry);
            }
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
    }
}

