/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTCollectionTable;
import com.liferay.change.tracking.model.CTProcess;
import com.liferay.change.tracking.model.CTProcessTable;
import com.liferay.change.tracking.service.base.CTProcessServiceBaseImpl;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.LimitStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.sql.dsl.query.sort.OrderByInfo;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.background.task.model.BackgroundTaskTable;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ct", "json.web.service.context.path=CTProcess"}, service={AopService.class})
public class CTProcessServiceImpl
extends CTProcessServiceBaseImpl {
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private InlineSQLHelper _inlineSQLHelper;

    public List<CTProcess> getCTProcesses(long companyId, long userId, String keywords, int status, int start, int end, OrderByComparator<CTProcess> orderByComparator) {
        DSLQuery dslQuery = DSLQueryFactoryUtil.select((Table)CTProcessTable.INSTANCE).from((Table)CTProcessTable.INSTANCE).innerJoinON((Table)CTCollectionTable.INSTANCE, CTCollectionTable.INSTANCE.ctCollectionId.eq((Expression)CTProcessTable.INSTANCE.ctCollectionId)).innerJoinON((Table)BackgroundTaskTable.INSTANCE, BackgroundTaskTable.INSTANCE.backgroundTaskId.eq((Expression)CTProcessTable.INSTANCE.backgroundTaskId)).where(this._getPredicate(companyId, keywords, status, userId)).orderBy(orderByStep -> {
            if (orderByComparator != null) {
                LimitStep limitStep = orderByStep.orderBy((Table)CTCollectionTable.INSTANCE, (OrderByInfo)orderByComparator);
                if (limitStep == orderByStep) {
                    return orderByStep.orderBy((Table)CTProcessTable.INSTANCE, (OrderByInfo)orderByComparator);
                }
                return limitStep;
            }
            return orderByStep.orderBy(new OrderByExpression[]{CTProcessTable.INSTANCE.createDate.descending()});
        }).limit(start, end);
        return (List)this.ctProcessPersistence.dslQuery(dslQuery);
    }

    public int getCTProcessesCount(long companyId, long userId, String keywords, int status) {
        GroupByStep dslQuery = DSLQueryFactoryUtil.count().from((Table)CTProcessTable.INSTANCE).innerJoinON((Table)CTCollectionTable.INSTANCE, CTCollectionTable.INSTANCE.ctCollectionId.eq((Expression)CTProcessTable.INSTANCE.ctCollectionId)).innerJoinON((Table)BackgroundTaskTable.INSTANCE, BackgroundTaskTable.INSTANCE.backgroundTaskId.eq((Expression)CTProcessTable.INSTANCE.backgroundTaskId)).where(this._getPredicate(companyId, keywords, status, userId));
        Long count = (Long)this.ctProcessPersistence.dslQuery((DSLQuery)dslQuery);
        return count.intValue();
    }

    private Predicate _getPredicate(long companyId, String keywords, int status, long userId) {
        Predicate predicate = CTProcessTable.INSTANCE.companyId.eq((Object)companyId);
        if (userId > 0L) {
            predicate = predicate.and((Expression)CTProcessTable.INSTANCE.userId.eq((Object)userId));
        }
        if (status != -1) {
            predicate = predicate.and((Expression)BackgroundTaskTable.INSTANCE.status.eq((Object)status));
        }
        Predicate keywordsPredicate = null;
        for (String keyword : this._customSQL.keywords(keywords, true, WildcardMode.SURROUND)) {
            if (keyword == null) continue;
            Predicate keywordPredicate = DSLFunctionFactoryUtil.lower((Expression)CTCollectionTable.INSTANCE.name).like(keyword).or((Expression)DSLFunctionFactoryUtil.lower((Expression)CTCollectionTable.INSTANCE.description).like(keyword));
            keywordsPredicate = keywordsPredicate == null ? keywordPredicate : keywordsPredicate.or((Expression)keywordPredicate);
        }
        if (keywordsPredicate != null) {
            predicate = predicate.and((Expression)keywordsPredicate.withParentheses());
        }
        return predicate.and((Expression)this._inlineSQLHelper.getPermissionWherePredicate(CTCollection.class, CTCollectionTable.INSTANCE.ctCollectionId, new long[0]));
    }
}

