/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.aop;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.aop.AopMethodInvocation;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.change.tracking.CTTransactionException;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.spring.transaction.TransactionExecutorThreadLocal;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={ChainableMethodAdvice.class})
public class CTTransactionAdvice
extends ChainableMethodAdvice {
    public Object createMethodContext(Class<?> targetClass, Method method, Map<Class<? extends Annotation>, Annotation> annotations) {
        Transactional transactional = (Transactional)annotations.get(Transactional.class);
        if (transactional == null || !transactional.enabled()) {
            return null;
        }
        CTAware ctAware = (CTAware)annotations.get(CTAware.class);
        if (ctAware != null) {
            if (ctAware.onProduction()) {
                return CTMode.REQUIRES_NEW;
            }
            return null;
        }
        if (transactional.readOnly()) {
            return CTMode.READ_ONLY;
        }
        if (transactional.propagation() == Propagation.REQUIRES_NEW) {
            return CTMode.REQUIRES_NEW;
        }
        return CTMode.STRICT;
    }

    public Object invoke(AopMethodInvocation aopMethodInvocation, Object[] arguments) throws Throwable {
        if (CTCollectionThreadLocal.isProductionMode()) {
            return aopMethodInvocation.proceed(arguments);
        }
        CTMode ctMode = (CTMode)((Object)aopMethodInvocation.getAdviceMethodContext());
        if (ctMode == CTMode.REQUIRES_NEW || TransactionExecutorThreadLocal.getCurrentTransactionExecutor() == null) {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                Object object = aopMethodInvocation.proceed(arguments);
                return object;
            }
        }
        if (ctMode == CTMode.READ_ONLY) {
            return aopMethodInvocation.proceed(arguments);
        }
        throw new CTTransactionException("CT transaction validation failure. Nested operation using " + aopMethodInvocation.getThis() + " can only be performed in production mode.");
    }

    private static enum CTMode {
        READ_ONLY,
        REQUIRES_NEW,
        STRICT;

    }
}

