/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.change.tracking.internal.spi.reference;

import com.liferay.change.tracking.spi.reference.TableReferenceDefinition;
import com.liferay.change.tracking.spi.reference.builder.ChildTableReferenceInfoBuilder;
import com.liferay.change.tracking.spi.reference.builder.ParentTableReferenceInfoBuilder;
import com.liferay.portal.kernel.model.AccountTable;
import com.liferay.portal.kernel.model.CompanyTable;
import com.liferay.portal.kernel.model.ContactTable;
import com.liferay.portal.kernel.model.UserTable;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.ContactPersistence;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Preston Crary
 */
@Component(service = TableReferenceDefinition.class)
public class ContactTableReferenceDefinition
	implements TableReferenceDefinition<ContactTable> {

	@Override
	public void defineChildTableReferences(
		ChildTableReferenceInfoBuilder<ContactTable>
			childTableReferenceInfoBuilder) {
	}

	@Override
	public void defineParentTableReferences(
		ParentTableReferenceInfoBuilder<ContactTable>
			parentTableReferenceInfoBuilder) {

		parentTableReferenceInfoBuilder.singleColumnReference(
			ContactTable.INSTANCE.companyId, CompanyTable.INSTANCE.companyId
		).singleColumnReference(
			ContactTable.INSTANCE.userId, UserTable.INSTANCE.userId
		).singleColumnReference(
			ContactTable.INSTANCE.accountId, AccountTable.INSTANCE.accountId
		).parentColumnReference(
			ContactTable.INSTANCE.contactId,
			ContactTable.INSTANCE.parentContactId
		);
	}

	@Override
	public BasePersistence<?> getBasePersistence() {
		return _contactPersistence;
	}

	@Override
	public ContactTable getTable() {
		return ContactTable.INSTANCE;
	}

	@Reference
	private ContactPersistence _contactPersistence;

}