/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.persistence.impl;

import com.liferay.change.tracking.exception.NoSuchMessageException;
import com.liferay.change.tracking.model.CTMessage;
import com.liferay.change.tracking.model.impl.CTMessageImpl;
import com.liferay.change.tracking.model.impl.CTMessageModelImpl;
import com.liferay.change.tracking.service.persistence.CTMessagePersistence;
import com.liferay.change.tracking.service.persistence.impl.constants.CTPersistenceConstants;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTMessagePersistence.class})
public class CTMessagePersistenceImpl
extends BasePersistenceImpl<CTMessage>
implements CTMessagePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CTMessageImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCTCollectionId;
    private FinderPath _finderPathWithoutPaginationFindByCTCollectionId;
    private FinderPath _finderPathCountByCTCollectionId;
    private static final String _FINDER_COLUMN_CTCOLLECTIONID_CTCOLLECTIONID_2 = "ctMessage.ctCollectionId = ?";
    private boolean _columnBitmaskEnabled;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_CTMESSAGE = "SELECT ctMessage FROM CTMessage ctMessage";
    private static final String _SQL_SELECT_CTMESSAGE_WHERE = "SELECT ctMessage FROM CTMessage ctMessage WHERE ";
    private static final String _SQL_COUNT_CTMESSAGE = "SELECT COUNT(ctMessage) FROM CTMessage ctMessage";
    private static final String _SQL_COUNT_CTMESSAGE_WHERE = "SELECT COUNT(ctMessage) FROM CTMessage ctMessage WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ctMessage.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CTMessage exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CTMessage exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CTMessagePersistenceImpl.class);

    public List<CTMessage> findByCTCollectionId(long ctCollectionId) {
        return this.findByCTCollectionId(ctCollectionId, -1, -1, null);
    }

    public List<CTMessage> findByCTCollectionId(long ctCollectionId, int start, int end) {
        return this.findByCTCollectionId(ctCollectionId, start, end, null);
    }

    public List<CTMessage> findByCTCollectionId(long ctCollectionId, int start, int end, OrderByComparator<CTMessage> orderByComparator) {
        return this.findByCTCollectionId(ctCollectionId, start, end, orderByComparator, true);
    }

    public List<CTMessage> findByCTCollectionId(long ctCollectionId, int start, int end, OrderByComparator<CTMessage> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCTCollectionId;
                finderArgs = new Object[]{ctCollectionId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCTCollectionId;
            finderArgs = new Object[]{ctCollectionId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CTMessage ctMessage : list) {
                if (ctCollectionId == ctMessage.getCtCollectionId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_CTMESSAGE_WHERE);
            sb.append(_FINDER_COLUMN_CTCOLLECTIONID_CTCOLLECTIONID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ctMessage.ctMessageId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(ctCollectionId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CTMessage findByCTCollectionId_First(long ctCollectionId, OrderByComparator<CTMessage> orderByComparator) throws NoSuchMessageException {
        CTMessage ctMessage = this.fetchByCTCollectionId_First(ctCollectionId, orderByComparator);
        if (ctMessage != null) {
            return ctMessage;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("ctCollectionId=");
        sb.append(ctCollectionId);
        sb.append("}");
        throw new NoSuchMessageException(sb.toString());
    }

    public CTMessage fetchByCTCollectionId_First(long ctCollectionId, OrderByComparator<CTMessage> orderByComparator) {
        List<CTMessage> list = this.findByCTCollectionId(ctCollectionId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CTMessage findByCTCollectionId_Last(long ctCollectionId, OrderByComparator<CTMessage> orderByComparator) throws NoSuchMessageException {
        CTMessage ctMessage = this.fetchByCTCollectionId_Last(ctCollectionId, orderByComparator);
        if (ctMessage != null) {
            return ctMessage;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("ctCollectionId=");
        sb.append(ctCollectionId);
        sb.append("}");
        throw new NoSuchMessageException(sb.toString());
    }

    public CTMessage fetchByCTCollectionId_Last(long ctCollectionId, OrderByComparator<CTMessage> orderByComparator) {
        int count = this.countByCTCollectionId(ctCollectionId);
        if (count == 0) {
            return null;
        }
        List<CTMessage> list = this.findByCTCollectionId(ctCollectionId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CTMessage[] findByCTCollectionId_PrevAndNext(long ctMessageId, long ctCollectionId, OrderByComparator<CTMessage> orderByComparator) throws NoSuchMessageException {
        CTMessage ctMessage = this.findByPrimaryKey(ctMessageId);
        Session session = null;
        try {
            session = this.openSession();
            CTMessage[] array = new CTMessageImpl[]{this.getByCTCollectionId_PrevAndNext(session, ctMessage, ctCollectionId, orderByComparator, true), ctMessage, this.getByCTCollectionId_PrevAndNext(session, ctMessage, ctCollectionId, orderByComparator, false)};
            CTMessage[] cTMessageArray = array;
            return cTMessageArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CTMessage getByCTCollectionId_PrevAndNext(Session session, CTMessage ctMessage, long ctCollectionId, OrderByComparator<CTMessage> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_CTMESSAGE_WHERE);
        sb.append(_FINDER_COLUMN_CTCOLLECTIONID_CTCOLLECTIONID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ctMessage.ctMessageId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(ctCollectionId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ctMessage)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CTMessage)list.get(1);
        }
        return null;
    }

    public void removeByCTCollectionId(long ctCollectionId) {
        for (CTMessage ctMessage : this.findByCTCollectionId(ctCollectionId, -1, -1, null)) {
            this.remove((BaseModel)ctMessage);
        }
    }

    public int countByCTCollectionId(long ctCollectionId) {
        FinderPath finderPath = this._finderPathCountByCTCollectionId;
        Object[] finderArgs = new Object[]{ctCollectionId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_CTMESSAGE_WHERE);
            sb.append(_FINDER_COLUMN_CTCOLLECTIONID_CTCOLLECTIONID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(ctCollectionId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CTMessagePersistenceImpl() {
        this.setModelClass(CTMessage.class);
        this.setModelImplClass(CTMessageImpl.class);
        this.setModelPKClass(Long.TYPE);
    }

    public void cacheResult(CTMessage ctMessage) {
        this.entityCache.putResult(this.entityCacheEnabled, CTMessageImpl.class, (Serializable)Long.valueOf(ctMessage.getPrimaryKey()), (Serializable)ctMessage);
        ctMessage.resetOriginalValues();
    }

    public void cacheResult(List<CTMessage> ctMessages) {
        for (CTMessage ctMessage : ctMessages) {
            if (this.entityCache.getResult(this.entityCacheEnabled, CTMessageImpl.class, (Serializable)Long.valueOf(ctMessage.getPrimaryKey())) == null) {
                this.cacheResult(ctMessage);
                continue;
            }
            ctMessage.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CTMessageImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CTMessage ctMessage) {
        this.entityCache.removeResult(this.entityCacheEnabled, CTMessageImpl.class, (Serializable)Long.valueOf(ctMessage.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<CTMessage> ctMessages) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (CTMessage ctMessage : ctMessages) {
            this.entityCache.removeResult(this.entityCacheEnabled, CTMessageImpl.class, (Serializable)Long.valueOf(ctMessage.getPrimaryKey()));
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(this.entityCacheEnabled, CTMessageImpl.class, primaryKey);
        }
    }

    public CTMessage create(long ctMessageId) {
        CTMessageImpl ctMessage = new CTMessageImpl();
        ctMessage.setNew(true);
        ctMessage.setPrimaryKey(ctMessageId);
        return ctMessage;
    }

    public CTMessage remove(long ctMessageId) throws NoSuchMessageException {
        return this.remove(Long.valueOf(ctMessageId));
    }

    public CTMessage remove(Serializable primaryKey) throws NoSuchMessageException {
        Session session = null;
        try {
            session = this.openSession();
            CTMessage ctMessage = (CTMessage)session.get(CTMessageImpl.class, primaryKey);
            if (ctMessage == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchMessageException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CTMessage cTMessage = (CTMessage)this.remove((BaseModel)ctMessage);
            return cTMessage;
        }
        catch (NoSuchMessageException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CTMessage removeImpl(CTMessage ctMessage) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)ctMessage)) {
                ctMessage = (CTMessage)session.get(CTMessageImpl.class, ctMessage.getPrimaryKeyObj());
            }
            if (ctMessage != null) {
                session.delete((Object)ctMessage);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (ctMessage != null) {
            this.clearCache(ctMessage);
        }
        return ctMessage;
    }

    public CTMessage updateImpl(CTMessage ctMessage) {
        boolean isNew = ctMessage.isNew();
        if (!(ctMessage instanceof CTMessageModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ctMessage.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)ctMessage);
                throw new IllegalArgumentException("Implement ModelWrapper in ctMessage proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CTMessage implementation " + ctMessage.getClass());
        }
        CTMessageModelImpl ctMessageModelImpl = (CTMessageModelImpl)ctMessage;
        Session session = null;
        try {
            session = this.openSession();
            if (ctMessage.isNew()) {
                session.save((Object)ctMessage);
                ctMessage.setNew(false);
            } else {
                ctMessage = (CTMessage)session.merge((Object)ctMessage);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!this._columnBitmaskEnabled) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{ctMessageModelImpl.getCtCollectionId()};
            this.finderCache.removeResult(this._finderPathCountByCTCollectionId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCTCollectionId, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else if ((ctMessageModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCTCollectionId.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{ctMessageModelImpl.getOriginalCtCollectionId()};
            this.finderCache.removeResult(this._finderPathCountByCTCollectionId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCTCollectionId, args);
            args = new Object[]{ctMessageModelImpl.getCtCollectionId()};
            this.finderCache.removeResult(this._finderPathCountByCTCollectionId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCTCollectionId, args);
        }
        this.entityCache.putResult(this.entityCacheEnabled, CTMessageImpl.class, (Serializable)Long.valueOf(ctMessage.getPrimaryKey()), (Serializable)ctMessage, false);
        ctMessage.resetOriginalValues();
        return ctMessage;
    }

    public CTMessage findByPrimaryKey(Serializable primaryKey) throws NoSuchMessageException {
        CTMessage ctMessage = (CTMessage)this.fetchByPrimaryKey(primaryKey);
        if (ctMessage == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchMessageException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ctMessage;
    }

    public CTMessage findByPrimaryKey(long ctMessageId) throws NoSuchMessageException {
        return this.findByPrimaryKey(Long.valueOf(ctMessageId));
    }

    public CTMessage fetchByPrimaryKey(long ctMessageId) {
        return (CTMessage)this.fetchByPrimaryKey(Long.valueOf(ctMessageId));
    }

    public List<CTMessage> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CTMessage> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CTMessage> findAll(int start, int end, OrderByComparator<CTMessage> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CTMessage> findAll(int start, int end, OrderByComparator<CTMessage> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_CTMESSAGE);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_CTMESSAGE;
                sql = sql.concat(" ORDER BY ctMessage.ctMessageId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CTMessage ctMessage : this.findAll()) {
            this.remove((BaseModel)ctMessage);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_CTMESSAGE);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "ctMessageId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_CTMESSAGE;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CTMessageModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        CTMessageModelImpl.setEntityCacheEnabled(this.entityCacheEnabled);
        CTMessageModelImpl.setFinderCacheEnabled(this.finderCacheEnabled);
        this._finderPathWithPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, CTMessageImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, CTMessageImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByCTCollectionId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, CTMessageImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCTCollectionId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCTCollectionId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, CTMessageImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCTCollectionId", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByCTCollectionId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCTCollectionId", new String[]{Long.class.getName()});
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(CTMessageImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.change.tracking.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._columnBitmaskEnabled = GetterUtil.getBoolean((String)configuration.get("value.object.column.bitmask.enabled.com.liferay.change.tracking.model.CTMessage"), (boolean)true);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.change.tracking.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.change.tracking.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    static {
        try {
            Class.forName(CTPersistenceConstants.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException);
        }
    }
}

