/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.model.CTEntryModel;
import com.liferay.change.tracking.service.base.CTEntryLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.change.tracking.model.CTEntry"}, service={AopService.class})
public class CTEntryLocalServiceImpl
extends CTEntryLocalServiceBaseImpl {
    public CTEntry addCTEntry(long ctCollectionId, long modelClassNameId, CTModel<?> ctModel, long userId, int changeType) throws PortalException {
        CTCollection ctCollection = this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        if (ctCollection.getStatus() != 2) {
            throw new PortalException("Change tracking collection " + ctCollection + " is read only");
        }
        long ctEntryId = this.counterLocalService.increment(CTEntry.class.getName());
        CTEntry ctEntry = this.ctEntryPersistence.create(ctEntryId);
        ctEntry.setCompanyId(ctCollection.getCompanyId());
        ctEntry.setUserId(userId);
        ctEntry.setCtCollectionId(ctCollectionId);
        ctEntry.setModelClassNameId(modelClassNameId);
        ctEntry.setModelClassPK(ctModel.getPrimaryKey());
        ctEntry.setModelMvccVersion(ctModel.getMvccVersion());
        ctEntry.setChangeType(changeType);
        return (CTEntry)this.ctEntryPersistence.update((BaseModel)ctEntry);
    }

    @Override
    public CTEntry deleteCTEntry(CTEntry ctEntry) throws PortalException {
        CTCollection ctCollection = this.ctCollectionPersistence.findByPrimaryKey(ctEntry.getCtCollectionId());
        if (ctCollection.getStatus() != 2) {
            throw new PortalException("Change tracking collection " + ctCollection + " is read only");
        }
        return (CTEntry)this.ctEntryPersistence.remove((BaseModel)ctEntry);
    }

    public CTEntry fetchCTEntry(long ctCollectionId, long modelClassNameId, long modelClassPK) {
        return this.ctEntryPersistence.fetchByC_MCNI_MCPK(ctCollectionId, modelClassNameId, modelClassPK);
    }

    public List<CTEntry> getCTCollectionCTEntries(long ctCollectionId) {
        return this.getCTCollectionCTEntries(ctCollectionId, -1, -1, null);
    }

    public List<CTEntry> getCTCollectionCTEntries(long ctCollectionId, int start, int end, OrderByComparator<CTEntry> orderByComparator) {
        if (ctCollectionId == 0L) {
            return Collections.emptyList();
        }
        return this.ctEntryPersistence.findByCTCollectionId(ctCollectionId, start, end, orderByComparator);
    }

    public int getCTCollectionCTEntriesCount(long ctCollectionId) {
        if (ctCollectionId == 0L) {
            return 0;
        }
        return this.ctEntryPersistence.countByCTCollectionId(ctCollectionId);
    }

    public List<CTEntry> getCTEntries(long ctCollectionId, long modelClassNameId) {
        return this.ctEntryPersistence.findByC_MCNI(ctCollectionId, modelClassNameId);
    }

    public List<Long> getExclusiveModelClassPKs(long ctCollectionId, long modelClassNameId) {
        List ctEntries = this.ctEntryPersistence.findByC_MCNI(ctCollectionId, modelClassNameId);
        if (ctEntries.isEmpty()) {
            return Collections.emptyList();
        }
        List modelClassPKs = ListUtil.toList((List)ctEntries, CTEntryModel::getModelClassPK);
        for (CTEntry ctEntry : this.ctEntryPersistence.findByNotC_MCNI_MCPK(ctCollectionId, modelClassNameId, ArrayUtil.toArray((Long[])modelClassPKs.toArray(new Long[0])))) {
            modelClassPKs.remove(ctEntry.getModelClassPK());
        }
        return modelClassPKs;
    }

    public boolean hasCTEntries(long ctCollectionId, long modelClassNameId) {
        int count = this.ctEntryPersistence.countByC_MCNI(ctCollectionId, modelClassNameId);
        return count != 0;
    }

    @Override
    public CTEntry updateCTEntry(CTEntry ctEntry) {
        CTCollection ctCollection = this.ctCollectionPersistence.fetchByPrimaryKey(ctEntry.getCtCollectionId());
        if (ctCollection == null) {
            throw new SystemException("No change tracking collection exists for " + ctEntry);
        }
        int status = ctCollection.getStatus();
        if (status != 2 && status != 1) {
            throw new SystemException("Change tracking collection " + ctCollection + " is read only");
        }
        return (CTEntry)this.ctEntryPersistence.update((BaseModel)ctEntry);
    }
}

