/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.messaging;

import com.liferay.change.tracking.internal.configuration.CTMessageBusConfiguration;
import com.liferay.change.tracking.service.CTMessageLocalService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusInterceptor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.change.tracking.internal.configuration.CTMessageBusConfiguration"}, immediate=true, service={MessageBusInterceptor.class})
public class CTMessageBusInterceptor
implements MessageBusInterceptor {
    @Reference
    private CTMessageLocalService _ctMessageLocalService;
    private volatile Set<String> _interceptedDestinationNames;

    public boolean intercept(MessageBus messageBus, String destinationName, Message message) {
        if (!this._interceptedDestinationNames.contains(destinationName)) {
            return false;
        }
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return false;
        }
        message.setDestinationName(destinationName);
        this._ctMessageLocalService.addCTMessage(ctCollectionId, message);
        return true;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        HashSet<String> interceptedDestinationNames = new HashSet<String>();
        CTMessageBusConfiguration ctMessageBusConfiguration = (CTMessageBusConfiguration)ConfigurableUtil.createConfigurable(CTMessageBusConfiguration.class, properties);
        Collections.addAll(interceptedDestinationNames, ctMessageBusConfiguration.interceptedDestinationNames());
        this._interceptedDestinationNames = interceptedDestinationNames;
    }
}

