/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.conflict;

import com.liferay.change.tracking.conflict.ConflictInfo;
import com.liferay.change.tracking.internal.CTRowUtil;
import com.liferay.change.tracking.internal.conflict.ConstraintResolverConflictInfo;
import com.liferay.change.tracking.internal.conflict.DefaultConstraintConflictInfo;
import com.liferay.change.tracking.internal.resolver.ConstraintResolverHelperImpl;
import com.liferay.change.tracking.internal.resolver.ConstraintResolverKey;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.resolver.ConstraintResolver;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class CTConflictChecker<T extends CTModel<T>> {
    private final CTService<T> _ctService;
    private final Set<Long> _ignorablePrimaryKeys = new HashSet<Long>();
    private final ServiceTrackerMap<ConstraintResolverKey, ConstraintResolver> _serviceTrackerMap;
    private final long _sourceCTCollectionId;
    private final long _targetCTCollectionId;

    public CTConflictChecker(CTService<T> ctService, ServiceTrackerMap<ConstraintResolverKey, ConstraintResolver> serviceTrackerMap, long sourceCTCollectionId, long targetCTCollectionId) {
        this._ctService = ctService;
        this._serviceTrackerMap = serviceTrackerMap;
        this._sourceCTCollectionId = sourceCTCollectionId;
        this._targetCTCollectionId = targetCTCollectionId;
    }

    public void addCTEntry(CTEntry ctEntry) {
        if (ctEntry.getChangeType() != 0) {
            this._ignorablePrimaryKeys.add(ctEntry.getModelClassPK());
        }
    }

    public List<ConflictInfo> check() throws PortalException {
        return (List)this._ctService.updateWithUnsafeFunction(this::_check);
    }

    private List<ConflictInfo> _check(CTPersistence<T> ctPersistence) throws PortalException {
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)ctPersistence.getDataSource());
        List uniqueIndexColumnNames = ctPersistence.getUniqueIndexColumnNames();
        ArrayList<ConflictInfo> conflictInfos = new ArrayList<ConflictInfo>();
        if (!uniqueIndexColumnNames.isEmpty()) {
            for (String[] columnNames : uniqueIndexColumnNames) {
                this._checkConstraint(connection, ctPersistence, conflictInfos, columnNames);
            }
        }
        return conflictInfos;
    }

    private void _checkConstraint(Connection connection, CTPersistence<T> ctPersistence, List<ConflictInfo> conflictInfos, String[] columnNames) throws PortalException {
        Set primaryKeyNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.PK);
        if (primaryKeyNames.size() != 1) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{ctPersistence=", ctPersistence, ", primaryKeyNames=", primaryKeyNames, "}"}));
        }
        Iterator iterator = primaryKeyNames.iterator();
        String primaryKeyName = (String)iterator.next();
        String constraintConflictsSQL = CTRowUtil.getConstraintConflictsSQL(ctPersistence.getTableName(), primaryKeyName, columnNames, this._sourceCTCollectionId, this._targetCTCollectionId, true);
        List<Map.Entry<Long, Long>> nextPrimaryKeys = this._getConflictingPrimaryKeys(connection, constraintConflictsSQL);
        if (nextPrimaryKeys.isEmpty()) {
            return;
        }
        ConstraintResolver constraintResolver = (ConstraintResolver)this._serviceTrackerMap.getService((Object)new ConstraintResolverKey(ctPersistence.getModelClass(), columnNames));
        if (constraintResolver == null) {
            StringBundler sb = new StringBundler(2 * columnNames.length);
            for (String columnName : columnNames) {
                sb.append(columnName);
                sb.append(", ");
            }
            sb.setIndex(sb.index() - 1);
            String columnNamesString = sb.toString();
            for (Map.Entry<Long, Long> currentPrimaryKeys : nextPrimaryKeys) {
                conflictInfos.add(new DefaultConstraintConflictInfo(currentPrimaryKeys.getKey(), currentPrimaryKeys.getValue(), columnNamesString));
            }
            return;
        }
        ConstraintResolverHelperImpl<T> constraintResolverHelperImpl = new ConstraintResolverHelperImpl<T>(this._ctService, this._targetCTCollectionId);
        HashSet<Map.Entry<Long, Long>> attemptedPrimaryKeys = new HashSet<Map.Entry<Long, Long>>();
        HashSet<Map.Entry<Long, Long>> resolvedPrimaryKeys = new HashSet<Map.Entry<Long, Long>>(nextPrimaryKeys);
        while (!nextPrimaryKeys.isEmpty()) {
            Map.Entry<Long, Long> currentPrimaryKeys = nextPrimaryKeys.get(0);
            constraintResolverHelperImpl.setPrimaryKeys(currentPrimaryKeys.getKey(), currentPrimaryKeys.getValue());
            constraintResolver.resolveConflict(constraintResolverHelperImpl);
            attemptedPrimaryKeys.add(currentPrimaryKeys);
            nextPrimaryKeys = this._getConflictingPrimaryKeys(connection, constraintConflictsSQL);
            resolvedPrimaryKeys.addAll(nextPrimaryKeys);
            nextPrimaryKeys.removeAll(attemptedPrimaryKeys);
        }
        List<Map.Entry<Long, Long>> unresolvedPrimaryKeys = this._getConflictingPrimaryKeys(connection, constraintConflictsSQL);
        resolvedPrimaryKeys.removeAll(unresolvedPrimaryKeys);
        for (Map.Entry entry : resolvedPrimaryKeys) {
            conflictInfos.add(new ConstraintResolverConflictInfo(constraintResolver, (Long)entry.getKey(), (Long)entry.getValue(), true));
        }
        if (unresolvedPrimaryKeys.isEmpty()) {
            return;
        }
        for (Map.Entry entry : unresolvedPrimaryKeys) {
            conflictInfos.add(new ConstraintResolverConflictInfo(constraintResolver, (Long)entry.getKey(), (Long)entry.getValue(), false));
        }
    }

    /*
     * Exception decompiling
     */
    private List<Map.Entry<Long, Long>> _getConflictingPrimaryKeys(Connection connection, String constraintConflictsSQL) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

