/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.background.task;

import com.liferay.change.tracking.internal.CTRowUtil;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class CTServicePublisher<T extends CTModel<T>> {
    private Map<Serializable, CTEntry> _additionCTEntries;
    private final CTEntryLocalService _ctEntryLocalService;
    private final CTService<T> _ctService;
    private Map<Serializable, CTEntry> _deletionCTEntries;
    private final long _modelClassNameId;
    private Map<Serializable, CTEntry> _modificationCTEntries;
    private final long _sourceCTCollectionId;
    private final long _targetCTCollectionId;

    public CTServicePublisher(CTEntryLocalService ctEntryLocalService, CTService<T> ctService, long modelClassNameId, long sourceCTCollectionId, long targetCTCollectionId) {
        this._ctEntryLocalService = ctEntryLocalService;
        this._ctService = ctService;
        this._modelClassNameId = modelClassNameId;
        this._sourceCTCollectionId = sourceCTCollectionId;
        this._targetCTCollectionId = targetCTCollectionId;
    }

    public void addCTEntry(CTEntry ctEntry) {
        long modelClassPK = ctEntry.getModelClassPK();
        int changeType = ctEntry.getChangeType();
        if (changeType == 0) {
            if (this._additionCTEntries == null) {
                this._additionCTEntries = new HashMap<Serializable, CTEntry>();
            }
            this._additionCTEntries.put(Long.valueOf(modelClassPK), ctEntry);
        } else if (changeType == 1) {
            if (this._deletionCTEntries == null) {
                this._deletionCTEntries = new HashMap<Serializable, CTEntry>();
            }
            this._deletionCTEntries.put(Long.valueOf(modelClassPK), ctEntry);
        } else {
            if (this._modificationCTEntries == null) {
                this._modificationCTEntries = new HashMap<Serializable, CTEntry>();
            }
            this._modificationCTEntries.put(Long.valueOf(modelClassPK), ctEntry);
        }
    }

    public void publish() throws Exception {
        this._ctService.updateWithUnsafeFunction(this::_publish);
    }

    private Void _publish(CTPersistence<T> ctPersistence) throws Exception {
        int rowCount;
        String tableName = ctPersistence.getTableName();
        Set primaryKeyNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.PK);
        if (primaryKeyNames.size() != 1) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{primaryKeyNames=", primaryKeyNames, ", tableName=", tableName, "}"}));
        }
        Iterator iterator = primaryKeyNames.iterator();
        String primaryKeyName = (String)iterator.next();
        long tempCTCollectionId = -this._sourceCTCollectionId;
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)ctPersistence.getDataSource());
        if (this._additionCTEntries != null) {
            this._updateCTCollectionId(connection, tableName, primaryKeyName, this._additionCTEntries.values(), this._sourceCTCollectionId, tempCTCollectionId, false, false);
        }
        if (this._modificationCTEntries != null) {
            this._updateCTCollectionId(connection, tableName, primaryKeyName, this._modificationCTEntries.values(), this._sourceCTCollectionId, tempCTCollectionId, false, true);
        }
        if (this._deletionCTEntries != null) {
            this._updateCTCollectionId(connection, tableName, primaryKeyName, this._deletionCTEntries.values(), this._targetCTCollectionId, this._sourceCTCollectionId, true, true);
            this._updateModelMvccVersion(connection, tableName, primaryKeyName, this._deletionCTEntries, this._sourceCTCollectionId);
        }
        if (this._modificationCTEntries != null && (rowCount = this._updateCTCollectionId(connection, tableName, primaryKeyName, this._modificationCTEntries.values(), this._targetCTCollectionId, this._sourceCTCollectionId, true, false)) != this._modificationCTEntries.size()) {
            StringBundler sb = new StringBundler();
            sb.append("select t1.");
            sb.append(primaryKeyName);
            sb.append(" from ");
            sb.append(tableName);
            sb.append(" t1 inner join ");
            sb.append(tableName);
            sb.append(" t2 on t1.");
            sb.append(primaryKeyName);
            sb.append(" = t2.");
            sb.append(primaryKeyName);
            sb.append(" and t1.ctCollectionId = ");
            sb.append(tempCTCollectionId);
            sb.append(" and t2.ctCollectionId = ");
            sb.append(this._targetCTCollectionId);
            HashMap strictColumnsMap = new HashMap(ctPersistence.getTableColumnsMap());
            Set strictColumnNames = strictColumnsMap.keySet();
            strictColumnNames.retainAll(ctPersistence.getCTColumnNames(CTColumnResolutionType.STRICT));
            Collection strictColumnTypes = strictColumnsMap.values();
            if (!strictColumnTypes.contains(2004)) {
                sb.append(" and (");
                for (Map.Entry entry : strictColumnsMap.entrySet()) {
                    String conflictColumnName = (String)entry.getKey();
                    if ((Integer)entry.getValue() == 2005) {
                        sb.append("CAST_CLOB_TEXT(t1.");
                        sb.append(conflictColumnName);
                        sb.append(") != CAST_CLOB_TEXT(t2.");
                        sb.append(conflictColumnName);
                        sb.append(")");
                    } else {
                        sb.append("t1.");
                        sb.append(conflictColumnName);
                        sb.append(" != t2.");
                        sb.append(conflictColumnName);
                    }
                    sb.append(" or ");
                }
                sb.setStringAt(")", sb.index() - 1);
            }
            sb.append(" inner join CTEntry ctEntry on ");
            sb.append("ctEntry.ctCollectionId = ");
            sb.append(this._sourceCTCollectionId);
            sb.append(" and ctEntry.modelClassNameId = ");
            sb.append(this._modelClassNameId);
            sb.append(" and ctEntry.modelClassPK = t2.");
            sb.append(primaryKeyName);
            sb.append(" and ctEntry.changeType = ");
            sb.append(2);
            sb.append(" and ctEntry.modelMvccVersion != t2.mvccVersion");
            ArrayList<Long> conflictPrimaryKeys = new ArrayList<Long>();
            try (PreparedStatement preparedStatement = connection.prepareStatement(SQLTransformer.transform((String)sb.toString()));
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    conflictPrimaryKeys.add(resultSet.getLong(1));
                }
            }
            if (!conflictPrimaryKeys.isEmpty()) {
                conflictPrimaryKeys.sort(null);
                throw new SystemException(StringBundler.concat((Object[])new Object[]{"Unable to auto resolve publication conflict for ", this._ctService.getModelClass(), " with primary keys ", conflictPrimaryKeys}));
            }
            if ((rowCount += this._updateCTCollectionId(connection, tableName, primaryKeyName, this._modificationCTEntries.values(), this._targetCTCollectionId, this._sourceCTCollectionId, false, false)) != this._modificationCTEntries.size()) {
                throw new SystemException(StringBundler.concat((Object[])new Object[]{"Size mismatch expected ", this._modificationCTEntries.size(), " but was ", rowCount}));
            }
        }
        if (this._additionCTEntries != null) {
            this._updateCTCollectionId(connection, tableName, primaryKeyName, this._additionCTEntries.values(), tempCTCollectionId, this._targetCTCollectionId, false, false);
            this._updateModelMvccVersion(connection, tableName, primaryKeyName, this._additionCTEntries, this._targetCTCollectionId);
        }
        if (this._modificationCTEntries != null) {
            StringBundler sb = new StringBundler();
            Map tableColumnsMap = ctPersistence.getTableColumnsMap();
            sb.append("select ");
            Set ignoredColumnNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.IGNORE);
            for (String name : tableColumnsMap.keySet()) {
                if (name.equals("ctCollectionId")) {
                    sb.append(this._targetCTCollectionId);
                    sb.append(" as ");
                } else if (name.equals("mvccVersion")) {
                    sb.append("(t1.mvccVersion + 1) ");
                } else if (ignoredColumnNames.contains(name)) {
                    sb.append("t2.");
                } else {
                    sb.append("t1.");
                }
                sb.append(name);
                sb.append(", ");
            }
            sb.setStringAt(" from ", sb.index() - 1);
            sb.append(tableName);
            sb.append(" t1, ");
            sb.append(tableName);
            sb.append(" t2 where t1.");
            sb.append(primaryKeyName);
            sb.append(" = t2.");
            sb.append(primaryKeyName);
            sb.append(" and t1.ctCollectionId = ");
            sb.append(tempCTCollectionId);
            sb.append(" and t2.ctCollectionId = ");
            sb.append(this._sourceCTCollectionId);
            CTRowUtil.copyCTRows(ctPersistence, connection, sb.toString());
            sb.setIndex(0);
            sb.append("delete from ");
            sb.append(tableName);
            sb.append(" where ctCollectionId = ");
            sb.append(tempCTCollectionId);
            try (PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());){
                preparedStatement.executeUpdate();
            }
            this._updateModelMvccVersion(connection, tableName, primaryKeyName, this._modificationCTEntries, this._targetCTCollectionId);
        }
        if (this._additionCTEntries != null) {
            ctPersistence.clearCache(this._additionCTEntries.keySet());
        }
        if (this._deletionCTEntries != null) {
            ctPersistence.clearCache(this._deletionCTEntries.keySet());
        }
        if (this._modificationCTEntries != null) {
            ctPersistence.clearCache(this._modificationCTEntries.keySet());
        }
        return null;
    }

    private int _updateCTCollectionId(Connection connection, String tableName, String primaryKeyName, Collection<CTEntry> ctEntries, long fromCTCollectionId, long toCTCollectionId, boolean includeMvccVersion, boolean checkRowCount) throws Exception {
        StringBundler sb = new StringBundler();
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set ctCollectionId = ");
        sb.append(toCTCollectionId);
        sb.append(" where ");
        sb.append(tableName);
        sb.append(".ctCollectionId = ");
        sb.append(fromCTCollectionId);
        sb.append(" and ");
        if (includeMvccVersion) {
            sb.append("(");
            for (CTEntry ctEntry : ctEntries) {
                sb.append("(");
                sb.append(tableName);
                sb.append(".");
                sb.append(primaryKeyName);
                sb.append(" = ");
                sb.append(ctEntry.getModelClassPK());
                sb.append(" and ");
                sb.append(tableName);
                sb.append(".mvccVersion = ");
                sb.append(ctEntry.getModelMvccVersion());
                sb.append(")");
                sb.append(" or ");
            }
            sb.setStringAt(")", sb.index() - 1);
        } else {
            sb.append(tableName);
            sb.append(".");
            sb.append(primaryKeyName);
            sb.append(" in (");
            for (CTEntry ctEntry : ctEntries) {
                sb.append(ctEntry.getModelClassPK());
                sb.append(", ");
            }
            sb.setStringAt(")", sb.index() - 1);
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());){
            int rowCount = preparedStatement.executeUpdate();
            if (checkRowCount && rowCount != ctEntries.size()) {
                throw new SystemException(StringBundler.concat((Object[])new Object[]{"Size mismatch expected ", ctEntries.size(), " but was ", rowCount}));
            }
            int n = rowCount;
            return n;
        }
    }

    private void _updateModelMvccVersion(Connection connection, String tableName, String primaryKeyName, Map<Serializable, CTEntry> ctEntries, long ctCollectionId) throws Exception {
        StringBundler sb = new StringBundler(2 * ctEntries.size() + 9);
        sb.append("select ");
        sb.append(primaryKeyName);
        sb.append(", mvccVersion from ");
        sb.append(tableName);
        sb.append(" where ctCollectionId = ");
        sb.append(ctCollectionId);
        sb.append(" and ");
        sb.append(primaryKeyName);
        sb.append(" in (");
        for (Serializable serializable : ctEntries.keySet()) {
            sb.append((Object)serializable);
            sb.append(", ");
        }
        sb.setStringAt(")", sb.index() - 1);
        try (PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long pk = resultSet.getLong(1);
                long mvccVersion = resultSet.getLong(2);
                CTEntry ctEntry = ctEntries.get(pk);
                ctEntry.setModifiedDate(ctEntry.getModifiedDate());
                ctEntry.setModelMvccVersion(mvccVersion);
                this._ctEntryLocalService.updateCTEntry(ctEntry);
            }
        }
    }
}

