/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.closure.CTClosure;
import com.liferay.change.tracking.closure.CTClosureFactory;
import com.liferay.change.tracking.conflict.ConflictInfo;
import com.liferay.change.tracking.exception.CTCollectionDescriptionException;
import com.liferay.change.tracking.exception.CTCollectionNameException;
import com.liferay.change.tracking.internal.CTEnclosureUtil;
import com.liferay.change.tracking.internal.CTServiceCopier;
import com.liferay.change.tracking.internal.CTServiceRegistry;
import com.liferay.change.tracking.internal.CTTableMapperHelper;
import com.liferay.change.tracking.internal.closure.Node;
import com.liferay.change.tracking.internal.conflict.CTConflictChecker;
import com.liferay.change.tracking.internal.conflict.ConstraintResolverConflictInfo;
import com.liferay.change.tracking.internal.conflict.ModificationConflictInfo;
import com.liferay.change.tracking.internal.reference.TableReferenceDefinitionManager;
import com.liferay.change.tracking.internal.resolver.ConstraintResolverKey;
import com.liferay.change.tracking.model.CTAutoResolutionInfo;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.model.CTPreferences;
import com.liferay.change.tracking.model.CTProcess;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.service.CTPreferencesLocalService;
import com.liferay.change.tracking.service.CTProcessLocalService;
import com.liferay.change.tracking.service.base.CTCollectionLocalServiceBaseImpl;
import com.liferay.change.tracking.service.persistence.CTAutoResolutionInfoPersistence;
import com.liferay.change.tracking.spi.display.CTDisplayRenderer;
import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.lang.SafeClosable;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.change.tracking.model.CTCollection"}, service={AopService.class})
public class CTCollectionLocalServiceImpl
extends CTCollectionLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CTCollectionLocalServiceImpl.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private ServiceTrackerMap<ConstraintResolverKey, ConstraintResolver<?>> _constraintResolverServiceTrackerMap;
    @Reference
    private CTAutoResolutionInfoPersistence _ctAutoResolutionInfoPersistence;
    @Reference
    private CTClosureFactory _ctClosureFactory;
    private ServiceTrackerMap<String, CTDisplayRenderer<?>> _ctDisplayRendererServiceTrackerMap;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTPreferencesLocalService _ctPreferencesLocalService;
    @Reference
    private CTProcessLocalService _ctProcessLocalService;
    @Reference
    private CTServiceRegistry _ctServiceRegistry;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private TableReferenceDefinitionManager _tableReferenceDefinitionManager;

    public CTCollection addCTCollection(long companyId, long userId, String name, String description) throws PortalException {
        this._validate(name, description);
        long ctCollectionId = this.counterLocalService.increment(CTCollection.class.getName());
        CTCollection ctCollection = this.ctCollectionPersistence.create(ctCollectionId);
        ctCollection.setCompanyId(companyId);
        ctCollection.setUserId(userId);
        ctCollection.setName(name);
        ctCollection.setDescription(description);
        ctCollection.setStatus(2);
        ctCollection = (CTCollection)this.ctCollectionPersistence.update((BaseModel)ctCollection);
        this._resourceLocalService.addResources(ctCollection.getCompanyId(), 0L, ctCollection.getUserId(), CTCollection.class.getName(), ctCollection.getCtCollectionId(), false, false, false);
        return ctCollection;
    }

    public Map<Long, List<ConflictInfo>> checkConflicts(CTCollection ctCollection) throws PortalException {
        HashMap<Long, List<ConflictInfo>> conflictInfoMap = new HashMap<Long, List<ConflictInfo>>();
        List ctEntries = this.ctEntryPersistence.findByCTCollectionId(ctCollection.getCtCollectionId());
        HashMap<Long, CTConflictChecker> ctConflictCheckers = new HashMap<Long, CTConflictChecker>();
        for (CTEntry ctEntry : ctEntries) {
            CTConflictChecker cTConflictChecker = ctConflictCheckers.computeIfAbsent(ctEntry.getModelClassNameId(), modelClassNameId -> {
                CTService<?> ctService = this._ctServiceRegistry.getCTService((long)modelClassNameId);
                if (ctService == null) {
                    throw new SystemException(StringBundler.concat((Object[])new Object[]{"Unable to check conflicts for ", ctCollection, " because service for ", modelClassNameId, " is missing"}));
                }
                return new CTConflictChecker(this._classNameLocalService, this._constraintResolverServiceTrackerMap, this._ctDisplayRendererServiceTrackerMap, this._ctEntryLocalService, ctService, (long)modelClassNameId, ctCollection.getCtCollectionId(), this._tableReferenceDefinitionManager, 0L);
            });
            cTConflictChecker.addCTEntry(ctEntry);
        }
        SafeClosable safeClosable = CTCollectionThreadLocal.setCTCollectionId((long)ctCollection.getCtCollectionId());
        Iterator iterator = null;
        try {
            for (Map.Entry entry : ctConflictCheckers.entrySet()) {
                CTConflictChecker ctConflictChecker = (CTConflictChecker)entry.getValue();
                List<ConflictInfo> conflictInfos = ctConflictChecker.check();
                if (conflictInfos.isEmpty()) continue;
                conflictInfoMap.put((Long)entry.getKey(), conflictInfos);
            }
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (safeClosable != null) {
                if (iterator != null) {
                    try {
                        safeClosable.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    safeClosable.close();
                }
            }
        }
        List ctAutoResolutionInfos = this._ctAutoResolutionInfoPersistence.findByCTCollectionId(ctCollection.getCtCollectionId());
        for (Map.Entry entry : conflictInfoMap.entrySet()) {
            for (ConflictInfo conflictInfo : (List)entry.getValue()) {
                if (!conflictInfo.isResolved()) continue;
                CTAutoResolutionInfo ctAutoResolutionInfo = this._ctAutoResolutionInfoPersistence.create(this.counterLocalService.increment(CTAutoResolutionInfo.class.getName()));
                ctAutoResolutionInfo.setCompanyId(ctCollection.getCompanyId());
                ctAutoResolutionInfo.setCreateDate(new Date());
                ctAutoResolutionInfo.setCtCollectionId(ctCollection.getCtCollectionId());
                ctAutoResolutionInfo.setModelClassNameId(((Long)entry.getKey()).longValue());
                ctAutoResolutionInfo.setSourceModelClassPK(conflictInfo.getSourcePrimaryKey());
                ctAutoResolutionInfo.setTargetModelClassPK(conflictInfo.getTargetPrimaryKey());
                if (conflictInfo instanceof ConstraintResolverConflictInfo) {
                    ConstraintResolverConflictInfo constraintResolverConflictInfo = (ConstraintResolverConflictInfo)conflictInfo;
                    ConstraintResolver<?> constraintResolver = constraintResolverConflictInfo.getConstraintResolver();
                    ctAutoResolutionInfo.setConflictIdentifier(StringUtil.merge((String[])constraintResolver.getUniqueIndexColumnNames(), (String)","));
                    constraintResolverConflictInfo.setCtAutoResolutionInfoId(ctAutoResolutionInfo.getCtAutoResolutionInfoId());
                } else if (conflictInfo instanceof ModificationConflictInfo) {
                    ModificationConflictInfo resolvedModificationConflictInfo = (ModificationConflictInfo)conflictInfo;
                    resolvedModificationConflictInfo.setCtAutoResolutionInfoId(ctAutoResolutionInfo.getCtAutoResolutionInfoId());
                    ctAutoResolutionInfo.setConflictIdentifier(ModificationConflictInfo.class.getName());
                }
                this._ctAutoResolutionInfoPersistence.update((BaseModel)ctAutoResolutionInfo);
            }
        }
        for (CTAutoResolutionInfo cTAutoResolutionInfo : ctAutoResolutionInfos) {
            List list = conflictInfoMap.computeIfAbsent(cTAutoResolutionInfo.getModelClassNameId(), key -> new ArrayList());
            ClassName className = this._classNameLocalService.getClassName(cTAutoResolutionInfo.getModelClassNameId());
            if (Objects.equals(cTAutoResolutionInfo.getConflictIdentifier(), ModificationConflictInfo.class.getName())) {
                ModificationConflictInfo resolvedModificationConflictInfo = new ModificationConflictInfo(cTAutoResolutionInfo.getSourceModelClassPK(), true);
                resolvedModificationConflictInfo.setCtAutoResolutionInfoId(cTAutoResolutionInfo.getCtAutoResolutionInfoId());
                list.add(resolvedModificationConflictInfo);
                continue;
            }
            List uniqueIndexes = StringUtil.split((String)cTAutoResolutionInfo.getConflictIdentifier(), (char)',');
            ConstraintResolver constraintResolver = (ConstraintResolver)this._constraintResolverServiceTrackerMap.getService((Object)new ConstraintResolverKey(className.getValue(), uniqueIndexes.toArray(new String[0])));
            if (constraintResolver == null) continue;
            ConstraintResolverConflictInfo constraintResolverConflictInfo = new ConstraintResolverConflictInfo(constraintResolver, true, cTAutoResolutionInfo.getSourceModelClassPK(), cTAutoResolutionInfo.getTargetModelClassPK());
            constraintResolverConflictInfo.setCtAutoResolutionInfoId(cTAutoResolutionInfo.getCtAutoResolutionInfoId());
            list.add(constraintResolverConflictInfo);
        }
        return conflictInfoMap;
    }

    public void deleteCompanyCTCollections(long companyId) throws PortalException {
        List ctCollections = this.ctCollectionPersistence.findByCompanyId(companyId);
        for (CTCollection ctCollection : ctCollections) {
            this.deleteCTCollection(ctCollection);
        }
    }

    public void deleteCTAutoResolutionInfo(long ctAutoResolutionInfoId) {
        CTAutoResolutionInfo ctAutoResolutionInfo = this._ctAutoResolutionInfoPersistence.fetchByPrimaryKey(ctAutoResolutionInfoId);
        if (ctAutoResolutionInfo != null) {
            this._ctAutoResolutionInfoPersistence.remove((BaseModel)ctAutoResolutionInfo);
        }
    }

    @Override
    public CTCollection deleteCTCollection(CTCollection ctCollection) throws PortalException {
        this._ctServiceRegistry.onBeforeRemove(ctCollection.getCtCollectionId());
        try {
            for (CTTableMapperHelper ctTableMapperHelper : this._ctServiceRegistry.getCTTableMapperHelpers()) {
                ctTableMapperHelper.delete(ctCollection.getCtCollectionId());
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        List ctEntries = this.ctEntryPersistence.findByCTCollectionId(ctCollection.getCtCollectionId());
        HashSet<Long> modelClassNameIds = new HashSet<Long>();
        for (CTEntry ctEntry : ctEntries) {
            modelClassNameIds.add(ctEntry.getModelClassNameId());
        }
        Iterator iterator = modelClassNameIds.iterator();
        while (iterator.hasNext()) {
            long modelClassNameId = (Long)iterator.next();
            CTService<?> ctService = this._ctServiceRegistry.getCTService(modelClassNameId);
            if (ctService == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("No CTService found for classNameId " + modelClassNameId));
                continue;
            }
            ctService.updateWithUnsafeFunction(ctPersistence -> {
                Connection connection = CurrentConnectionUtil.getConnection((DataSource)ctPersistence.getDataSource());
                try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"delete from ", ctPersistence.getTableName(), " where ctCollectionId = ", ctCollection.getCtCollectionId()}));){
                    Integer n = preparedStatement.executeUpdate();
                    return n;
                }
                catch (Exception exception) {
                    throw new SystemException((Throwable)exception);
                }
            });
        }
        this._ctAutoResolutionInfoPersistence.removeByCTCollectionId(ctCollection.getCtCollectionId());
        for (CTEntry ctEntry : ctEntries) {
            this.ctEntryPersistence.remove((BaseModel)ctEntry);
        }
        this.ctMessagePersistence.removeByCTCollectionId(ctCollection.getCtCollectionId());
        this._ctPreferencesLocalService.resetCTPreferences(ctCollection.getCtCollectionId());
        List ctProcesses = this.ctProcessPersistence.findByCollectionId(ctCollection.getCtCollectionId());
        for (CTProcess ctProcess : ctProcesses) {
            this._ctProcessLocalService.deleteCTProcess(ctProcess);
        }
        this._resourceLocalService.deleteResource(ctCollection.getCompanyId(), CTCollection.class.getName(), 4, ctCollection.getCtCollectionId());
        return (CTCollection)this.ctCollectionPersistence.remove((BaseModel)ctCollection);
    }

    public List<CTCollection> getCTCollections(long companyId, int status, int start, int end, OrderByComparator<CTCollection> orderByComparator) {
        if (status == -1) {
            return this.ctCollectionPersistence.findByCompanyId(companyId, start, end, orderByComparator);
        }
        return this.ctCollectionPersistence.findByC_S(companyId, status, start, end, orderByComparator);
    }

    public List<CTEntry> getDiscardCTEntries(long ctCollectionId, long modelClassNameId, long modelClassPK) {
        long classPK2;
        Iterator<Object> iterator;
        CTClosure ctClosure = this._ctClosureFactory.create(ctCollectionId);
        HashSet<Node> nodes = new HashSet<Node>();
        int rootCount = this.ctEntryPersistence.countByC_MCNI_MCPK(ctCollectionId, modelClassNameId, modelClassPK);
        if (rootCount == 0) {
            Map pksMap = ctClosure.getChildPKsMap(modelClassNameId, modelClassPK);
            LinkedList queue = new LinkedList(pksMap.entrySet());
            Map.Entry entry = null;
            while ((entry = (Map.Entry)queue.poll()) != null) {
                long classNameId2 = (Long)entry.getKey();
                iterator = ((Collection)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    classPK2 = (Long)iterator.next();
                    int count = this.ctEntryPersistence.countByC_MCNI_MCPK(ctCollectionId, classNameId2, classPK2);
                    if (count == 0) {
                        Map childPKsMap = ctClosure.getChildPKsMap(classNameId2, classPK2);
                        if (childPKsMap.isEmpty()) continue;
                        queue.addAll(childPKsMap.entrySet());
                        continue;
                    }
                    nodes.add(new Node(classNameId2, classPK2));
                }
            }
        } else {
            nodes.add(new Node(modelClassNameId, modelClassPK));
        }
        HashMap<Long, Set<Long>> discardRootsMap = new HashMap<Long, Set<Long>>();
        CTEnclosureUtil.visitParentEntries(ctClosure, (classNameId, classPK, backtraceEntries) -> {
            if (!nodes.contains(new Node(classNameId, classPK))) {
                return false;
            }
            long previousModelClassNameId = classNameId;
            Iterator iterator = backtraceEntries.iterator();
            Map.Entry highestRequiredBacktraceEntry = null;
            while (iterator.hasNext()) {
                CTEntry ctEntry;
                Map.Entry backtraceEntry = (Map.Entry)iterator.next();
                long backtraceClassNameId = (Long)backtraceEntry.getKey();
                long backtraceClassPK = (Long)backtraceEntry.getValue();
                Set classPKs = (Set)discardRootsMap.get(backtraceClassNameId);
                if (classPKs != null && classPKs.contains(backtraceClassPK) || (ctEntry = this.ctEntryPersistence.fetchByC_MCNI_MCPK(ctCollectionId, backtraceClassNameId, backtraceClassPK)) == null || ctEntry.getChangeType() != 1 && this._tableReferenceDefinitionManager.isChildModelOptional(previousModelClassNameId, backtraceClassNameId)) break;
                highestRequiredBacktraceEntry = backtraceEntry;
                previousModelClassNameId = backtraceClassNameId;
            }
            if (highestRequiredBacktraceEntry != null) {
                Set classPKs = discardRootsMap.computeIfAbsent((Long)highestRequiredBacktraceEntry.getKey(), key -> new HashSet());
                classPKs.add(highestRequiredBacktraceEntry.getValue());
            }
            return true;
        });
        if (discardRootsMap.isEmpty()) {
            discardRootsMap.put(modelClassNameId, Collections.singleton(modelClassPK));
        }
        Map<Long, Set<Long>> discardEnclosureMap = CTEnclosureUtil.getEnclosureMap(ctClosure, discardRootsMap.entrySet());
        ArrayList<CTEntry> ctEntries = new ArrayList<CTEntry>(discardEnclosureMap.size());
        for (Map.Entry<Long, Set<Long>> entry : discardEnclosureMap.entrySet()) {
            iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                classPK2 = (Long)iterator.next();
                CTEntry ctEntry = this.ctEntryPersistence.fetchByC_MCNI_MCPK(ctCollectionId, entry.getKey().longValue(), classPK2);
                if (ctEntry == null) continue;
                ctEntries.add(ctEntry);
            }
        }
        return ctEntries;
    }

    public boolean isCTEntryEnclosed(long ctCollectionId, long modelClassNameId, long modelClassPK) {
        CTClosure ctClosure = this._ctClosureFactory.create(ctCollectionId);
        Map<Long, Set<Long>> enclosureMap = CTEnclosureUtil.getEnclosureMap(ctClosure, modelClassNameId, modelClassPK);
        for (Map.Entry<Long, Long> parentEntry : CTEnclosureUtil.getEnclosureParentEntries(ctClosure, enclosureMap)) {
            int count = this.ctEntryPersistence.countByC_MCNI_MCPK(ctCollectionId, parentEntry.getKey().longValue(), parentEntry.getValue().longValue());
            if (count <= 0) continue;
            return false;
        }
        return true;
    }

    public CTCollection undoCTCollection(long ctCollectionId, long userId, String name, String description) throws PortalException {
        CTCollection undoCTCollection = this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        if (undoCTCollection.getStatus() != 0) {
            throw new IllegalArgumentException("Unable to undo " + undoCTCollection + " because it is not published");
        }
        CTCollection newCTCollection = this.addCTCollection(undoCTCollection.getCompanyId(), userId, name, description);
        CTPreferences ctPreferences = this._ctPreferencesLocalService.getCTPreferences(undoCTCollection.getCompanyId(), userId);
        ctPreferences.setCtCollectionId(newCTCollection.getCtCollectionId());
        ctPreferences.setPreviousCtCollectionId(0L);
        this.ctPreferencesPersistence.update((BaseModel)ctPreferences);
        List publishedCTEntries = this.ctEntryPersistence.findByCTCollectionId(undoCTCollection.getCtCollectionId());
        HashMap<Long, CTServiceCopier> ctServiceCopiers = new HashMap<Long, CTServiceCopier>();
        long batchCounter = this.counterLocalService.increment(CTEntry.class.getName(), publishedCTEntries.size());
        batchCounter -= (long)publishedCTEntries.size();
        for (CTEntry publishedCTEntry : publishedCTEntries) {
            ctServiceCopiers.computeIfAbsent(publishedCTEntry.getModelClassNameId(), modelClassNameId -> {
                CTService<?> ctService = this._ctServiceRegistry.getCTService((long)modelClassNameId);
                if (ctService != null) {
                    return new CTServiceCopier(ctService, undoCTCollection.getCtCollectionId(), newCTCollection.getCtCollectionId());
                }
                throw new SystemException(StringBundler.concat((Object[])new Object[]{"Unable to undo ", undoCTCollection, " because service for ", modelClassNameId, " is missing"}));
            });
            CTEntry ctEntry = this.ctEntryPersistence.create(++batchCounter);
            ctEntry.setCompanyId(newCTCollection.getCompanyId());
            ctEntry.setUserId(newCTCollection.getUserId());
            ctEntry.setCtCollectionId(newCTCollection.getCtCollectionId());
            ctEntry.setModelClassNameId(publishedCTEntry.getModelClassNameId());
            ctEntry.setModelClassPK(publishedCTEntry.getModelClassPK());
            ctEntry.setModelMvccVersion(publishedCTEntry.getModelMvccVersion());
            int changeType = publishedCTEntry.getChangeType();
            if (changeType == 0) {
                changeType = 1;
            } else if (changeType == 1) {
                changeType = 0;
            }
            ctEntry.setChangeType(changeType);
            this.ctEntryPersistence.update((BaseModel)ctEntry);
        }
        try {
            for (CTServiceCopier ctServiceCopier : ctServiceCopiers.values()) {
                ctServiceCopier.copy();
            }
            for (CTTableMapperHelper ctTableMapperHelper : this._ctServiceRegistry.getCTTableMapperHelpers()) {
                ctTableMapperHelper.undo(undoCTCollection.getCtCollectionId(), newCTCollection.getCtCollectionId());
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        this._ctServiceRegistry.onAfterCopy(undoCTCollection, newCTCollection);
        return newCTCollection;
    }

    public CTCollection updateCTCollection(long userId, long ctCollectionId, String name, String description) throws PortalException {
        this._validate(name, description);
        CTCollection ctCollection = this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        Date modifiedDate = new Date();
        ctCollection.setModifiedDate(modifiedDate);
        ctCollection.setName(name);
        ctCollection.setDescription(description);
        ctCollection.setStatusByUserId(userId);
        ctCollection.setStatusDate(modifiedDate);
        return (CTCollection)this.ctCollectionPersistence.update((BaseModel)ctCollection);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._constraintResolverServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ConstraintResolver.class, null, (serviceReference, emitter) -> {
            ConstraintResolver constraintResolver = (ConstraintResolver)bundleContext.getService(serviceReference);
            emitter.emit((Object)new ConstraintResolverKey(constraintResolver.getModelClass(), constraintResolver.getUniqueIndexColumnNames()));
        });
        this._ctDisplayRendererServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CTDisplayRenderer.class, null, (serviceReference, emitter) -> {
            CTDisplayRenderer ctDisplayRenderer = (CTDisplayRenderer)bundleContext.getService(serviceReference);
            Class modelClass = ctDisplayRenderer.getModelClass();
            emitter.emit((Object)modelClass.getName());
        });
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
        this._constraintResolverServiceTrackerMap.close();
        this._ctDisplayRendererServiceTrackerMap.close();
    }

    private void _validate(String name, String description) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CTCollectionNameException();
        }
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)CTCollection.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new CTCollectionNameException("Name is too long");
        }
        int descriptionMaxLength = ModelHintsUtil.getMaxLength((String)CTCollection.class.getName(), (String)"description");
        if (description != null && description.length() > descriptionMaxLength) {
            throw new CTCollectionDescriptionException("Description is too long");
        }
    }
}

