/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.closure;

import com.liferay.change.tracking.closure.CTClosure;
import com.liferay.change.tracking.closure.CTClosureFactory;
import com.liferay.change.tracking.internal.closure.CTClosureImpl;
import com.liferay.change.tracking.internal.closure.Edge;
import com.liferay.change.tracking.internal.closure.GraphUtil;
import com.liferay.change.tracking.internal.closure.Node;
import com.liferay.change.tracking.internal.reference.TableJoinHolder;
import com.liferay.change.tracking.internal.reference.TableReferenceDefinitionManager;
import com.liferay.change.tracking.internal.reference.TableReferenceInfo;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.spi.reference.TableReferenceDefinition;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.spi.ast.DefaultASTNodeListener;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CTClosureFactory.class})
public class CTClosureFactoryImpl
implements CTClosureFactory {
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private TableReferenceDefinitionManager _tableReferenceDefinitionManager;

    public CTClosure create(long ctCollectionId) {
        return new CTClosureImpl(ctCollectionId, this._buildClosureMap(ctCollectionId, this._tableReferenceDefinitionManager.getCombinedTableReferenceInfos()));
    }

    private Map<Node, Collection<Node>> _buildClosureMap(long ctCollectionId, Map<Long, TableReferenceInfo<?>> combinedTableReferenceInfos) {
        HashMap<Long, List> map = new HashMap<Long, List>();
        HashSet<Node> nodes = new HashSet<Node>();
        for (CTEntry ctEntry : this._ctEntryLocalService.getCTCollectionCTEntries(ctCollectionId)) {
            List primaryKeys = map.computeIfAbsent(ctEntry.getModelClassNameId(), key -> new ArrayList());
            primaryKeys.add(ctEntry.getModelClassPK());
            nodes.add(new Node(ctEntry.getModelClassNameId(), ctEntry.getModelClassPK()));
        }
        LinkedHashMap<Node, Collection<Edge>> edgeMap = new LinkedHashMap<Node, Collection<Edge>>();
        LinkedList queue = new LinkedList(map.entrySet());
        while (queue.size() > 0) {
            Map.Entry queueEntry = (Map.Entry)queue.poll();
            long childClassNameId = (Long)queueEntry.getKey();
            TableReferenceInfo<?> childTableReferenceInfo = combinedTableReferenceInfos.get(childClassNameId);
            if (childTableReferenceInfo == null) {
                throw new IllegalArgumentException("No table reference definition for " + childClassNameId);
            }
            List childPrimaryKeys = (List)queueEntry.getValue();
            Long[] childPrimaryKeysArray = childPrimaryKeys.toArray(new Long[0]);
            Map<Table<?>, List<TableJoinHolder>> parentTableJoinHoldersMap = childTableReferenceInfo.getParentTableJoinHoldersMap();
            for (Map.Entry<Table<?>, List<TableJoinHolder>> entry : parentTableJoinHoldersMap.entrySet()) {
                long parentClassNameId = this._tableReferenceDefinitionManager.getClassNameId(entry.getKey());
                TableReferenceInfo<?> parentTableReferenceInfo = combinedTableReferenceInfos.get(parentClassNameId);
                DSLQuery dslQuery = this._getDSLQuery(ctCollectionId, childPrimaryKeysArray, entry.getValue());
                try {
                    Connection connection = this._getConnection(parentTableReferenceInfo);
                    Throwable throwable = null;
                    try {
                        PreparedStatement preparedStatement = this._getPreparedStatement(connection, dslQuery);
                        Throwable throwable2 = null;
                        try {
                            ResultSet resultSet = preparedStatement.executeQuery();
                            Throwable throwable3 = null;
                            try {
                                ArrayList<Long> newParents = null;
                                while (resultSet.next()) {
                                    Node parentNode = new Node(parentClassNameId, resultSet.getLong(1));
                                    Node childNode = new Node(childClassNameId, resultSet.getLong(2));
                                    if (nodes.add(parentNode)) {
                                        if (newParents == null) {
                                            newParents = new ArrayList<Long>();
                                        }
                                        newParents.add(parentNode.getPrimaryKey());
                                    }
                                    Collection edges = edgeMap.computeIfAbsent(parentNode, key -> new LinkedList());
                                    edges.add(new Edge(parentNode, childNode));
                                }
                                if (newParents == null) continue;
                                queue.add(new AbstractMap.SimpleImmutableEntry<Long, Object>(parentClassNameId, newParents));
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (resultSet == null) continue;
                                if (throwable3 != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable3.addSuppressed(throwable5);
                                    }
                                    continue;
                                }
                                resultSet.close();
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable2 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (preparedStatement == null) continue;
                            if (throwable2 != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                                continue;
                            }
                            preparedStatement.close();
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (connection == null) continue;
                        if (throwable != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                            continue;
                        }
                        connection.close();
                    }
                }
                catch (SQLException sqlException) {
                    throw new ORMException("Unable to execute query: " + dslQuery, (Throwable)sqlException);
                }
            }
        }
        return GraphUtil.getNodeMap(nodes, edgeMap);
    }

    private Connection _getConnection(TableReferenceInfo<?> tableReferenceInfo) throws SQLException {
        TableReferenceDefinition<?> tableReferenceDefinition = tableReferenceInfo.getTableReferenceDefinition();
        BasePersistence basePersistence = tableReferenceDefinition.getBasePersistence();
        DataSource dataSource = basePersistence.getDataSource();
        return dataSource.getConnection();
    }

    private DSLQuery _getDSLQuery(long ctCollectionId, Long[] childPrimaryKeysArray, List<TableJoinHolder> tableJoinHolders) {
        GroupByStep dslQuery = null;
        for (TableJoinHolder parentJoinHolder : tableJoinHolders) {
            Column<?, Long> parentPKColumn = parentJoinHolder.getParentPKColumn();
            Column<?, Long> childPKColumn = parentJoinHolder.getChildPKColumn();
            FromStep fromStep = DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{parentPKColumn, childPKColumn});
            Function<FromStep, JoinStep> joinFunction = parentJoinHolder.getJoinFunction();
            JoinStep joinStep = joinFunction.apply(fromStep);
            GroupByStep groupByStep = joinStep.where(() -> {
                Predicate predicate = childPKColumn.in((Object[])childPrimaryKeysArray);
                Table parentTable = parentPKColumn.getTable();
                Column ctCollectionIdColumn = parentTable.getColumn("ctCollectionId", Long.class);
                if (ctCollectionIdColumn != null && ctCollectionIdColumn.isPrimaryKey()) {
                    predicate = predicate.and((Expression)ctCollectionIdColumn.eq((Object)0L).or((Expression)ctCollectionIdColumn.eq((Object)ctCollectionId)).withParentheses());
                }
                return predicate;
            });
            if (dslQuery == null) {
                dslQuery = groupByStep;
                continue;
            }
            dslQuery = dslQuery.union((DSLQuery)groupByStep);
        }
        return dslQuery;
    }

    private PreparedStatement _getPreparedStatement(Connection connection, DSLQuery dslQuery) throws SQLException {
        DefaultASTNodeListener defaultASTNodeListener = new DefaultASTNodeListener();
        PreparedStatement preparedStatement = connection.prepareStatement(SQLTransformer.transform((String)dslQuery.toSQL((ASTNodeListener)defaultASTNodeListener)));
        List scalarValues = defaultASTNodeListener.getScalarValues();
        for (int i = 0; i < scalarValues.size(); ++i) {
            preparedStatement.setObject(i + 1, scalarValues.get(i));
        }
        return preparedStatement;
    }
}

