/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal;

import com.liferay.change.tracking.closure.CTClosure;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CTEnclosureUtil {
    public static Map<Long, Set<Long>> getEnclosureMap(CTClosure ctClosure, long modelClassNameId, long modelClassPK) {
        return CTEnclosureUtil.getEnclosureMap(ctClosure, Collections.singleton(new AbstractMap.SimpleImmutableEntry<Long, Set<Long>>(modelClassNameId, Collections.singleton(modelClassPK))));
    }

    public static Map<Long, Set<Long>> getEnclosureMap(CTClosure ctClosure, Set<Map.Entry<Long, Set<Long>>> rootEntries) {
        HashMap<Long, Set<Long>> enclosureMap = new HashMap<Long, Set<Long>>();
        LinkedList<Map.Entry<Long, Set<Long>>> queue = new LinkedList<Map.Entry<Long, Set<Long>>>(rootEntries);
        Map.Entry entry = null;
        while ((entry = (Map.Entry)queue.poll()) != null) {
            long classNameId = (Long)entry.getKey();
            Iterator iterator = ((Collection)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                Map childPKsMap;
                long classPK = (Long)iterator.next();
                Set classPKs = enclosureMap.computeIfAbsent(classNameId, key -> new HashSet());
                if (!classPKs.add(classPK) || (childPKsMap = ctClosure.getChildPKsMap(classNameId, classPK)).isEmpty()) continue;
                queue.addAll(childPKsMap.entrySet());
            }
        }
        return enclosureMap;
    }

    public static Set<Map.Entry<Long, Long>> getEnclosureParentEntries(CTClosure ctClosure, Map<Long, Set<Long>> enclosureMap) {
        HashSet<Map.Entry<Long, Long>> parentEntries = new HashSet<Map.Entry<Long, Long>>();
        CTEnclosureUtil.visitParentEntries(ctClosure, (classNameId, classPK, backtraceEntries) -> {
            Set classPKs = (Set)enclosureMap.get(classNameId);
            if (classPKs != null && classPKs.contains(classPK)) {
                parentEntries.addAll(backtraceEntries);
                return true;
            }
            return false;
        });
        return parentEntries;
    }

    public static void visitParentEntries(CTClosure ctClosure, BacktraceVisitor backtraceVisitor) {
        CTEnclosureUtil._visitParentEntries(ctClosure, ctClosure.getRootPKsMap(), new LinkedList<Map.Entry<Long, Long>>(), backtraceVisitor);
    }

    private static void _visitParentEntries(CTClosure ctClosure, Map<Long, List<Long>> childPKsMap, Deque<Map.Entry<Long, Long>> backtraceEntries, BacktraceVisitor backtraceVisitor) {
        for (Map.Entry<Long, List<Long>> entry : childPKsMap.entrySet()) {
            long classNameId = entry.getKey();
            for (long classPK : entry.getValue()) {
                if (backtraceVisitor.visit(classNameId, classPK, backtraceEntries)) continue;
                backtraceEntries.push(new AbstractMap.SimpleImmutableEntry<Long, Long>(classNameId, classPK));
                CTEnclosureUtil._visitParentEntries(ctClosure, ctClosure.getChildPKsMap(classNameId, classPK), backtraceEntries, backtraceVisitor);
                backtraceEntries.pop();
            }
        }
    }

    public static interface BacktraceVisitor {
        public boolean visit(long var1, long var3, Deque<Map.Entry<Long, Long>> var5);
    }
}

