/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.background.task;

import com.liferay.change.tracking.conflict.ConflictInfo;
import com.liferay.change.tracking.internal.CTServiceRegistry;
import com.liferay.change.tracking.internal.CTTableMapperHelper;
import com.liferay.change.tracking.internal.background.task.CTServicePublisher;
import com.liferay.change.tracking.internal.background.task.display.CTPublishBackgroundTaskDisplay;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.service.CTMessageLocalService;
import com.liferay.change.tracking.service.CTProcessLocalService;
import com.liferay.petra.lang.SafeClosable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BaseBackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"background.task.executor.class.name=com.liferay.change.tracking.internal.background.task.CTPublishBackgroundTaskExecutor"}, service={AopService.class})
public class CTPublishBackgroundTaskExecutor
extends BaseBackgroundTaskExecutor
implements AopService {
    private BackgroundTaskExecutor _backgroundTaskExecutor;
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTMessageLocalService _ctMessageLocalService;
    @Reference
    private CTProcessLocalService _ctProcessLocalService;
    @Reference
    private CTServiceRegistry _ctServiceRegistry;
    @Reference
    private MultiVMPool _multiVMPool;

    public CTPublishBackgroundTaskExecutor() {
        this.setIsolationLevel(2);
    }

    public BackgroundTaskExecutor clone() {
        return this._backgroundTaskExecutor;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        long ctCollectionId = GetterUtil.getLong(taskContextMap.get("ctCollectionId"));
        try (SafeClosable safeClosable = CTCollectionThreadLocal.setCTCollectionId((long)ctCollectionId);){
            this._ctServiceRegistry.onBeforePublish(ctCollectionId);
        }
        CTCollection ctCollection = this._ctCollectionLocalService.getCTCollection(ctCollectionId);
        Map conflictInfosMap = this._ctCollectionLocalService.checkConflicts(ctCollection);
        if (!conflictInfosMap.isEmpty()) {
            ArrayList<ConflictInfo> unresolvedConflictInfos = new ArrayList<ConflictInfo>();
            for (Map.Entry entry : conflictInfosMap.entrySet()) {
                for (ConflictInfo conflictInfo : (List)entry.getValue()) {
                    if (conflictInfo.isResolved()) continue;
                    unresolvedConflictInfos.add(conflictInfo);
                }
            }
            if (!unresolvedConflictInfos.isEmpty()) {
                throw new SystemException(StringBundler.concat((Object[])new Object[]{"Unable to publish ", ctCollection.getName(), " because of unresolved conflicts: ", unresolvedConflictInfos}));
            }
        }
        List ctEntries = this._ctEntryLocalService.getCTCollectionCTEntries(ctCollectionId);
        HashMap<Long, CTServicePublisher> ctServicePublishers = new HashMap<Long, CTServicePublisher>();
        for (CTEntry ctEntry : ctEntries) {
            CTServicePublisher ctServicePublisher = ctServicePublishers.computeIfAbsent(ctEntry.getModelClassNameId(), modelClassNameId -> {
                CTService<?> ctService = this._ctServiceRegistry.getCTService((long)modelClassNameId);
                if (ctService != null) {
                    return new CTServicePublisher(this._ctEntryLocalService, ctService, (long)modelClassNameId, ctCollectionId, 0L);
                }
                throw new SystemException(StringBundler.concat((Object[])new Object[]{"Unable to publish ", ctCollectionId, " because service for ", modelClassNameId, " is missing"}));
            });
            ctServicePublisher.addCTEntry(ctEntry);
        }
        for (CTServicePublisher ctServicePublisher : ctServicePublishers.values()) {
            ctServicePublisher.publish();
        }
        for (CTTableMapperHelper ctTableMapperHelper : this._ctServiceRegistry.getCTTableMapperHelpers()) {
            ctTableMapperHelper.publish(ctCollectionId, this._multiVMPool.getPortalCacheManager());
        }
        Date date = new Date();
        ctCollection.setModifiedDate(date);
        ctCollection.setStatus(0);
        ctCollection.setStatusByUserId(backgroundTask.getUserId());
        ctCollection.setStatusDate(date);
        this._ctCollectionLocalService.updateCTCollection(ctCollection);
        this._ctServiceRegistry.onAfterPublish(ctCollectionId);
        return BackgroundTaskResult.SUCCESS;
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{BackgroundTaskExecutor.class};
    }

    public BackgroundTaskDisplay getBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        return new CTPublishBackgroundTaskDisplay(backgroundTask);
    }

    public void setAopProxy(Object aopProxy) {
        this._backgroundTaskExecutor = (BackgroundTaskExecutor)aopProxy;
    }
}

