/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.persistence.impl;

import com.liferay.change.tracking.exception.NoSuchCollectionException;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTCollectionTable;
import com.liferay.change.tracking.model.impl.CTCollectionImpl;
import com.liferay.change.tracking.model.impl.CTCollectionModelImpl;
import com.liferay.change.tracking.service.persistence.CTCollectionPersistence;
import com.liferay.change.tracking.service.persistence.impl.constants.CTPersistenceConstants;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTCollectionPersistence.class})
public class CTCollectionPersistenceImpl
extends BasePersistenceImpl<CTCollection>
implements CTCollectionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CTCollectionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "ctCollection.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByC_S;
    private FinderPath _finderPathWithoutPaginationFindByC_S;
    private FinderPath _finderPathCountByC_S;
    private static final String _FINDER_COLUMN_C_S_COMPANYID_2 = "ctCollection.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_S_STATUS_2 = "ctCollection.status = ?";
    private BundleContext _bundleContext;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_CTCOLLECTION = "SELECT ctCollection FROM CTCollection ctCollection";
    private static final String _SQL_SELECT_CTCOLLECTION_WHERE = "SELECT ctCollection FROM CTCollection ctCollection WHERE ";
    private static final String _SQL_COUNT_CTCOLLECTION = "SELECT COUNT(ctCollection) FROM CTCollection ctCollection";
    private static final String _SQL_COUNT_CTCOLLECTION_WHERE = "SELECT COUNT(ctCollection) FROM CTCollection ctCollection WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "ctCollection.ctCollectionId";
    private static final String _FILTER_SQL_SELECT_CTCOLLECTION_WHERE = "SELECT DISTINCT {ctCollection.*} FROM CTCollection ctCollection WHERE ";
    private static final String _FILTER_SQL_SELECT_CTCOLLECTION_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {CTCollection.*} FROM (SELECT DISTINCT ctCollection.ctCollectionId FROM CTCollection ctCollection WHERE ";
    private static final String _FILTER_SQL_SELECT_CTCOLLECTION_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN CTCollection ON TEMP_TABLE.ctCollectionId = CTCollection.ctCollectionId";
    private static final String _FILTER_SQL_COUNT_CTCOLLECTION_WHERE = "SELECT COUNT(DISTINCT ctCollection.ctCollectionId) AS COUNT_VALUE FROM CTCollection ctCollection WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "ctCollection";
    private static final String _FILTER_ENTITY_TABLE = "CTCollection";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ctCollection.";
    private static final String _ORDER_BY_ENTITY_TABLE = "CTCollection.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CTCollection exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CTCollection exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CTCollectionPersistenceImpl.class);
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();

    public List<CTCollection> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<CTCollection> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<CTCollection> findByCompanyId(long companyId, int start, int end, OrderByComparator<CTCollection> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<CTCollection> findByCompanyId(long companyId, int start, int end, OrderByComparator<CTCollection> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CTCollection ctCollection : list) {
                if (companyId == ctCollection.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_CTCOLLECTION_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ctCollection.createDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CTCollection findByCompanyId_First(long companyId, OrderByComparator<CTCollection> orderByComparator) throws NoSuchCollectionException {
        CTCollection ctCollection = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (ctCollection != null) {
            return ctCollection;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchCollectionException(sb.toString());
    }

    public CTCollection fetchByCompanyId_First(long companyId, OrderByComparator<CTCollection> orderByComparator) {
        List<CTCollection> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CTCollection findByCompanyId_Last(long companyId, OrderByComparator<CTCollection> orderByComparator) throws NoSuchCollectionException {
        CTCollection ctCollection = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (ctCollection != null) {
            return ctCollection;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchCollectionException(sb.toString());
    }

    public CTCollection fetchByCompanyId_Last(long companyId, OrderByComparator<CTCollection> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<CTCollection> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CTCollection[] findByCompanyId_PrevAndNext(long ctCollectionId, long companyId, OrderByComparator<CTCollection> orderByComparator) throws NoSuchCollectionException {
        CTCollection ctCollection = this.findByPrimaryKey(ctCollectionId);
        Session session = null;
        try {
            session = this.openSession();
            CTCollection[] array = new CTCollectionImpl[]{this.getByCompanyId_PrevAndNext(session, ctCollection, companyId, orderByComparator, true), ctCollection, this.getByCompanyId_PrevAndNext(session, ctCollection, companyId, orderByComparator, false)};
            CTCollection[] cTCollectionArray = array;
            return cTCollectionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CTCollection getByCompanyId_PrevAndNext(Session session, CTCollection ctCollection, long companyId, OrderByComparator<CTCollection> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_CTCOLLECTION_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ctCollection.createDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ctCollection)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CTCollection)list.get(1);
        }
        return null;
    }

    public List<CTCollection> filterFindByCompanyId(long companyId) {
        return this.filterFindByCompanyId(companyId, -1, -1, null);
    }

    public List<CTCollection> filterFindByCompanyId(long companyId, int start, int end) {
        return this.filterFindByCompanyId(companyId, start, end, null);
    }

    public List<CTCollection> filterFindByCompanyId(long companyId, int start, int end, OrderByComparator<CTCollection> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByCompanyId(companyId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_CTCOLLECTION_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_CTCOLLECTION_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_CTCOLLECTION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY ctCollection.createDate ASC");
        } else {
            sb.append(" ORDER BY CTCollection.createDate ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CTCollection.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CTCollectionImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CTCollectionImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CTCollection[] filterFindByCompanyId_PrevAndNext(long ctCollectionId, long companyId, OrderByComparator<CTCollection> orderByComparator) throws NoSuchCollectionException {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByCompanyId_PrevAndNext(ctCollectionId, companyId, orderByComparator);
        }
        CTCollection ctCollection = this.findByPrimaryKey(ctCollectionId);
        Session session = null;
        try {
            session = this.openSession();
            CTCollection[] array = new CTCollectionImpl[]{this.filterGetByCompanyId_PrevAndNext(session, ctCollection, companyId, orderByComparator, true), ctCollection, this.filterGetByCompanyId_PrevAndNext(session, ctCollection, companyId, orderByComparator, false)};
            CTCollection[] cTCollectionArray = array;
            return cTCollectionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CTCollection filterGetByCompanyId_PrevAndNext(Session session, CTCollection ctCollection, long companyId, OrderByComparator<CTCollection> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_CTCOLLECTION_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_CTCOLLECTION_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_CTCOLLECTION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY ctCollection.createDate ASC");
        } else {
            sb.append(" ORDER BY CTCollection.createDate ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CTCollection.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CTCollectionImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CTCollectionImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ctCollection)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (CTCollection)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (CTCollection ctCollection : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)ctCollection);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_CTCOLLECTION_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByCompanyId(long companyId) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.countByCompanyId(companyId);
        }
        StringBundler sb = new StringBundler(2);
        sb.append(_FILTER_SQL_COUNT_CTCOLLECTION_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CTCollection.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CTCollection> findByC_S(long companyId, int status) {
        return this.findByC_S(companyId, status, -1, -1, null);
    }

    public List<CTCollection> findByC_S(long companyId, int status, int start, int end) {
        return this.findByC_S(companyId, status, start, end, null);
    }

    public List<CTCollection> findByC_S(long companyId, int status, int start, int end, OrderByComparator<CTCollection> orderByComparator) {
        return this.findByC_S(companyId, status, start, end, orderByComparator, true);
    }

    public List<CTCollection> findByC_S(long companyId, int status, int start, int end, OrderByComparator<CTCollection> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_S;
                finderArgs = new Object[]{companyId, status};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_S;
            finderArgs = new Object[]{companyId, status, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CTCollection ctCollection : list) {
                if (companyId == ctCollection.getCompanyId() && status == ctCollection.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_CTCOLLECTION_WHERE);
            sb.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            sb.append(_FINDER_COLUMN_C_S_STATUS_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ctCollection.createDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(status);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CTCollection findByC_S_First(long companyId, int status, OrderByComparator<CTCollection> orderByComparator) throws NoSuchCollectionException {
        CTCollection ctCollection = this.fetchByC_S_First(companyId, status, orderByComparator);
        if (ctCollection != null) {
            return ctCollection;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchCollectionException(sb.toString());
    }

    public CTCollection fetchByC_S_First(long companyId, int status, OrderByComparator<CTCollection> orderByComparator) {
        List<CTCollection> list = this.findByC_S(companyId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CTCollection findByC_S_Last(long companyId, int status, OrderByComparator<CTCollection> orderByComparator) throws NoSuchCollectionException {
        CTCollection ctCollection = this.fetchByC_S_Last(companyId, status, orderByComparator);
        if (ctCollection != null) {
            return ctCollection;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchCollectionException(sb.toString());
    }

    public CTCollection fetchByC_S_Last(long companyId, int status, OrderByComparator<CTCollection> orderByComparator) {
        int count = this.countByC_S(companyId, status);
        if (count == 0) {
            return null;
        }
        List<CTCollection> list = this.findByC_S(companyId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CTCollection[] findByC_S_PrevAndNext(long ctCollectionId, long companyId, int status, OrderByComparator<CTCollection> orderByComparator) throws NoSuchCollectionException {
        CTCollection ctCollection = this.findByPrimaryKey(ctCollectionId);
        Session session = null;
        try {
            session = this.openSession();
            CTCollection[] array = new CTCollectionImpl[]{this.getByC_S_PrevAndNext(session, ctCollection, companyId, status, orderByComparator, true), ctCollection, this.getByC_S_PrevAndNext(session, ctCollection, companyId, status, orderByComparator, false)};
            CTCollection[] cTCollectionArray = array;
            return cTCollectionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CTCollection getByC_S_PrevAndNext(Session session, CTCollection ctCollection, long companyId, int status, OrderByComparator<CTCollection> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_CTCOLLECTION_WHERE);
        sb.append(_FINDER_COLUMN_C_S_COMPANYID_2);
        sb.append(_FINDER_COLUMN_C_S_STATUS_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ctCollection.createDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ctCollection)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CTCollection)list.get(1);
        }
        return null;
    }

    public List<CTCollection> filterFindByC_S(long companyId, int status) {
        return this.filterFindByC_S(companyId, status, -1, -1, null);
    }

    public List<CTCollection> filterFindByC_S(long companyId, int status, int start, int end) {
        return this.filterFindByC_S(companyId, status, start, end, null);
    }

    public List<CTCollection> filterFindByC_S(long companyId, int status, int start, int end, OrderByComparator<CTCollection> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByC_S(companyId, status, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_CTCOLLECTION_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_CTCOLLECTION_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_C_S_COMPANYID_2);
        sb.append(_FINDER_COLUMN_C_S_STATUS_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_CTCOLLECTION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY ctCollection.createDate ASC");
        } else {
            sb.append(" ORDER BY CTCollection.createDate ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CTCollection.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CTCollectionImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CTCollectionImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(status);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CTCollection[] filterFindByC_S_PrevAndNext(long ctCollectionId, long companyId, int status, OrderByComparator<CTCollection> orderByComparator) throws NoSuchCollectionException {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByC_S_PrevAndNext(ctCollectionId, companyId, status, orderByComparator);
        }
        CTCollection ctCollection = this.findByPrimaryKey(ctCollectionId);
        Session session = null;
        try {
            session = this.openSession();
            CTCollection[] array = new CTCollectionImpl[]{this.filterGetByC_S_PrevAndNext(session, ctCollection, companyId, status, orderByComparator, true), ctCollection, this.filterGetByC_S_PrevAndNext(session, ctCollection, companyId, status, orderByComparator, false)};
            CTCollection[] cTCollectionArray = array;
            return cTCollectionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CTCollection filterGetByC_S_PrevAndNext(Session session, CTCollection ctCollection, long companyId, int status, OrderByComparator<CTCollection> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_CTCOLLECTION_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_CTCOLLECTION_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_C_S_COMPANYID_2);
        sb.append(_FINDER_COLUMN_C_S_STATUS_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_CTCOLLECTION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY ctCollection.createDate ASC");
        } else {
            sb.append(" ORDER BY CTCollection.createDate ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CTCollection.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CTCollectionImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CTCollectionImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(companyId);
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ctCollection)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (CTCollection)list.get(1);
        }
        return null;
    }

    public void removeByC_S(long companyId, int status) {
        for (CTCollection ctCollection : this.findByC_S(companyId, status, -1, -1, null)) {
            this.remove((BaseModel)ctCollection);
        }
    }

    public int countByC_S(long companyId, int status) {
        FinderPath finderPath = this._finderPathCountByC_S;
        Object[] finderArgs = new Object[]{companyId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_CTCOLLECTION_WHERE);
            sb.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            sb.append(_FINDER_COLUMN_C_S_STATUS_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(status);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByC_S(long companyId, int status) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.countByC_S(companyId, status);
        }
        StringBundler sb = new StringBundler(3);
        sb.append(_FILTER_SQL_COUNT_CTCOLLECTION_WHERE);
        sb.append(_FINDER_COLUMN_C_S_COMPANYID_2);
        sb.append(_FINDER_COLUMN_C_S_STATUS_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CTCollection.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(status);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CTCollectionPersistenceImpl() {
        this.setModelClass(CTCollection.class);
        this.setModelImplClass(CTCollectionImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CTCollectionTable.INSTANCE);
    }

    public void cacheResult(CTCollection ctCollection) {
        this.entityCache.putResult(CTCollectionImpl.class, (Serializable)Long.valueOf(ctCollection.getPrimaryKey()), (Serializable)ctCollection);
    }

    public void cacheResult(List<CTCollection> ctCollections) {
        for (CTCollection ctCollection : ctCollections) {
            if (this.entityCache.getResult(CTCollectionImpl.class, (Serializable)Long.valueOf(ctCollection.getPrimaryKey())) != null) continue;
            this.cacheResult(ctCollection);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CTCollectionImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CTCollection ctCollection) {
        this.entityCache.removeResult(CTCollectionImpl.class, (BaseModel)ctCollection);
    }

    public void clearCache(List<CTCollection> ctCollections) {
        for (CTCollection ctCollection : ctCollections) {
            this.entityCache.removeResult(CTCollectionImpl.class, (BaseModel)ctCollection);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CTCollectionImpl.class, primaryKey);
        }
    }

    public CTCollection create(long ctCollectionId) {
        CTCollectionImpl ctCollection = new CTCollectionImpl();
        ctCollection.setNew(true);
        ctCollection.setPrimaryKey(ctCollectionId);
        ctCollection.setCompanyId(CompanyThreadLocal.getCompanyId());
        return ctCollection;
    }

    public CTCollection remove(long ctCollectionId) throws NoSuchCollectionException {
        return this.remove(Long.valueOf(ctCollectionId));
    }

    public CTCollection remove(Serializable primaryKey) throws NoSuchCollectionException {
        Session session = null;
        try {
            session = this.openSession();
            CTCollection ctCollection = (CTCollection)session.get(CTCollectionImpl.class, primaryKey);
            if (ctCollection == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchCollectionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CTCollection cTCollection = (CTCollection)this.remove((BaseModel)ctCollection);
            return cTCollection;
        }
        catch (NoSuchCollectionException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CTCollection removeImpl(CTCollection ctCollection) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)ctCollection)) {
                ctCollection = (CTCollection)session.get(CTCollectionImpl.class, ctCollection.getPrimaryKeyObj());
            }
            if (ctCollection != null) {
                session.delete((Object)ctCollection);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (ctCollection != null) {
            this.clearCache(ctCollection);
        }
        return ctCollection;
    }

    public CTCollection updateImpl(CTCollection ctCollection) {
        boolean isNew = ctCollection.isNew();
        if (!(ctCollection instanceof CTCollectionModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ctCollection.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)ctCollection);
                throw new IllegalArgumentException("Implement ModelWrapper in ctCollection proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CTCollection implementation " + ctCollection.getClass());
        }
        CTCollectionModelImpl ctCollectionModelImpl = (CTCollectionModelImpl)ctCollection;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && ctCollection.getCreateDate() == null) {
            if (serviceContext == null) {
                ctCollection.setCreateDate(now);
            } else {
                ctCollection.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!ctCollectionModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                ctCollection.setModifiedDate(now);
            } else {
                ctCollection.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)ctCollection);
            } else {
                ctCollection = (CTCollection)session.merge((Object)ctCollection);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(CTCollectionImpl.class, (BaseModel)ctCollectionModelImpl, false, true);
        if (isNew) {
            ctCollection.setNew(false);
        }
        ctCollection.resetOriginalValues();
        return ctCollection;
    }

    public CTCollection findByPrimaryKey(Serializable primaryKey) throws NoSuchCollectionException {
        CTCollection ctCollection = (CTCollection)this.fetchByPrimaryKey(primaryKey);
        if (ctCollection == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchCollectionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ctCollection;
    }

    public CTCollection findByPrimaryKey(long ctCollectionId) throws NoSuchCollectionException {
        return this.findByPrimaryKey(Long.valueOf(ctCollectionId));
    }

    public CTCollection fetchByPrimaryKey(long ctCollectionId) {
        return (CTCollection)this.fetchByPrimaryKey(Long.valueOf(ctCollectionId));
    }

    public List<CTCollection> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CTCollection> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CTCollection> findAll(int start, int end, OrderByComparator<CTCollection> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CTCollection> findAll(int start, int end, OrderByComparator<CTCollection> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_CTCOLLECTION);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_CTCOLLECTION;
                sql = sql.concat(" ORDER BY ctCollection.createDate ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CTCollection ctCollection : this.findAll()) {
            this.remove((BaseModel)ctCollection);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_CTCOLLECTION);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "ctCollectionId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_CTCOLLECTION;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CTCollectionModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new CTCollectionModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)CTCollection.class.getName()));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathWithPaginationFindByC_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "status"}, true);
        this._finderPathWithoutPaginationFindByC_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_S", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"companyId", "status"}, true);
        this._finderPathCountByC_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_S", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"companyId", "status"}, false);
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(CTCollectionImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.change.tracking.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.change.tracking.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.change.tracking.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    static {
        try {
            Class.forName(CTPersistenceConstants.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException);
        }
    }

    private static class CTCollectionModelArgumentsResolver
    implements ArgumentsResolver {
        private static Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private CTCollectionModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            CTCollectionModelImpl ctCollectionModelImpl = (CTCollectionModelImpl)baseModel;
            long columnBitmask = ctCollectionModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return this._getValue(ctCollectionModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | CTCollectionModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return this._getValue(ctCollectionModelImpl, columnNames, original);
            }
            return null;
        }

        private Object[] _getValue(CTCollectionModelImpl ctCollectionModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? ctCollectionModelImpl.getColumnOriginalValue(columnName) : ctCollectionModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

