/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.conflict;

import com.liferay.change.tracking.conflict.ConflictInfo;
import com.liferay.change.tracking.spi.display.CTDisplayRenderer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.Locale;
import java.util.ResourceBundle;

public class MissingRequirementConflictInfo
implements ConflictInfo {
    private final String _className;
    private final long _modelClassPK;
    private final CTDisplayRenderer<?> _requirementCTDisplayRenderer;

    public MissingRequirementConflictInfo(String className, long modelClassPK, CTDisplayRenderer<?> requirementCTDisplayRenderer) {
        this._className = className;
        this._modelClassPK = modelClassPK;
        this._requirementCTDisplayRenderer = requirementCTDisplayRenderer;
    }

    public String getConflictDescription(ResourceBundle resourceBundle) {
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"missing-requirement-conflict");
    }

    public long getCTAutoResolutionInfoId() {
        return 0L;
    }

    public String getResolutionDescription(ResourceBundle resourceBundle) {
        return LanguageUtil.format((ResourceBundle)resourceBundle, (String)"cannot-be-added-because-a-required-x-has-been-deleted", (Object)this._getRequirementTypeName(resourceBundle.getLocale()), (boolean)false);
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((Locale)locale, MissingRequirementConflictInfo.class);
    }

    public long getSourcePrimaryKey() {
        return this._modelClassPK;
    }

    public long getTargetPrimaryKey() {
        return 0L;
    }

    public boolean isResolved() {
        return false;
    }

    private String _getRequirementTypeName(Locale locale) {
        if (this._requirementCTDisplayRenderer == null) {
            String name = ResourceActionsUtil.getModelResource((Locale)locale, (String)this._className);
            if (name.startsWith("model.resource.")) {
                return this._className;
            }
            return name;
        }
        return this._requirementCTDisplayRenderer.getTypeName(locale);
    }
}

