/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal;

import com.liferay.change.tracking.internal.CTTableMapperHelper;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.spi.exception.CTEventException;
import com.liferay.change.tracking.spi.listener.CTEventListener;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CTServiceRegistry.class})
public class CTServiceRegistry {
    private static final Log _log = LogFactoryUtil.getLog(CTServiceRegistry.class);
    private BundleContext _bundleContext;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private volatile ServiceTrackerList<CTEventListener, CTEventListener> _serviceTrackerList;
    private volatile ServiceTrackerMap<Long, CTService<?>> _serviceTrackerMap;

    public CTService<?> getCTService(long classNameId) {
        ServiceTrackerMap<Long, CTService<?>> serviceTrackerMap = this._getServiceTrackerMap();
        return (CTService)serviceTrackerMap.getService((Object)classNameId);
    }

    public Collection<CTTableMapperHelper> getCTTableMapperHelpers() {
        HashMap<String, CTTableMapperHelper> ctMappingTableHelpers = new HashMap<String, CTTableMapperHelper>();
        ServiceTrackerMap<Long, CTService<?>> serviceTrackerMap = this._getServiceTrackerMap();
        for (CTService ctService : serviceTrackerMap.values()) {
            CTPersistence ctPersistence = ctService.getCTPersistence();
            List mappingTableNames = ctPersistence.getMappingTableNames();
            if (mappingTableNames.isEmpty()) continue;
            Set primaryKeyNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.PK);
            if (primaryKeyNames.size() != 1) {
                throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{primaryKeyNames=", primaryKeyNames, ", tableName=", ctPersistence.getTableName(), "}"}));
            }
            Iterator iterator = primaryKeyNames.iterator();
            String primaryKeyName = (String)iterator.next();
            for (String mappingTableName : mappingTableNames) {
                ctMappingTableHelpers.compute(mappingTableName, (key, ctTableMapperHelper) -> {
                    if (ctTableMapperHelper == null) {
                        return new CTTableMapperHelper(ctService, mappingTableName, primaryKeyName);
                    }
                    ctTableMapperHelper.setRightColumnName(primaryKeyName);
                    return ctTableMapperHelper;
                });
            }
        }
        return ctMappingTableHelpers.values();
    }

    public void onAfterCopy(CTCollection sourceCTCollection, CTCollection targetCTCollection) {
        for (CTEventListener ctEventListener : this._getServiceTrackerList()) {
            try {
                ctEventListener.onAfterCopy(sourceCTCollection.getCtCollectionId(), targetCTCollection.getCtCollectionId());
            }
            catch (CTEventException ctEventException) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"On after copy callback failure for change tracking ", "collection ", sourceCTCollection, " by ", ctEventListener}), (Throwable)ctEventException);
            }
        }
    }

    public void onAfterPublish(long ctCollectionId) {
        for (CTEventListener ctEventListener : this._getServiceTrackerList()) {
            try {
                ctEventListener.onAfterPublish(ctCollectionId);
            }
            catch (CTEventException ctEventException) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"On after publish callback failure for change ", "tracking collection ", ctCollectionId, " by ", ctEventListener}), (Throwable)ctEventException);
            }
        }
    }

    public void onBeforePublish(long ctCollectionId) {
        for (CTEventListener ctEventListener : this._getServiceTrackerList()) {
            try {
                ctEventListener.onBeforePublish(ctCollectionId);
            }
            catch (CTEventException ctEventException) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"On before publish callback failure for change ", "tracking collection ", ctCollectionId, " by ", ctEventListener}), (Throwable)ctEventException);
            }
        }
    }

    public void onBeforeRemove(long ctCollectionId) {
        for (CTEventListener ctEventListener : this._getServiceTrackerList()) {
            try {
                ctEventListener.onBeforeRemove(ctCollectionId);
            }
            catch (CTEventException ctEventException) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"On before remove callback failure for change ", "tracking collection ", ctCollectionId, " by ", ctEventListener}), (Throwable)ctEventException);
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate() {
        ServiceTrackerMap<Long, CTService<?>> serviceTrackerMap;
        ServiceTrackerList<CTEventListener, CTEventListener> serviceTrackerList = this._serviceTrackerList;
        if (serviceTrackerList != null) {
            serviceTrackerList.close();
        }
        if ((serviceTrackerMap = this._serviceTrackerMap) != null) {
            serviceTrackerMap.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceTrackerList<CTEventListener, CTEventListener> _getServiceTrackerList() {
        ServiceTrackerList<CTEventListener, CTEventListener> serviceTrackerList = this._serviceTrackerList;
        if (serviceTrackerList != null) {
            return serviceTrackerList;
        }
        CTServiceRegistry cTServiceRegistry = this;
        synchronized (cTServiceRegistry) {
            if (this._serviceTrackerList == null) {
                this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)this._bundleContext, CTEventListener.class);
            }
            return this._serviceTrackerList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceTrackerMap<Long, CTService<?>> _getServiceTrackerMap() {
        ServiceTrackerMap<Long, CTService<?>> serviceTrackerMap = this._serviceTrackerMap;
        if (serviceTrackerMap != null) {
            return serviceTrackerMap;
        }
        CTServiceRegistry cTServiceRegistry = this;
        synchronized (cTServiceRegistry) {
            if (this._serviceTrackerMap == null) {
                this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, CTService.class, null, (serviceReference, emitter) -> {
                    CTService ctService = (CTService)this._bundleContext.getService(serviceReference);
                    emitter.emit((Object)this._classNameLocalService.getClassNameId(ctService.getModelClass()));
                });
            }
            return this._serviceTrackerMap;
        }
    }
}

