/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal;

import com.liferay.change.tracking.internal.CTRowUtil;
import com.liferay.change.tracking.internal.CTServiceRegistry;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.portal.change.tracking.sql.CTSQLContextFactory;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CTSQLContextFactory.class})
public class CTSQLContextFactoryImpl
implements CTSQLContextFactory {
    private static final Log _log = LogFactoryUtil.getLog(CTSQLContextFactoryImpl.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTServiceRegistry _ctServiceRegistry;

    public CTSQLContextFactory.CTSQLContext createCTSQLContext(long ctCollectionId, String tableName, String primaryColumnName, Class<?> clazz) {
        long classNameId = this._classNameLocalService.getClassNameId(clazz);
        List ctEntries = this._ctEntryLocalService.getCTEntries(ctCollectionId, classNameId);
        if (ctEntries.isEmpty()) {
            return new CTSQLContextImpl(Collections.emptyList(), false, false);
        }
        ArrayList<Long> excludePKs = new ArrayList<Long>();
        boolean added = false;
        boolean modified = false;
        for (CTEntry ctEntry : ctEntries) {
            int changeType = ctEntry.getChangeType();
            if (changeType == 0) {
                added = true;
                continue;
            }
            excludePKs.add(ctEntry.getModelClassPK());
            if (changeType != 2) continue;
            modified = true;
        }
        CTService<?> ctService = this._ctServiceRegistry.getCTService(classNameId);
        if (ctService == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No CTService found for classNameId " + classNameId));
            }
            return new CTSQLContextImpl(excludePKs, added, modified);
        }
        CTPersistence ctPersistence = ctService.getCTPersistence();
        List uniqueIndexColumnNames = ctPersistence.getUniqueIndexColumnNames();
        if (uniqueIndexColumnNames.isEmpty()) {
            return new CTSQLContextImpl(excludePKs, added, modified);
        }
        Session session = ctPersistence.getCurrentSession();
        org.hibernate.Session wrappedSession = (org.hibernate.Session)session.getWrappedSession();
        boolean[] modifiedMarker = new boolean[1];
        wrappedSession.doWork(connection -> {
            for (String[] columnNames : uniqueIndexColumnNames) {
                String findConflictsSQL = CTRowUtil.getConstraintConflictsSQL(tableName, primaryColumnName, columnNames, ctCollectionId, 0L, false);
                PreparedStatement ps = connection.prepareStatement(findConflictsSQL);
                Throwable throwable = null;
                try {
                    ResultSet rs = ps.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        while (rs.next()) {
                            excludePKs.add(rs.getLong(1));
                            modifiedMarker[0] = true;
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (ps == null) continue;
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    ps.close();
                }
            }
        });
        return new CTSQLContextImpl(excludePKs, added, modified || modifiedMarker[0]);
    }

    private static class CTSQLContextImpl
    implements CTSQLContextFactory.CTSQLContext {
        private final boolean _added;
        private final List<Long> _excludePKs;
        private final boolean _modified;

        public List<Long> getExcludePKs() {
            return this._excludePKs;
        }

        public boolean hasAdded() {
            return this._added;
        }

        public boolean hasModified() {
            return this._modified;
        }

        private CTSQLContextImpl(List<Long> excludePKs, boolean added, boolean modified) {
            this._excludePKs = excludePKs;
            this._added = added;
            this._modified = modified;
        }
    }
}

