/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.internal.background.task.CTPublishBackgroundTaskExecutor;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTPreferences;
import com.liferay.change.tracking.model.CTProcess;
import com.liferay.change.tracking.service.base.CTProcessLocalServiceBaseImpl;
import com.liferay.change.tracking.service.persistence.CTPreferencesPersistence;
import com.liferay.petra.lang.SafeClosable;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.change.tracking.model.CTProcess"}, service={AopService.class})
public class CTProcessLocalServiceImpl
extends CTProcessLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CTProcessLocalServiceImpl.class);
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference
    private CTPreferencesPersistence _ctPreferencesPersistence;

    public CTProcess addCTProcess(long userId, long ctCollectionId) throws PortalException {
        CTCollection ctCollection = this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        if (ctCollection.getStatus() == 0) {
            throw new IllegalStateException("Change tracking collection is already published " + ctCollection);
        }
        ctCollection.setStatus(1);
        ctCollection = (CTCollection)this.ctCollectionPersistence.update((BaseModel)ctCollection);
        for (CTPreferences ctPreferences : this._ctPreferencesPersistence.findByCollectionId(ctCollectionId)) {
            ctPreferences.setCtCollectionId(0L);
            this._ctPreferencesPersistence.update((BaseModel)ctPreferences);
        }
        for (CTPreferences ctPreferences : this._ctPreferencesPersistence.findByPreviousCollectionId(ctCollectionId)) {
            ctPreferences.setPreviousCtCollectionId(0L);
            this._ctPreferencesPersistence.update((BaseModel)ctPreferences);
        }
        long ctProcessId = this.counterLocalService.increment(CTProcess.class.getName());
        CTProcess ctProcess = this.ctProcessPersistence.create(ctProcessId);
        ctProcess.setCompanyId(ctCollection.getCompanyId());
        ctProcess.setUserId(userId);
        ctProcess.setCreateDate(new Date());
        ctProcess.setCtCollectionId(ctCollectionId);
        Company company = this.companyLocalService.getCompany(ctCollection.getCompanyId());
        HashMap taskContextMap = HashMapBuilder.put((Object)"ctCollectionId", (Object)ctCollectionId).put((Object)"ctProcessId", (Object)ctProcessId).build();
        try (SafeClosable safeClosable = CTCollectionThreadLocal.setCTCollectionId((long)0L);){
            BackgroundTask backgroundTask = this._backgroundTaskLocalService.addBackgroundTask(userId, company.getGroupId(), String.valueOf(ctCollectionId), null, CTPublishBackgroundTaskExecutor.class, (Map)taskContextMap, null);
            ctProcess.setBackgroundTaskId(backgroundTask.getBackgroundTaskId());
        }
        return (CTProcess)this.ctProcessPersistence.update((BaseModel)ctProcess);
    }

    @Override
    public CTProcess deleteCTProcess(CTProcess ctProcess) {
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.fetchBackgroundTask(ctProcess.getBackgroundTaskId());
        if (backgroundTask != null) {
            try {
                this._backgroundTaskLocalService.deleteBackgroundTask(backgroundTask);
            }
            catch (PortalException portalException) {
                _log.error((Object)portalException, (Throwable)portalException);
            }
        }
        return (CTProcess)this.ctProcessPersistence.remove((BaseModel)ctProcess);
    }

    public CTProcess fetchLatestCTProcess(long companyId) {
        return this.ctProcessPersistence.fetchByCompanyId_First(companyId, null);
    }

    public List<CTProcess> getCTProcesses(long ctCollectionId) {
        return this.ctProcessPersistence.findByCollectionId(ctCollectionId);
    }
}

