/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.resolver;

import com.liferay.change.tracking.resolver.helper.ConstraintResolverHelper;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.lang.SafeClosable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import java.io.Serializable;

public class ConstraintResolverHelperImpl<T extends CTModel<T>>
implements ConstraintResolverHelper<T> {
    private final CTService<T> _ctService;
    private long _sourcePrimaryKey;
    private final long _targetCTCollectionId;
    private long _targetPrimaryKey;

    public ConstraintResolverHelperImpl(CTService<T> ctService, long targetCTCollectionId) {
        this._ctService = ctService;
        this._targetCTCollectionId = targetCTCollectionId;
    }

    public <R, E extends Throwable> R getInTarget(UnsafeSupplier<R, E> unsafeSupplier) throws E {
        try (SafeClosable safeClosable = CTCollectionThreadLocal.setCTCollectionId((long)this._targetCTCollectionId);){
            Object object = unsafeSupplier.get();
            return (R)object;
        }
    }

    public T getSourceCTModel() {
        return (T)((CTModel)this._ctService.updateWithUnsafeFunction(ctPersistence -> (CTModel)ctPersistence.fetchByPrimaryKey((Serializable)Long.valueOf(this._sourcePrimaryKey))));
    }

    public T getTargetCTModel() {
        try (SafeClosable safeClosable = CTCollectionThreadLocal.setCTCollectionId((long)this._targetCTCollectionId);){
            CTModel cTModel = (CTModel)this._ctService.updateWithUnsafeFunction(ctPersistence -> (CTModel)ctPersistence.fetchByPrimaryKey((Serializable)Long.valueOf(this._targetPrimaryKey)));
            return (T)cTModel;
        }
    }

    public void setPrimaryKeys(long sourcePrimaryKey, long targetPrimaryKey) {
        this._sourcePrimaryKey = sourcePrimaryKey;
        this._targetPrimaryKey = targetPrimaryKey;
    }
}

