/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.reference.closure;

import com.liferay.change.tracking.internal.reference.closure.Edge;
import com.liferay.change.tracking.internal.reference.closure.Node;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class GraphUtil {
    public static Map<Node, Collection<Node>> getNodeMap(Set<Node> nodes, Map<Node, Collection<Edge>> edgeMap) {
        LinkedList<Edge> backtraceEdges = new LinkedList<Edge>();
        HashSet<Edge> cyclingEdges = new HashSet<Edge>();
        HashSet<Edge> resolvedEdges = new HashSet<Edge>();
        for (Collection<Edge> edges : edgeMap.values()) {
            for (Edge edge : edges) {
                GraphUtil._filterCyclingEdges(edge, edgeMap, backtraceEdges, cyclingEdges, resolvedEdges);
            }
        }
        HashMap<Node, Collection<Node>> nodeMap = new HashMap<Node, Collection<Node>>();
        for (Edge edge : resolvedEdges) {
            Collection children = nodeMap.computeIfAbsent(edge.getFromNode(), node -> new HashSet());
            Node toNode = edge.getToNode();
            children.add(toNode);
            nodes.remove(toNode);
        }
        nodeMap.put(Node.ROOT_NODE, nodes);
        return nodeMap;
    }

    private static void _filterCyclingEdges(Edge edge, Map<Node, Collection<Edge>> edgeMap, Deque<Edge> backtraceEdges, Set<Edge> cyclingEdges, Set<Edge> resolvedEdges) {
        if (backtraceEdges.contains(edge)) {
            cyclingEdges.add(edge);
            return;
        }
        if (resolvedEdges.contains(edge) || cyclingEdges.contains(edge)) {
            return;
        }
        Collection<Edge> nextEdges = edgeMap.get(edge.getToNode());
        if (nextEdges == null) {
            resolvedEdges.add(edge);
            return;
        }
        backtraceEdges.push(edge);
        for (Edge nextEdge : nextEdges) {
            GraphUtil._filterCyclingEdges(nextEdge, edgeMap, backtraceEdges, cyclingEdges, resolvedEdges);
        }
        backtraceEdges.pop();
        if (!cyclingEdges.contains(edge)) {
            resolvedEdges.add(edge);
        }
    }
}

