/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.reference.closure;

import com.liferay.change.tracking.internal.reference.closure.Node;
import com.liferay.change.tracking.reference.closure.CTClosure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CTClosureImpl
implements CTClosure {
    private final Map<Node, Collection<Node>> _closureMap;
    private final long _ctCollectionId;

    public CTClosureImpl(long ctCollectionId, Map<Node, Collection<Node>> closureMap) {
        this._ctCollectionId = ctCollectionId;
        this._closureMap = closureMap;
    }

    public Map<Long, List<Long>> getChildPKsMap(long classNameId, long classPK) {
        Collection<Node> nodes = this._closureMap.get(new Node(classNameId, classPK));
        if (nodes == null) {
            return Collections.emptyMap();
        }
        HashSet<Node> excludedNodes = new HashSet<Node>();
        LinkedList<Node> queue = new LinkedList<Node>(nodes);
        while (queue.size() > 0) {
            Collection<Node> childNodes = this._closureMap.get(queue.poll());
            if (childNodes == null) continue;
            for (Node childNode : childNodes) {
                if (!excludedNodes.add(childNode)) continue;
                queue.add(childNode);
            }
        }
        return this._getPrimaryKeysMap(nodes, excludedNodes);
    }

    public long getCTCollectionId() {
        return this._ctCollectionId;
    }

    public Map<Long, List<Long>> getRootPKsMap() {
        return this._getPrimaryKeysMap(this._closureMap.get(Node.ROOT_NODE), Collections.emptySet());
    }

    private Map<Long, List<Long>> _getPrimaryKeysMap(Collection<Node> nodes, Set<Node> excludedNodes) {
        HashMap<Long, List<Long>> primaryKeysMap = new HashMap<Long, List<Long>>();
        for (Node node : nodes) {
            if (excludedNodes.contains(node)) continue;
            List primaryKeys = primaryKeysMap.computeIfAbsent(node.getClassNameId(), key -> new ArrayList());
            primaryKeys.add(node.getPrimaryKey());
        }
        return primaryKeysMap;
    }
}

