/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.reference.builder;

import com.liferay.change.tracking.internal.reference.TableJoinHolder;
import com.liferay.change.tracking.internal.reference.TableReferenceInfo;
import com.liferay.change.tracking.internal.reference.TableUtil;
import com.liferay.change.tracking.reference.TableReferenceDefinition;
import com.liferay.change.tracking.reference.builder.TableReferenceInfoBuilder;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.ast.ASTNode;
import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.spi.expression.DefaultPredicate;
import com.liferay.petra.sql.dsl.spi.expression.Operand;
import com.liferay.petra.sql.dsl.spi.query.From;
import com.liferay.petra.sql.dsl.spi.query.Join;
import com.liferay.petra.sql.dsl.spi.query.JoinType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class TableReferenceInfoBuilderImpl<T extends Table<T>>
implements TableReferenceInfoBuilder<T> {
    private static final Log _log = LogFactoryUtil.getLog(TableReferenceInfoBuilderImpl.class);
    private static final Consumer<String> _emptyStringConsumer = string -> {};
    private static final FromStep _validationFromStep = new ValidationFromStep();
    private static final Set<Operand> _validOperands = new HashSet<Operand>(){
        {
            this.add(Operand.AND);
            this.add(Operand.EQUAL);
            this.add(Operand.LIKE);
        }
    };
    private final Map<Table<?>, List<TableJoinHolder>> _childTableJoinHoldersMap = new HashMap();
    private final Set<Column<?, ?>> _definedColumns = new HashSet();
    private final Map<Table<?>, List<TableJoinHolder>> _parentTableJoinHoldersMap = new HashMap();
    private final Column<T, Long> _primaryKeyColumn;
    private final TableReferenceDefinition<T> _tableReferenceDefinition;

    public TableReferenceInfoBuilderImpl(TableReferenceDefinition<T> tableReferenceDefinition, Column<T, Long> primaryKeyColumn) {
        this._tableReferenceDefinition = tableReferenceDefinition;
        this._primaryKeyColumn = primaryKeyColumn;
    }

    public TableReferenceInfo<T> build() {
        Table table = this._tableReferenceDefinition.getTable();
        ArrayList<Column> undefinedColumns = null;
        for (Column column : table.getColumns()) {
            if (Objects.equals(column.getName(), "mvccVersion") || column.isPrimaryKey() || this._definedColumns.contains(column)) continue;
            if (undefinedColumns == null) {
                undefinedColumns = new ArrayList<Column>();
            }
            undefinedColumns.add(column);
        }
        if (undefinedColumns != null) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{this._tableReferenceDefinition, " did not define columns ", undefinedColumns}));
            return null;
        }
        return new TableReferenceInfo<T>(this._tableReferenceDefinition, this._parentTableJoinHoldersMap, this._childTableJoinHoldersMap);
    }

    public TableReferenceInfoBuilder<T> nonreferenceColumn(Column<T, ?> column) {
        if (this._tableReferenceDefinition.getTable() != column.getTable()) {
            throw new IllegalArgumentException("Invalid table for column " + column);
        }
        this._definedColumns.add(column);
        return this;
    }

    public TableReferenceInfoBuilder<T> referenceInnerJoin(Function<FromStep, JoinStep> joinFunction) {
        JoinStep joinStep = joinFunction.apply(_validationFromStep);
        if (!(joinStep instanceof Join)) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Missing join in \"", joinStep, "\""}));
        }
        JoinStepASTNodeListener joinStepASTNodeListener = new JoinStepASTNodeListener();
        joinStep.toSQL(_emptyStringConsumer, (ASTNodeListener)joinStepASTNodeListener);
        if (joinStepASTNodeListener._fromTable == null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Join function must use provided from step for join step ", "\"", joinStep, "\""}));
        }
        if (!joinStepASTNodeListener._hasRequiredTable) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Required table \"", this._tableReferenceDefinition.getTable(), "\" is unused in join step \"", joinStep, "\""}));
        }
        if (joinStepASTNodeListener._invalidJoin != null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Invalid join for join step \"", joinStep, "\", ensure table alias is used for self joins"}));
        }
        if (joinStepASTNodeListener._invalidJoinType != null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Invalid join type \"", joinStepASTNodeListener._invalidJoinType, "\" for join step \"", joinStep, "\""}));
        }
        if (joinStepASTNodeListener._invalidOperand != null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Invalid predicate operand \"", joinStepASTNodeListener._invalidOperand, "\" for join step \"", joinStep, "\""}));
        }
        if (!joinStepASTNodeListener._tables.containsAll(joinStepASTNodeListener._columnTables)) {
            ArrayList<Table> columnTables = new ArrayList<Table>(joinStepASTNodeListener._columnTables);
            Comparator<Table> comparator = Comparator.comparing(Table::getName);
            columnTables.sort(comparator);
            ArrayList<Table> joinTables = new ArrayList<Table>(joinStepASTNodeListener._tables);
            joinTables.sort(comparator);
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Predicate column tables ", columnTables, " do not match join tables ", joinTables, " for join step \"", joinStep, "\""}));
        }
        Column fromPKColumn = TableUtil.getPrimaryKeyColumn(joinStepASTNodeListener._fromTable);
        if (fromPKColumn == null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"No long type primary key column found for table \"", joinStepASTNodeListener._fromTable, "\" for join step \"", joinStep, "\""}));
        }
        Column<T, Long> joinPKColumn = joinStepASTNodeListener._aliasPrimaryKeyColumn;
        if (joinPKColumn == null) {
            joinPKColumn = this._primaryKeyColumn;
        }
        if (fromPKColumn == joinPKColumn) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"From table should be a different table than \"", this._tableReferenceDefinition.getTable(), "\" for join step \"", joinStep, "\""}));
        }
        List tableJoinHolders = null;
        tableJoinHolders = joinStepASTNodeListener._parentJoinFunction ? this._parentTableJoinHoldersMap.computeIfAbsent(joinStepASTNodeListener._fromTable, fromTable -> new ArrayList()) : this._childTableJoinHoldersMap.computeIfAbsent(joinStepASTNodeListener._fromTable, fromTable -> new ArrayList());
        tableJoinHolders.add(new TableJoinHolder(fromPKColumn, joinPKColumn, joinFunction));
        return this;
    }

    private class JoinStepASTNodeListener
    implements ASTNodeListener {
        private Column<T, Long> _aliasPrimaryKeyColumn;
        private Set<Table<?>> _columnTables = Collections.newSetFromMap(new IdentityHashMap());
        private Table<?> _fromTable;
        private boolean _hasRequiredTable;
        private Join _invalidJoin;
        private JoinType _invalidJoinType;
        private Operand _invalidOperand;
        private boolean _parentJoinFunction;
        private Set<Table<?>> _tables = Collections.newSetFromMap(new IdentityHashMap());

        public void process(ASTNode astNode) {
            if (astNode instanceof Column) {
                Column column = (Column)astNode;
                this._columnTables.add(column.getTable());
                TableReferenceInfoBuilderImpl.this._definedColumns.add(column);
                if (!this._hasRequiredTable && Objects.equals(TableReferenceInfoBuilderImpl.this._tableReferenceDefinition.getTable(), column.getTable())) {
                    this._hasRequiredTable = true;
                }
                if (column.isPrimaryKey() && this._fromTable == column.getTable()) {
                    this._parentJoinFunction = true;
                }
            } else if (astNode instanceof DefaultPredicate) {
                DefaultPredicate defaultPredicate = (DefaultPredicate)astNode;
                Operand operand = defaultPredicate.getOperand();
                if (!_validOperands.contains(operand) && this._invalidOperand == null) {
                    this._invalidOperand = operand;
                }
            } else if (astNode instanceof From) {
                From from = (From)astNode;
                if (from.getChild() == _validationFromStep) {
                    this._fromTable = from.getTable();
                    this._tables.add(from.getTable());
                }
            } else if (astNode instanceof Join) {
                Table table;
                Join join = (Join)astNode;
                JoinType joinType = join.getJoinType();
                if (joinType != JoinType.INNER) {
                    this._invalidJoinType = joinType;
                }
                if ((table = join.getTable()).equals(this._fromTable) && Objects.equals(this._fromTable.getName(), table.getName())) {
                    this._invalidJoin = join;
                }
                if (table.equals(TableReferenceInfoBuilderImpl.this._primaryKeyColumn.getTable())) {
                    Table primaryKeyTable = TableReferenceInfoBuilderImpl.this._primaryKeyColumn.getTable();
                    if (!Objects.equals(table.getName(), primaryKeyTable.getName())) {
                        this._aliasPrimaryKeyColumn = TableUtil.getPrimaryKeyColumn(table);
                    }
                }
                this._tables.add(table);
            }
        }

        private JoinStepASTNodeListener() {
        }
    }

    private static class ValidationFromStep
    implements FromStep {
        private ValidationFromStep() {
        }

        public Table<?> as(String name) {
            throw new UnsupportedOperationException();
        }

        public JoinStep from(Table<?> table) {
            return new From((FromStep)this, table);
        }

        public void toSQL(Consumer<String> consumer, ASTNodeListener astNodeListener) {
            consumer.accept("...");
        }

        public DSLQuery union(DSLQuery dslQuery) {
            throw new UnsupportedOperationException();
        }

        public DSLQuery unionAll(DSLQuery dslQuery) {
            throw new UnsupportedOperationException();
        }
    }
}

