/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.reference;

import com.liferay.change.tracking.internal.reference.TableJoinHolder;
import com.liferay.change.tracking.internal.reference.TableReferenceInfo;
import com.liferay.change.tracking.internal.reference.TableUtil;
import com.liferay.change.tracking.internal.reference.builder.TableReferenceInfoBuilderImpl;
import com.liferay.change.tracking.reference.TableReferenceDefinition;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={TableReferenceDefinitionManager.class})
public class TableReferenceDefinitionManager {
    private static final Log _log = LogFactoryUtil.getLog(TableReferenceDefinitionManager.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private volatile Map<Long, TableReferenceInfo<?>> _combinedTableReferenceInfos;
    private ServiceTracker<?, ?> _serviceTracker;
    private final Map<Table<?>, TableReferenceInfo<?>> _tableReferenceInfos = new ConcurrentHashMap();

    public long getClassNameId(Table<?> table) {
        TableReferenceInfo<?> tableReferenceInfo = this._tableReferenceInfos.get(table);
        if (tableReferenceInfo == null) {
            throw new IllegalStateException("No table reference definition for " + table);
        }
        return this._getClassNameId(tableReferenceInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, TableReferenceInfo<?>> getCombinedTableReferenceInfos() {
        Map<Long, TableReferenceInfo<?>> combinedTableReferenceInfos = this._combinedTableReferenceInfos;
        if (combinedTableReferenceInfos != null) {
            return combinedTableReferenceInfos;
        }
        TableReferenceDefinitionManager tableReferenceDefinitionManager = this;
        synchronized (tableReferenceDefinitionManager) {
            combinedTableReferenceInfos = new HashMap();
            for (TableReferenceInfo<?> tableReferenceInfo : this._tableReferenceInfos.values()) {
                combinedTableReferenceInfos.put(this._getClassNameId(tableReferenceInfo), this._getCombinedTableReferenceInfo(tableReferenceInfo));
            }
            combinedTableReferenceInfos = Collections.unmodifiableMap(combinedTableReferenceInfos);
            this._combinedTableReferenceInfos = combinedTableReferenceInfos;
        }
        return combinedTableReferenceInfos;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTracker = new ServiceTracker(bundleContext, TableReferenceDefinition.class, (ServiceTrackerCustomizer)new TableReferenceDefinitionServiceTrackerCustomizer(bundleContext));
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private Map<Table<?>, List<TableJoinHolder>> _copyTableJoinHoldersMap(Map<Table<?>, List<TableJoinHolder>> tableJoinHoldersMap) {
        HashMap copy = new HashMap();
        for (Map.Entry<Table<?>, List<TableJoinHolder>> entry : tableJoinHoldersMap.entrySet()) {
            copy.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return copy;
    }

    private long _getClassNameId(TableReferenceInfo<?> tableReferenceInfo) {
        TableReferenceDefinition<?> tableReferenceDefinition = tableReferenceInfo.getTableReferenceDefinition();
        BasePersistence basePersistence = tableReferenceDefinition.getBasePersistence();
        return this._classNameLocalService.getClassNameId(basePersistence.getModelClass());
    }

    private <T extends Table<T>> TableReferenceInfo<T> _getCombinedTableReferenceInfo(TableReferenceInfo<T> tableReferenceInfo) {
        Map<Table<?>, List<TableJoinHolder>> combinedParentTableJoinHoldersMap = this._copyTableJoinHoldersMap(tableReferenceInfo.getParentTableJoinHoldersMap());
        Map<Table<?>, List<TableJoinHolder>> combinedChildTableJoinHoldersMap = this._copyTableJoinHoldersMap(tableReferenceInfo.getChildTableJoinHoldersMap());
        TableReferenceDefinition<T> tableReferenceDefinition = tableReferenceInfo.getTableReferenceDefinition();
        Table table = tableReferenceDefinition.getTable();
        for (TableReferenceInfo<?> currentTableReferenceInfo : this._tableReferenceInfos.values()) {
            Map<Table<?>, List<TableJoinHolder>> currentChildTableJoinHoldersMap;
            List<TableJoinHolder> currentChildTableJoinHolders;
            if (tableReferenceInfo == currentTableReferenceInfo) continue;
            TableReferenceDefinition<?> currentTableReferenceDefinition = currentTableReferenceInfo.getTableReferenceDefinition();
            Map<Table<?>, List<TableJoinHolder>> currentParentTableJoinHoldersMap = currentTableReferenceInfo.getParentTableJoinHoldersMap();
            List<TableJoinHolder> currentParentTableJoinHolders = currentParentTableJoinHoldersMap.get(table);
            if (currentParentTableJoinHolders != null) {
                List combinedChildTableJoinHolders = combinedChildTableJoinHoldersMap.computeIfAbsent(currentTableReferenceDefinition.getTable(), key -> new ArrayList());
                for (TableJoinHolder currentParentTableJoinHolder : currentParentTableJoinHolders) {
                    combinedChildTableJoinHolders.add(TableJoinHolder.reverse(currentParentTableJoinHolder));
                }
            }
            if ((currentChildTableJoinHolders = (currentChildTableJoinHoldersMap = currentTableReferenceInfo.getChildTableJoinHoldersMap()).get(table)) == null) continue;
            List combinedParentTableJoinHolders = combinedParentTableJoinHoldersMap.computeIfAbsent(currentTableReferenceDefinition.getTable(), key -> new ArrayList());
            for (TableJoinHolder currentChildTableJoinHolder : currentChildTableJoinHolders) {
                combinedParentTableJoinHolders.add(TableJoinHolder.reverse(currentChildTableJoinHolder));
            }
        }
        return new TableReferenceInfo<T>(tableReferenceDefinition, combinedParentTableJoinHoldersMap, combinedChildTableJoinHoldersMap);
    }

    private class TableReferenceDefinitionServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<TableReferenceDefinition, TableReferenceInfo<?>> {
        private final BundleContext _bundleContext;

        public TableReferenceInfo<?> addingService(ServiceReference<TableReferenceDefinition> serviceReference) {
            TableReferenceDefinition tableReferenceDefinition = (TableReferenceDefinition)this._bundleContext.getService(serviceReference);
            return this._createTableReferenceContext(tableReferenceDefinition);
        }

        public void modifiedService(ServiceReference<TableReferenceDefinition> serviceReference, TableReferenceInfo<?> tableReferenceInfo) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<TableReferenceDefinition> serviceReference, TableReferenceInfo<?> tableReferenceInfo) {
            TableReferenceDefinitionManager tableReferenceDefinitionManager = TableReferenceDefinitionManager.this;
            synchronized (tableReferenceDefinitionManager) {
                TableReferenceDefinition<?> tableReferenceDefinition = tableReferenceInfo.getTableReferenceDefinition();
                TableReferenceDefinitionManager.this._tableReferenceInfos.remove(tableReferenceDefinition.getTable());
                TableReferenceDefinitionManager.this._combinedTableReferenceInfos = null;
            }
            this._bundleContext.ungetService(serviceReference);
        }

        private TableReferenceDefinitionServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T extends Table<T>> TableReferenceInfo<?> _createTableReferenceContext(TableReferenceDefinition<T> tableReferenceDefinition) {
            Column primaryKeyColumn = TableUtil.getPrimaryKeyColumn(tableReferenceDefinition.getTable());
            if (primaryKeyColumn == null) {
                _log.error((Object)("No long type primary key column found for " + tableReferenceDefinition));
                return null;
            }
            TableReferenceInfoBuilderImpl<T> tableReferenceInfoBuilderImpl = new TableReferenceInfoBuilderImpl<T>(tableReferenceDefinition, primaryKeyColumn);
            tableReferenceDefinition.defineTableReferences(tableReferenceInfoBuilderImpl);
            TableReferenceInfo<T> tableReferenceInfo = tableReferenceInfoBuilderImpl.build();
            if (tableReferenceInfo != null) {
                TableReferenceDefinitionManager tableReferenceDefinitionManager = TableReferenceDefinitionManager.this;
                synchronized (tableReferenceDefinitionManager) {
                    TableReferenceDefinitionManager.this._tableReferenceInfos.put(tableReferenceDefinition.getTable(), tableReferenceInfo);
                    TableReferenceDefinitionManager.this._combinedTableReferenceInfos = null;
                }
            }
            return tableReferenceInfo;
        }
    }
}

