/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.conflict;

import com.liferay.change.tracking.conflict.ConflictInfo;
import com.liferay.change.tracking.internal.CTRowUtil;
import com.liferay.change.tracking.internal.conflict.ConstraintResolverConflictInfo;
import com.liferay.change.tracking.internal.conflict.DefaultConstraintConflictInfo;
import com.liferay.change.tracking.internal.conflict.ModificationConflictInfo;
import com.liferay.change.tracking.internal.resolver.ConstraintResolverHelperImpl;
import com.liferay.change.tracking.internal.resolver.ConstraintResolverKey;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.resolver.ConstraintResolver;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class CTConflictChecker<T extends CTModel<T>> {
    private final CTEntryLocalService _ctEntryLocalService;
    private final CTService<T> _ctService;
    private final Set<Long> _ignorablePrimaryKeys = new HashSet<Long>();
    private final long _modelClassNameId;
    private Map<Serializable, CTEntry> _modificationCTEntries;
    private final ServiceTrackerMap<ConstraintResolverKey, ConstraintResolver> _serviceTrackerMap;
    private final long _sourceCTCollectionId;
    private final long _targetCTCollectionId;

    public CTConflictChecker(CTEntryLocalService ctEntryLocalService, CTService<T> ctService, long modelClassNameId, ServiceTrackerMap<ConstraintResolverKey, ConstraintResolver> serviceTrackerMap, long sourceCTCollectionId, long targetCTCollectionId) {
        this._ctEntryLocalService = ctEntryLocalService;
        this._ctService = ctService;
        this._modelClassNameId = modelClassNameId;
        this._serviceTrackerMap = serviceTrackerMap;
        this._sourceCTCollectionId = sourceCTCollectionId;
        this._targetCTCollectionId = targetCTCollectionId;
    }

    public void addCTEntry(CTEntry ctEntry) {
        if (ctEntry.getChangeType() != 0) {
            this._ignorablePrimaryKeys.add(ctEntry.getModelClassPK());
        }
        if (ctEntry.getChangeType() == 2) {
            if (this._modificationCTEntries == null) {
                this._modificationCTEntries = new HashMap<Serializable, CTEntry>();
            }
            this._modificationCTEntries.put(Long.valueOf(ctEntry.getModelClassPK()), ctEntry);
        }
    }

    public List<ConflictInfo> check() throws PortalException {
        return (List)this._ctService.updateWithUnsafeFunction(this::_check);
    }

    private List<ConflictInfo> _check(CTPersistence<T> ctPersistence) throws PortalException {
        List uniqueIndexColumnNames;
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)ctPersistence.getDataSource());
        Set primaryKeyNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.PK);
        if (primaryKeyNames.size() != 1) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{ctPersistence=", ctPersistence, ", primaryKeyNames=", primaryKeyNames, "}"}));
        }
        Iterator iterator = primaryKeyNames.iterator();
        String primaryKeyName = (String)iterator.next();
        ArrayList<ConflictInfo> conflictInfos = new ArrayList<ConflictInfo>();
        if (this._modificationCTEntries != null) {
            this._checkModifications(connection, ctPersistence, conflictInfos, primaryKeyName);
        }
        if (!(uniqueIndexColumnNames = ctPersistence.getUniqueIndexColumnNames()).isEmpty()) {
            for (String[] columnNames : uniqueIndexColumnNames) {
                this._checkConstraint(connection, ctPersistence, conflictInfos, primaryKeyName, columnNames);
            }
        }
        return conflictInfos;
    }

    private void _checkConstraint(Connection connection, CTPersistence<T> ctPersistence, List<ConflictInfo> conflictInfos, String primaryKeyName, String[] columnNames) throws PortalException {
        String constraintConflictsSQL = CTRowUtil.getConstraintConflictsSQL(ctPersistence.getTableName(), primaryKeyName, columnNames, this._sourceCTCollectionId, this._targetCTCollectionId, true);
        List<Map.Entry<Long, Long>> nextPrimaryKeys = this._getConflictingPrimaryKeys(connection, constraintConflictsSQL);
        if (nextPrimaryKeys.isEmpty()) {
            return;
        }
        ConstraintResolver constraintResolver = (ConstraintResolver)this._serviceTrackerMap.getService((Object)new ConstraintResolverKey(ctPersistence.getModelClass(), columnNames));
        if (constraintResolver == null) {
            StringBundler sb = new StringBundler(2 * columnNames.length);
            for (String columnName : columnNames) {
                sb.append(columnName);
                sb.append(", ");
            }
            sb.setIndex(sb.index() - 1);
            String columnNamesString = sb.toString();
            for (Map.Entry<Long, Long> currentPrimaryKeys : nextPrimaryKeys) {
                conflictInfos.add(new DefaultConstraintConflictInfo(currentPrimaryKeys.getKey(), currentPrimaryKeys.getValue(), columnNamesString));
            }
            return;
        }
        ConstraintResolverHelperImpl<T> constraintResolverHelperImpl = new ConstraintResolverHelperImpl<T>(this._ctService, this._targetCTCollectionId);
        HashSet<Map.Entry<Long, Long>> attemptedPrimaryKeys = new HashSet<Map.Entry<Long, Long>>();
        HashSet<Map.Entry<Long, Long>> resolvedPrimaryKeys = new HashSet<Map.Entry<Long, Long>>(nextPrimaryKeys);
        while (!nextPrimaryKeys.isEmpty()) {
            Map.Entry<Long, Long> currentPrimaryKeys = nextPrimaryKeys.get(0);
            constraintResolverHelperImpl.setPrimaryKeys(currentPrimaryKeys.getKey(), currentPrimaryKeys.getValue());
            constraintResolver.resolveConflict(constraintResolverHelperImpl);
            Session session = ctPersistence.getCurrentSession();
            session.flush();
            session.clear();
            attemptedPrimaryKeys.add(currentPrimaryKeys);
            nextPrimaryKeys = this._getConflictingPrimaryKeys(connection, constraintConflictsSQL);
            resolvedPrimaryKeys.addAll(nextPrimaryKeys);
            nextPrimaryKeys.removeAll(attemptedPrimaryKeys);
        }
        List<Map.Entry<Long, Long>> unresolvedPrimaryKeys = this._getConflictingPrimaryKeys(connection, constraintConflictsSQL);
        resolvedPrimaryKeys.removeAll(unresolvedPrimaryKeys);
        for (Map.Entry entry : resolvedPrimaryKeys) {
            conflictInfos.add(new ConstraintResolverConflictInfo(constraintResolver, (Long)entry.getKey(), (Long)entry.getValue(), true));
        }
        if (unresolvedPrimaryKeys.isEmpty()) {
            return;
        }
        for (Map.Entry entry : unresolvedPrimaryKeys) {
            conflictInfos.add(new ConstraintResolverConflictInfo(constraintResolver, (Long)entry.getKey(), (Long)entry.getValue(), false));
        }
    }

    private void _checkModifications(Connection connection, CTPersistence<T> ctPersistence, List<ConflictInfo> conflictInfos, String primaryKeyName) {
        String selectSQL = StringBundler.concat((Object[])new Object[]{"select t1.", primaryKeyName, " from ", ctPersistence.getTableName(), " t1 inner join ", ctPersistence.getTableName(), " t2 on t1.", primaryKeyName, " = t2.", primaryKeyName, " and t1.ctCollectionId = ", this._sourceCTCollectionId, " and t2.ctCollectionId = ", this._targetCTCollectionId, " inner join CTEntry ctEntry on ctEntry.ctCollectionId = ", this._sourceCTCollectionId, " and ctEntry.modelClassNameId = ", this._modelClassNameId, " and ctEntry.modelClassPK = t2.", primaryKeyName, " and ctEntry.changeType = ", 2});
        List<Long> resolvedPrimaryKeys = this._getModifiedPrimaryKeys(connection, ctPersistence, CTColumnResolutionType.IGNORE, selectSQL);
        for (Long resolvedPrimaryKey : resolvedPrimaryKeys) {
            conflictInfos.add(new ModificationConflictInfo(resolvedPrimaryKey, true));
        }
        this._resolveModificationConflicts(connection, ctPersistence, primaryKeyName, resolvedPrimaryKeys);
        List<Long> unresolvedPrimaryKeys = this._getModifiedPrimaryKeys(connection, ctPersistence, CTColumnResolutionType.STRICT, selectSQL + " and ctEntry.modelMvccVersion != t2.mvccVersion");
        for (Long unresolvedPrimaryKey : unresolvedPrimaryKeys) {
            conflictInfos.add(new ModificationConflictInfo(unresolvedPrimaryKey, false));
        }
        this._updateModelMvccVersion(connection, primaryKeyName, ctPersistence.getTableName(), unresolvedPrimaryKeys);
    }

    /*
     * Exception decompiling
     */
    private List<Map.Entry<Long, Long>> _getConflictingPrimaryKeys(Connection connection, String constraintConflictsSQL) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Long> _getModifiedPrimaryKeys(Connection connection, CTPersistence<T> ctPersistence, CTColumnResolutionType ctColumnResolutionType, String sql) {
        Set conflictingColumnNames = ctPersistence.getCTColumnNames(ctColumnResolutionType);
        if (conflictingColumnNames.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap columnsMap = new HashMap(ctPersistence.getTableColumnsMap());
        Set columnNames = columnsMap.keySet();
        columnNames.retainAll(conflictingColumnNames);
        Collection columnTypes = columnsMap.values();
        if (ctColumnResolutionType != CTColumnResolutionType.STRICT || !columnTypes.contains(2004)) {
            StringBundler sb = new StringBundler(sql);
            sb.append(" where ");
            for (Map.Entry entry : columnsMap.entrySet()) {
                String conflictColumnName = (String)entry.getKey();
                if ((Integer)entry.getValue() == 2005) {
                    sb.append("CAST_CLOB_TEXT(t1.");
                    sb.append(conflictColumnName);
                    sb.append(") != CAST_CLOB_TEXT(t2.");
                    sb.append(conflictColumnName);
                    sb.append(")");
                } else {
                    sb.append("t1.");
                    sb.append(conflictColumnName);
                    sb.append(" != t2.");
                    sb.append(conflictColumnName);
                }
                sb.append(" or ");
            }
            sb.setIndex(sb.index() - 1);
            sql = sb.toString();
        }
        ArrayList<Long> primaryKeys = new ArrayList<Long>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(SQLTransformer.transform((String)sql));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long primaryKey = resultSet.getLong(1);
                primaryKeys.add(primaryKey);
            }
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
        return primaryKeys;
    }

    private void _resolveModificationConflicts(Connection connection, CTPersistence<T> ctPersistence, String primaryKeyName, List<Long> resolvedPrimaryKeys) {
        if (resolvedPrimaryKeys.isEmpty()) {
            return;
        }
        long tempCTCollectionId = -this._sourceCTCollectionId;
        StringBundler sb = new StringBundler(2 * resolvedPrimaryKeys.size() + 9);
        sb.append("update ");
        sb.append(ctPersistence.getTableName());
        sb.append(" set ctCollectionId = ");
        sb.append(tempCTCollectionId);
        sb.append(" where ctCollectionId = ");
        sb.append(this._sourceCTCollectionId);
        sb.append(" and ");
        sb.append(primaryKeyName);
        sb.append(" in (");
        for (Long l : resolvedPrimaryKeys) {
            sb.append((Object)l);
            sb.append(", ");
        }
        sb.setStringAt(")", sb.index() - 1);
        try {
            Throwable throwable = null;
            try (PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());){
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
        sb = new StringBundler("select ");
        Map tableColumnsMap = ctPersistence.getTableColumnsMap();
        Set set = ctPersistence.getCTColumnNames(CTColumnResolutionType.IGNORE);
        for (String name : tableColumnsMap.keySet()) {
            if (name.equals("ctCollectionId")) {
                sb.append(this._sourceCTCollectionId);
                sb.append(" as ");
            } else if (name.equals("mvccVersion")) {
                sb.append("(t1.mvccVersion + 1) ");
            } else if (set.contains(name)) {
                sb.append("t2.");
            } else {
                sb.append("t1.");
            }
            sb.append(name);
            sb.append(", ");
        }
        sb.setStringAt(" from ", sb.index() - 1);
        sb.append(ctPersistence.getTableName());
        sb.append(" t1, ");
        sb.append(ctPersistence.getTableName());
        sb.append(" t2 where t1.");
        sb.append(primaryKeyName);
        sb.append(" = t2.");
        sb.append(primaryKeyName);
        sb.append(" and t1.ctCollectionId = ");
        sb.append(tempCTCollectionId);
        sb.append(" and t2.ctCollectionId = ");
        sb.append(this._targetCTCollectionId);
        try {
            CTRowUtil.copyCTRows(ctPersistence, connection, sb.toString());
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"delete from ", ctPersistence.getTableName(), " where ctCollectionId = ", tempCTCollectionId}));){
            preparedStatement.executeUpdate();
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
    }

    private void _updateModelMvccVersion(Connection connection, String primaryKeyName, String tableName, List<Long> unresolvedPrimaryKeys) {
        StringBundler sb = new StringBundler(2 * unresolvedPrimaryKeys.size() + 18);
        sb.append("select t1.");
        sb.append(primaryKeyName);
        sb.append(", t1.mvccVersion from ");
        sb.append(tableName);
        sb.append(" t1 inner join CTEntry on t1.");
        sb.append(primaryKeyName);
        sb.append(" = CTEntry.modelClassPK and CTEntry.changeType = ");
        sb.append(2);
        sb.append(" and CTEntry.ctCollectionId = ");
        sb.append(this._sourceCTCollectionId);
        sb.append(" and CTEntry.modelClassNameId = ");
        sb.append(this._modelClassNameId);
        sb.append(" and t1.mvccVersion != CTEntry.modelMvccVersion");
        sb.append(" where t1.ctCollectionId = ");
        sb.append(this._targetCTCollectionId);
        if (!unresolvedPrimaryKeys.isEmpty()) {
            sb.append(" and t1.");
            sb.append(primaryKeyName);
            sb.append(" not in (");
            for (Long unresolvedPrimaryKey : unresolvedPrimaryKeys) {
                sb.append((Object)unresolvedPrimaryKey);
                sb.append(", ");
            }
            sb.setStringAt(")", sb.index() - 1);
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long pk = resultSet.getLong(1);
                long mvccVersion = resultSet.getLong(2);
                CTEntry ctEntry = this._modificationCTEntries.get(pk);
                ctEntry.setModifiedDate(ctEntry.getModifiedDate());
                ctEntry.setModelMvccVersion(mvccVersion);
                this._ctEntryLocalService.updateCTEntry(ctEntry);
            }
        }
        catch (SQLException sqlException) {
            throw new ORMException((Throwable)sqlException);
        }
    }
}

