/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.social;

import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.kernel.model.BaseSocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"jakarta.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksPortlet", "model.class.name=com.liferay.bookmarks.model.BookmarksFolder"}, service={SocialActivityInterpreter.class})
public class BookmarksFolderActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{BookmarksFolder.class.getName()};
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksFolder)")
    private ModelResourcePermission<BookmarksFolder> _bookmarksFolderModelResourcePermission;

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) {
        return "/bookmarks/find_folder?folderId=" + activity.getClassPK();
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        int activityType = activity.getType();
        if (activityType == 10007) {
            if (Validator.isNull((String)groupName)) {
                return "activity-bookmarks-folder-move-to-trash";
            }
            return "activity-bookmarks-folder-move-to-trash-in";
        }
        if (activityType == 10008) {
            if (Validator.isNull((String)groupName)) {
                return "activity-bookmarks-folder-restore-from-trash";
            }
            return "activity-bookmarks-folder-restore-from-trash-in";
        }
        return null;
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        return ModelResourcePermissionUtil.contains(this._bookmarksFolderModelResourcePermission, (PermissionChecker)permissionChecker, (long)activity.getGroupId(), (long)activity.getClassPK(), (String)actionId);
    }
}

