/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.exportimport.staged.model.repository;

import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.service.BookmarksEntryLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryHelper;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.bookmarks.model.BookmarksEntry"}, service={StagedModelRepository.class})
public class BookmarksEntryStagedModelRepository
implements StagedModelRepository<BookmarksEntry> {
    @Reference
    private BookmarksEntryLocalService _bookmarksEntryLocalService;
    @Reference
    private StagedModelRepositoryHelper _stagedModelRepositoryHelper;

    public BookmarksEntry addStagedModel(PortletDataContext portletDataContext, BookmarksEntry bookmarksEntry) throws PortalException {
        long userId = portletDataContext.getUserId(bookmarksEntry.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)bookmarksEntry);
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setUuid(bookmarksEntry.getUuid());
        }
        return this._bookmarksEntryLocalService.addEntry(userId, bookmarksEntry.getGroupId(), bookmarksEntry.getFolderId(), bookmarksEntry.getName(), bookmarksEntry.getUrl(), bookmarksEntry.getDescription(), serviceContext);
    }

    public void deleteStagedModel(BookmarksEntry bookmarksEntry) throws PortalException {
        this._bookmarksEntryLocalService.deleteEntry(bookmarksEntry);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        BookmarksEntry bookmarksEntry = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (bookmarksEntry != null) {
            this.deleteStagedModel(bookmarksEntry);
        }
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
        this._bookmarksEntryLocalService.deleteEntries(portletDataContext.getScopeGroupId(), 0L);
    }

    public BookmarksEntry fetchMissingReference(String uuid, long groupId) {
        return (BookmarksEntry)this._stagedModelRepositoryHelper.fetchMissingReference(uuid, groupId, (StagedModelRepository)this);
    }

    public BookmarksEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._bookmarksEntryLocalService.fetchBookmarksEntryByUuidAndGroupId(uuid, groupId);
    }

    public List<BookmarksEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._bookmarksEntryLocalService.getBookmarksEntriesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return this._bookmarksEntryLocalService.getExportActionableDynamicQuery(portletDataContext);
    }

    public BookmarksEntry getStagedModel(long entryId) throws PortalException {
        return this._bookmarksEntryLocalService.getBookmarksEntry(entryId);
    }

    public void restoreStagedModel(PortletDataContext portletDataContext, BookmarksEntry bookmarksEntry) throws PortletDataException {
        BookmarksEntry existingBookmarksEntry = this.fetchStagedModelByUuidAndGroupId(bookmarksEntry.getUuid(), portletDataContext.getScopeGroupId());
        if (existingBookmarksEntry == null || !this._stagedModelRepositoryHelper.isStagedModelInTrash((StagedModel)existingBookmarksEntry)) {
            return;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)BookmarksEntry.class.getName());
        try {
            if (trashHandler.isRestorable(existingBookmarksEntry.getEntryId())) {
                trashHandler.restoreTrashEntry(portletDataContext.getUserId(bookmarksEntry.getUserUuid()), existingBookmarksEntry.getEntryId());
            }
        }
        catch (PortalException portalException) {
            throw new PortletDataException((Throwable)portalException);
        }
    }

    public BookmarksEntry saveStagedModel(BookmarksEntry bookmarksEntry) {
        return this._bookmarksEntryLocalService.updateBookmarksEntry(bookmarksEntry);
    }

    public BookmarksEntry updateStagedModel(PortletDataContext portletDataContext, BookmarksEntry bookmarksEntry) {
        throw new UnsupportedOperationException();
    }
}

