/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.service.http;

import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.model.BookmarksFolderSoap;
import com.liferay.bookmarks.service.BookmarksFolderServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import java.rmi.RemoteException;
import java.util.List;

public class BookmarksFolderServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(BookmarksFolderServiceSoap.class);

    public static BookmarksFolderSoap addFolder(long parentFolderId, String name, String description, ServiceContext serviceContext) throws RemoteException {
        try {
            BookmarksFolder returnValue = BookmarksFolderServiceUtil.addFolder((long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            return BookmarksFolderSoap.toSoapModel((BookmarksFolder)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static void deleteFolder(long folderId) throws RemoteException {
        try {
            BookmarksFolderServiceUtil.deleteFolder((long)folderId);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static void deleteFolder(long folderId, boolean includeTrashedEntries) throws RemoteException {
        try {
            BookmarksFolderServiceUtil.deleteFolder((long)folderId, (boolean)includeTrashedEntries);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static BookmarksFolderSoap getFolder(long folderId) throws RemoteException {
        try {
            BookmarksFolder returnValue = BookmarksFolderServiceUtil.getFolder((long)folderId);
            return BookmarksFolderSoap.toSoapModel((BookmarksFolder)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static Long[] getFolderIds(long groupId, long folderId) throws RemoteException {
        try {
            List returnValue = BookmarksFolderServiceUtil.getFolderIds((long)groupId, (long)folderId);
            return returnValue.toArray(new Long[returnValue.size()]);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static BookmarksFolderSoap[] getFolders(long groupId) throws RemoteException {
        try {
            List returnValue = BookmarksFolderServiceUtil.getFolders((long)groupId);
            return BookmarksFolderSoap.toSoapModels((List)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static BookmarksFolderSoap[] getFolders(long groupId, long parentFolderId) throws RemoteException {
        try {
            List returnValue = BookmarksFolderServiceUtil.getFolders((long)groupId, (long)parentFolderId);
            return BookmarksFolderSoap.toSoapModels((List)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static BookmarksFolderSoap[] getFolders(long groupId, long parentFolderId, int start, int end) throws RemoteException {
        try {
            List returnValue = BookmarksFolderServiceUtil.getFolders((long)groupId, (long)parentFolderId, (int)start, (int)end);
            return BookmarksFolderSoap.toSoapModels((List)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static BookmarksFolderSoap[] getFolders(long groupId, long parentFolderId, int status, int start, int end) throws RemoteException {
        try {
            List returnValue = BookmarksFolderServiceUtil.getFolders((long)groupId, (long)parentFolderId, (int)status, (int)start, (int)end);
            return BookmarksFolderSoap.toSoapModels((List)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static int getFoldersAndEntriesCount(long groupId, long folderId) throws RemoteException {
        try {
            int returnValue = BookmarksFolderServiceUtil.getFoldersAndEntriesCount((long)groupId, (long)folderId);
            return returnValue;
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static int getFoldersAndEntriesCount(long groupId, long folderId, int status) throws RemoteException {
        try {
            int returnValue = BookmarksFolderServiceUtil.getFoldersAndEntriesCount((long)groupId, (long)folderId, (int)status);
            return returnValue;
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static int getFoldersCount(long groupId, long parentFolderId) throws RemoteException {
        try {
            int returnValue = BookmarksFolderServiceUtil.getFoldersCount((long)groupId, (long)parentFolderId);
            return returnValue;
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static int getFoldersCount(long groupId, long parentFolderId, int status) throws RemoteException {
        try {
            int returnValue = BookmarksFolderServiceUtil.getFoldersCount((long)groupId, (long)parentFolderId, (int)status);
            return returnValue;
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    @Deprecated
    public static void getSubfolderIds(Long[] folderIds, long groupId, long folderId) throws RemoteException {
        try {
            BookmarksFolderServiceUtil.getSubfolderIds((List)ListUtil.toList((Object[])folderIds), (long)groupId, (long)folderId);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static void getSubfolderIds(Long[] folderIds, long groupId, long folderId, boolean recurse) throws RemoteException {
        try {
            BookmarksFolderServiceUtil.getSubfolderIds((List)ListUtil.toList((Object[])folderIds), (long)groupId, (long)folderId, (boolean)recurse);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static Long[] getSubfolderIds(long groupId, long folderId, boolean recurse) throws RemoteException {
        try {
            List returnValue = BookmarksFolderServiceUtil.getSubfolderIds((long)groupId, (long)folderId, (boolean)recurse);
            return returnValue.toArray(new Long[returnValue.size()]);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static void mergeFolders(long folderId, long parentFolderId) throws RemoteException {
        try {
            BookmarksFolderServiceUtil.mergeFolders((long)folderId, (long)parentFolderId);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static BookmarksFolderSoap moveFolder(long folderId, long parentFolderId) throws RemoteException {
        try {
            BookmarksFolder returnValue = BookmarksFolderServiceUtil.moveFolder((long)folderId, (long)parentFolderId);
            return BookmarksFolderSoap.toSoapModel((BookmarksFolder)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static BookmarksFolderSoap moveFolderFromTrash(long folderId, long parentFolderId) throws RemoteException {
        try {
            BookmarksFolder returnValue = BookmarksFolderServiceUtil.moveFolderFromTrash((long)folderId, (long)parentFolderId);
            return BookmarksFolderSoap.toSoapModel((BookmarksFolder)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static BookmarksFolderSoap moveFolderToTrash(long folderId) throws RemoteException {
        try {
            BookmarksFolder returnValue = BookmarksFolderServiceUtil.moveFolderToTrash((long)folderId);
            return BookmarksFolderSoap.toSoapModel((BookmarksFolder)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static void restoreFolderFromTrash(long folderId) throws RemoteException {
        try {
            BookmarksFolderServiceUtil.restoreFolderFromTrash((long)folderId);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static void subscribeFolder(long groupId, long folderId) throws RemoteException {
        try {
            BookmarksFolderServiceUtil.subscribeFolder((long)groupId, (long)folderId);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static void unsubscribeFolder(long groupId, long folderId) throws RemoteException {
        try {
            BookmarksFolderServiceUtil.unsubscribeFolder((long)groupId, (long)folderId);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    @Deprecated
    public static BookmarksFolderSoap updateFolder(long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws RemoteException {
        try {
            BookmarksFolder returnValue = BookmarksFolderServiceUtil.updateFolder((long)folderId, (long)parentFolderId, (String)name, (String)description, (boolean)mergeWithParentFolder, (ServiceContext)serviceContext);
            return BookmarksFolderSoap.toSoapModel((BookmarksFolder)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static BookmarksFolderSoap updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws RemoteException {
        try {
            BookmarksFolder returnValue = BookmarksFolderServiceUtil.updateFolder((long)folderId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            return BookmarksFolderSoap.toSoapModel((BookmarksFolder)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }
}

