/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.service.http;

import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.service.BookmarksEntryServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class BookmarksEntryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(BookmarksEntryServiceHttp.class);
    private static final Class<?>[] _addEntryParameterTypes0 = new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteEntryParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getEntriesParameterTypes2 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getEntriesParameterTypes3 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getEntriesCountParameterTypes4 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getEntriesCountParameterTypes5 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE};
    private static final Class<?>[] _getEntryParameterTypes6 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getFoldersEntriesCountParameterTypes7 = new Class[]{Long.TYPE, List.class};
    private static final Class<?>[] _getGroupEntriesParameterTypes8 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getGroupEntriesParameterTypes9 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getGroupEntriesParameterTypes10 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getGroupEntriesCountParameterTypes11 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGroupEntriesCountParameterTypes12 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getGroupEntriesCountParameterTypes13 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE};
    private static final Class<?>[] _moveEntryParameterTypes14 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _moveEntryFromTrashParameterTypes15 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _moveEntryToTrashParameterTypes16 = new Class[]{Long.TYPE};
    private static final Class<?>[] _openEntryParameterTypes17 = new Class[]{BookmarksEntry.class};
    private static final Class<?>[] _openEntryParameterTypes18 = new Class[]{Long.TYPE};
    private static final Class<?>[] _restoreEntryFromTrashParameterTypes19 = new Class[]{Long.TYPE};
    private static final Class<?>[] _searchParameterTypes20 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _subscribeEntryParameterTypes21 = new Class[]{Long.TYPE};
    private static final Class<?>[] _unsubscribeEntryParameterTypes22 = new Class[]{Long.TYPE};
    private static final Class<?>[] _updateEntryParameterTypes23 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, String.class, String.class, String.class, ServiceContext.class};

    public static BookmarksEntry addEntry(HttpPrincipal httpPrincipal, long groupId, long folderId, String name, String url, String description, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "addEntry", (Class[])_addEntryParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name, url, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deleteEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "deleteEntry", (Class[])_deleteEntryParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<BookmarksEntry> getEntries(HttpPrincipal httpPrincipal, long groupId, long folderId, int start, int end) {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getEntries", (Class[])_getEntriesParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<BookmarksEntry> getEntries(HttpPrincipal httpPrincipal, long groupId, long folderId, int start, int end, OrderByComparator<BookmarksEntry> orderByComparator) {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getEntries", (Class[])_getEntriesParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getEntriesCount(HttpPrincipal httpPrincipal, long groupId, long folderId) {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getEntriesCount", (Class[])_getEntriesCountParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getEntriesCount(HttpPrincipal httpPrincipal, long groupId, long folderId, int status) {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getEntriesCount", (Class[])_getEntriesCountParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, status});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static BookmarksEntry getEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getEntry", (Class[])_getEntryParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getFoldersEntriesCount(HttpPrincipal httpPrincipal, long groupId, List<Long> folderIds) {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getFoldersEntriesCount", (Class[])_getFoldersEntriesCountParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderIds});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<BookmarksEntry> getGroupEntries(HttpPrincipal httpPrincipal, long groupId, int start, int end) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getGroupEntries", (Class[])_getGroupEntriesParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<BookmarksEntry> getGroupEntries(HttpPrincipal httpPrincipal, long groupId, long userId, int start, int end) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getGroupEntries", (Class[])_getGroupEntriesParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<BookmarksEntry> getGroupEntries(HttpPrincipal httpPrincipal, long groupId, long userId, long rootFolderId, int start, int end) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getGroupEntries", (Class[])_getGroupEntriesParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId, rootFolderId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getGroupEntriesCount(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getGroupEntriesCount", (Class[])_getGroupEntriesCountParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getGroupEntriesCount(HttpPrincipal httpPrincipal, long groupId, long userId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getGroupEntriesCount", (Class[])_getGroupEntriesCountParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getGroupEntriesCount(HttpPrincipal httpPrincipal, long groupId, long userId, long rootFolderId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "getGroupEntriesCount", (Class[])_getGroupEntriesCountParameterTypes13);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId, rootFolderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static BookmarksEntry moveEntry(HttpPrincipal httpPrincipal, long entryId, long parentFolderId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "moveEntry", (Class[])_moveEntryParameterTypes14);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId, parentFolderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static BookmarksEntry moveEntryFromTrash(HttpPrincipal httpPrincipal, long entryId, long parentFolderId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "moveEntryFromTrash", (Class[])_moveEntryFromTrashParameterTypes15);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId, parentFolderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static BookmarksEntry moveEntryToTrash(HttpPrincipal httpPrincipal, long entryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "moveEntryToTrash", (Class[])_moveEntryToTrashParameterTypes16);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static BookmarksEntry openEntry(HttpPrincipal httpPrincipal, BookmarksEntry entry) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "openEntry", (Class[])_openEntryParameterTypes17);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entry});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static BookmarksEntry openEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "openEntry", (Class[])_openEntryParameterTypes18);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void restoreEntryFromTrash(HttpPrincipal httpPrincipal, long entryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "restoreEntryFromTrash", (Class[])_restoreEntryFromTrashParameterTypes19);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Hits search(HttpPrincipal httpPrincipal, long groupId, long creatorUserId, int status, int start, int end) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "search", (Class[])_searchParameterTypes20);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, creatorUserId, status, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Hits)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void subscribeEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "subscribeEntry", (Class[])_subscribeEntryParameterTypes21);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void unsubscribeEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "unsubscribeEntry", (Class[])_unsubscribeEntryParameterTypes22);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static BookmarksEntry updateEntry(HttpPrincipal httpPrincipal, long entryId, long groupId, long folderId, String name, String url, String description, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class, "updateEntry", (Class[])_updateEntryParameterTypes23);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId, groupId, folderId, name, url, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

