/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.model.impl;

import com.liferay.bookmarks.exception.NoSuchFolderException;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.model.impl.BookmarksFolderBaseImpl;
import com.liferay.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.ArrayList;
import java.util.List;

public class BookmarksFolderImpl
extends BookmarksFolderBaseImpl {
    public List<Long> getAncestorFolderIds() throws PortalException {
        ArrayList<Long> ancestorFolderIds = new ArrayList<Long>();
        BookmarksFolderImpl folder = this;
        while (!folder.isRoot()) {
            try {
                folder = folder.getParentFolder();
                ancestorFolderIds.add(folder.getFolderId());
            }
            catch (NoSuchFolderException noSuchFolderException) {
                if (folder.isInTrash()) break;
                throw noSuchFolderException;
            }
        }
        return ancestorFolderIds;
    }

    public List<BookmarksFolder> getAncestors() throws PortalException {
        ArrayList<BookmarksFolder> ancestors = new ArrayList<BookmarksFolder>();
        BookmarksFolderImpl folder = this;
        while (!folder.isRoot()) {
            try {
                folder = folder.getParentFolder();
                ancestors.add(folder);
            }
            catch (NoSuchFolderException noSuchFolderException) {
                if (folder.isInTrash()) break;
                throw noSuchFolderException;
            }
        }
        return ancestors;
    }

    public BookmarksFolder getParentFolder() throws PortalException {
        if (this.getParentFolderId() == 0L) {
            return null;
        }
        return BookmarksFolderLocalServiceUtil.getFolder((long)this.getParentFolderId());
    }

    public boolean isRoot() {
        return this.getParentFolderId() == 0L;
    }
}

