/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.verify;

import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksFolderLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.instances.service.PortalInstancesLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Deprecated
@Component(immediate=true, property={"verify.process.name=com.liferay.bookmarks.service"}, service={VerifyProcess.class})
public class BookmarksServiceVerifyProcess
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(BookmarksServiceVerifyProcess.class);
    @Reference
    private BookmarksFolderLocalService _bookmarksFolderLocalService;
    @Reference
    private PortalInstancesLocalService _portalInstancesLocalService;

    protected void doVerify() throws Exception {
        this.updateFolderAssets();
        this.verifyTree();
    }

    protected void updateFolderAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List folders = this._bookmarksFolderLocalService.getNoAssetFolders();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + folders.size() + " folders with no asset"));
            }
            for (BookmarksFolder folder : folders) {
                try {
                    this._bookmarksFolderLocalService.updateAsset(folder.getUserId(), folder, null, null, null, null);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to update asset for folder ", folder.getFolderId(), ": ", exception.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for folders");
            }
        }
    }

    protected void verifyTree() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long[] companyIds;
            for (long companyId : companyIds = this._portalInstancesLocalService.getCompanyIdsBySQL()) {
                this._bookmarksFolderLocalService.rebuildTree(companyId);
            }
        }
    }
}

