/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.social;

import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.kernel.model.BaseSocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"javax.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksPortlet", "model.class.name=com.liferay.bookmarks.model.BookmarksEntry"}, service={SocialActivityInterpreter.class})
public class BookmarksEntryActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{BookmarksEntry.class.getName()};
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksEntry)")
    private ModelResourcePermission<BookmarksEntry> _bookmarksEntryModelResourcePermission;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(bundle.symbolic.name=com.liferay.bookmarks.web)")
    private volatile ResourceBundleLoader _resourceBundleLoader;

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) {
        return "/bookmarks/find_entry?entryId=" + activity.getClassPK();
    }

    protected ResourceBundleLoader getResourceBundleLoader() {
        return this._resourceBundleLoader;
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        int activityType = activity.getType();
        if (activityType == 1) {
            if (Validator.isNull((String)groupName)) {
                return "activity-bookmarks-entry-add-entry";
            }
            return "activity-bookmarks-entry-add-entry-in";
        }
        if (activityType == 2) {
            if (Validator.isNull((String)groupName)) {
                return "activity-bookmarks-entry-update-entry";
            }
            return "activity-bookmarks-entry-update-entry-in";
        }
        if (activityType == 10007) {
            if (Validator.isNull((String)groupName)) {
                return "activity-bookmarks-entry-move-to-trash";
            }
            return "activity-bookmarks-entry-move-to-trash-in";
        }
        if (activityType == 10008) {
            if (Validator.isNull((String)groupName)) {
                return "activity-bookmarks-entry-restore-from-trash";
            }
            return "activity-bookmarks-entry-restore-from-trash-in";
        }
        return null;
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        return this._bookmarksEntryModelResourcePermission.contains(permissionChecker, activity.getClassPK(), actionId);
    }
}

