/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.search.spi.model.index.contributor;

import com.liferay.bookmarks.internal.search.util.BookmarksFolderBatchReindexer;
import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.service.BookmarksEntryLocalService;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.index.contributor.helper.ModelIndexerWriterDocumentHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.bookmarks.model.BookmarksEntry"}, service={ModelIndexerWriterContributor.class})
public class BookmarksEntryModelIndexerWriterContributor
implements ModelIndexerWriterContributor<BookmarksEntry> {
    @Reference
    protected BookmarksEntryLocalService bookmarksEntryLocalService;
    @Reference
    protected BookmarksFolderBatchReindexer bookmarksFolderBatchReindexer;
    @Reference
    protected DynamicQueryBatchIndexingActionableFactory dynamicQueryBatchIndexingActionableFactory;

    public void customize(BatchIndexingActionable batchIndexingActionable, ModelIndexerWriterDocumentHelper modelIndexerWriterDocumentHelper) {
        batchIndexingActionable.setAddCriteriaMethod(dynamicQuery -> {
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.in((Object[])new Integer[]{0, 8}));
        });
        batchIndexingActionable.setPerformActionMethod(bookmarksEntry -> {
            batchIndexingActionable.addDocuments(new Document[]{modelIndexerWriterDocumentHelper.getDocument((BaseModel)bookmarksEntry)});
            this.bookmarksFolderBatchReindexer.reindex(bookmarksEntry.getFolderId(), bookmarksEntry.getCompanyId());
        });
    }

    public BatchIndexingActionable getBatchIndexingActionable() {
        return this.dynamicQueryBatchIndexingActionableFactory.getBatchIndexingActionable(this.bookmarksEntryLocalService.getIndexableActionableDynamicQuery());
    }

    public long getCompanyId(BookmarksEntry bookmarksEntry) {
        return bookmarksEntry.getCompanyId();
    }

    public void modelIndexed(BookmarksEntry bookmarksEntry) {
        this.bookmarksFolderBatchReindexer.reindex(bookmarksEntry.getFolderId(), bookmarksEntry.getCompanyId());
    }
}

