/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.verify;

import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksFolderLocalService;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.instances.service.PortalInstancesLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"verify.process.name=com.liferay.bookmarks.service"}, service={VerifyProcess.class})
public class BookmarksServiceVerifyProcess
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(BookmarksServiceVerifyProcess.class);
    private BookmarksFolderLocalService _bookmarksFolderLocalService;
    private GroupLocalService _groupLocalService;
    @Reference
    private PortalInstancesLocalService _portalInstancesLocalService;
    @Reference
    private Staging _staging;

    protected void doVerify() throws Exception {
        this.updateFolderAssets();
        this.updateStagedPortletNames();
        this.verifyTree();
    }

    @Reference(unbind="-")
    protected void setBookmarksFolderLocalService(BookmarksFolderLocalService bookmarksFolderLocalService) {
        this._bookmarksFolderLocalService = bookmarksFolderLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    protected void updateFolderAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List folders = this._bookmarksFolderLocalService.getNoAssetFolders();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + folders.size() + " folders with no asset"));
            }
            for (BookmarksFolder folder : folders) {
                try {
                    this._bookmarksFolderLocalService.updateAsset(folder.getUserId(), folder, null, null, null, null);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to update asset for folder ", folder.getFolderId(), ": ", e.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for folders");
            }
        }
    }

    protected void updateStagedPortletNames() throws PortalException {
        ActionableDynamicQuery groupActionableDynamicQuery = this._groupLocalService.getActionableDynamicQuery();
        groupActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property siteProperty = PropertyFactoryUtil.forName((String)"site");
            dynamicQuery.add(siteProperty.eq((Object)Boolean.TRUE));
        });
        groupActionableDynamicQuery.setPerformActionMethod(group -> {
            UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
            if (typeSettingsProperties == null) {
                return;
            }
            String propertyKey = this._staging.getStagedPortletId("com_liferay_bookmarks_web_portlet_BookmarksPortlet");
            String propertyValue = typeSettingsProperties.getProperty(propertyKey);
            if (Validator.isNull((String)propertyValue)) {
                return;
            }
            typeSettingsProperties.remove((Object)propertyKey);
            propertyKey = this._staging.getStagedPortletId("com_liferay_bookmarks_web_portlet_BookmarksAdminPortlet");
            typeSettingsProperties.put(propertyKey, propertyValue);
            group.setTypeSettingsProperties(typeSettingsProperties);
            this._groupLocalService.updateGroup(group);
        });
        groupActionableDynamicQuery.performActions();
    }

    protected void verifyTree() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long[] companyIds;
            for (long companyId : companyIds = this._portalInstancesLocalService.getCompanyIdsBySQL()) {
                this._bookmarksFolderLocalService.rebuildTree(companyId);
            }
        }
    }
}

