/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.security.permission.resource;

import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.model.BookmarksEntryModel;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksEntryLocalService;
import com.liferay.bookmarks.service.BookmarksFolderLocalService;
import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.DynamicInheritancePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.StagedModelPermissionLogic;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.util.PropsValues;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class BookmarksEntryModelResourcePermissionRegistrar {
    @Reference
    private BookmarksEntryLocalService _bookmarksEntryLocalService;
    @Reference
    private BookmarksFolderLocalService _bookmarksFolderLocalService;
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksFolder)")
    private ModelResourcePermission<BookmarksFolder> _bookmarksFolderModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.bookmarks)")
    private PortletResourcePermission _portletResourcePermission;
    private ServiceRegistration<ModelResourcePermission> _serviceRegistration;
    @Reference
    private StagingPermission _stagingPermission;

    @Activate
    public void activate(BundleContext bundleContext) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("model.class.name", BookmarksEntry.class.getName());
        this._serviceRegistration = bundleContext.registerService(ModelResourcePermission.class, (Object)ModelResourcePermissionFactory.create(BookmarksEntry.class, BookmarksEntryModel::getEntryId, arg_0 -> ((BookmarksEntryLocalService)this._bookmarksEntryLocalService).getEntry(arg_0), (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> {
            consumer.accept(new StagedModelPermissionLogic(this._stagingPermission, "com_liferay_bookmarks_web_portlet_BookmarksPortlet", BookmarksEntryModel::getEntryId));
            if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                consumer.accept(new DynamicInheritancePermissionLogic(this._bookmarksFolderModelResourcePermission, this._getFetchParentFunction(), true));
            }
        }), (Dictionary)properties);
    }

    @Deactivate
    public void deactivate() {
        this._serviceRegistration.unregister();
    }

    private UnsafeFunction<BookmarksEntry, BookmarksFolder, PortalException> _getFetchParentFunction() {
        return entry -> {
            long folderId = entry.getFolderId();
            if (0L == folderId) {
                return null;
            }
            if (entry.isInTrash()) {
                return this._bookmarksFolderLocalService.fetchBookmarksFolder(folderId);
            }
            return this._bookmarksFolderLocalService.getFolder(folderId);
        };
    }
}

