/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.search;

import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksFolderLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.FolderIndexer;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class BookmarksFolderIndexer
extends BaseIndexer<BookmarksFolder>
implements FolderIndexer {
    public static final String CLASS_NAME = BookmarksFolder.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(BookmarksFolderIndexer.class);
    private BookmarksFolderLocalService _bookmarksFolderLocalService;
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksFolder)")
    private ModelResourcePermission<BookmarksFolder> _bookmarksFolderModelResourcePermission;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public BookmarksFolderIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "title", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public String[] getFolderClassNames() {
        return new String[]{CLASS_NAME};
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return this._bookmarksFolderModelResourcePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this.addStatus(contextBooleanFilter, searchContext);
    }

    protected void doDelete(BookmarksFolder bookmarksFolder) throws Exception {
        this.deleteDocument(bookmarksFolder.getCompanyId(), bookmarksFolder.getFolderId());
    }

    protected Document doGetDocument(BookmarksFolder bookmarksFolder) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing folder " + bookmarksFolder));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)bookmarksFolder);
        document.addText("description", bookmarksFolder.getDescription());
        document.addKeyword("folderId", bookmarksFolder.getParentFolderId());
        document.addText("title", bookmarksFolder.getName());
        document.addKeyword("treePath", StringUtil.split((String)bookmarksFolder.getTreePath(), (char)'/'));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + bookmarksFolder + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "title", "description");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(BookmarksFolder bookmarksFolder) throws Exception {
        if (!bookmarksFolder.isApproved() && !bookmarksFolder.isInTrash()) {
            return;
        }
        Document document = this.getDocument(bookmarksFolder);
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), bookmarksFolder.getCompanyId(), document, this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        BookmarksFolder folder = this._bookmarksFolderLocalService.getFolder(classPK);
        this.doReindex(folder);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFolders(companyId);
    }

    protected void reindexFolders(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._bookmarksFolderLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(folder -> {
            block2: {
                try {
                    Document document = this.getDocument(folder);
                    indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index bookmarks folder " + folder.getFolderId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    @Reference(unbind="-")
    protected void setBookmarksFolderLocalService(BookmarksFolderLocalService bookmarksFolderLocalService) {
        this._bookmarksFolderLocalService = bookmarksFolderLocalService;
    }
}

