/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.search;

import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.service.BookmarksEntryLocalService;
import com.liferay.bookmarks.service.BookmarksFolderLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class BookmarksEntryIndexer
extends BaseIndexer<BookmarksEntry> {
    public static final String CLASS_NAME = BookmarksEntry.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(BookmarksEntryIndexer.class);
    private BookmarksEntryLocalService _bookmarksEntryLocalService;
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksEntry)")
    private ModelResourcePermission<BookmarksEntry> _bookmarksEntryModelResourcePermission;
    private BookmarksFolderLocalService _bookmarksFolderLocalService;
    private GroupLocalService _groupLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public BookmarksEntryIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"assetTagNames", "companyId", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "title", "uid", "url"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return this._bookmarksEntryModelResourcePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this.addStatus(contextBooleanFilter, searchContext);
    }

    protected void doDelete(BookmarksEntry bookmarksEntry) throws Exception {
        this.deleteDocument(bookmarksEntry.getCompanyId(), bookmarksEntry.getEntryId());
    }

    protected Document doGetDocument(BookmarksEntry bookmarksEntry) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)bookmarksEntry);
        document.addText("description", bookmarksEntry.getDescription());
        document.addKeyword("folderId", bookmarksEntry.getFolderId());
        document.addText("title", bookmarksEntry.getName());
        document.addKeyword("treePath", StringUtil.split((String)bookmarksEntry.getTreePath(), (char)'/'));
        document.addText("url", bookmarksEntry.getUrl());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        return this.createSummary(document, "title", "url");
    }

    protected void doReindex(BookmarksEntry bookmarksEntry) throws Exception {
        Document document = this.getDocument(bookmarksEntry);
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), bookmarksEntry.getCompanyId(), document, this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        BookmarksEntry entry = this._bookmarksEntryLocalService.getEntry(classPK);
        this.doReindex(entry);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFolders(companyId);
        this.reindexRoot(companyId);
    }

    protected void reindexEntries(long companyId, long groupId, long folderId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._bookmarksEntryLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property folderIdProperty = PropertyFactoryUtil.forName((String)"folderId");
            dynamicQuery.add(folderIdProperty.eq((Object)folderId));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            Object[] statuses = new Integer[]{0, 8};
            dynamicQuery.add(statusProperty.in(statuses));
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setGroupId(groupId);
        indexableActionableDynamicQuery.setPerformActionMethod(entry -> {
            block2: {
                try {
                    Document document = this.getDocument(entry);
                    indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index bookmarks entry " + entry.getEntryId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    protected void reindexFolders(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._bookmarksFolderLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(folder -> {
            long groupId = folder.getGroupId();
            long folderId = folder.getFolderId();
            this.reindexEntries(companyId, groupId, folderId);
        });
        actionableDynamicQuery.performActions();
    }

    protected void reindexRoot(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._groupLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(group -> {
            long groupId = group.getGroupId();
            long folderId = 0L;
            this.reindexEntries(companyId, groupId, folderId);
        });
        actionableDynamicQuery.performActions();
    }

    @Reference(unbind="-")
    protected void setBookmarksEntryLocalService(BookmarksEntryLocalService bookmarksEntryLocalService) {
        this._bookmarksEntryLocalService = bookmarksEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setBookmarksFolderLocalService(BookmarksFolderLocalService bookmarksFolderLocalService) {
        this._bookmarksFolderLocalService = bookmarksFolderLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }
}

