/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.exportimport.data.handler;

import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class BookmarksFolderStagedModelDataHandler
extends BaseStagedModelDataHandler<BookmarksFolder> {
    public static final String[] CLASS_NAMES = new String[]{BookmarksFolder.class.getName()};
    private StagedModelRepository<BookmarksFolder> _stagedModelRepository;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(BookmarksFolder folder) {
        return folder.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, BookmarksFolder folder) throws Exception {
        if (folder.getParentFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, (StagedModel)folder.getParentFolder(), (String)"parent");
        }
        Element folderElement = portletDataContext.getExportDataElement((ClassedModel)folder);
        portletDataContext.addClassedModel(folderElement, ExportImportPathUtil.getModelPath((StagedModel)folder), (ClassedModel)folder);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, BookmarksFolder folder) throws Exception {
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(BookmarksFolder.class);
        long parentFolderId = MapUtil.getLong((Map)folderIds, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        BookmarksFolder importedFolder = (BookmarksFolder)folder.clone();
        importedFolder.setGroupId(portletDataContext.getScopeGroupId());
        importedFolder.setParentFolderId(parentFolderId);
        BookmarksFolder existingFolder = (BookmarksFolder)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(folder.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFolder == null || !portletDataContext.isDataStrategyMirror()) {
            importedFolder = (BookmarksFolder)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedFolder);
        } else {
            importedFolder.setFolderId(existingFolder.getFolderId());
            importedFolder = (BookmarksFolder)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedFolder);
        }
        portletDataContext.importClassedModel((ClassedModel)folder, (ClassedModel)importedFolder);
    }

    protected StagedModelRepository<BookmarksFolder> getStagedModelRepository() {
        return this._stagedModelRepository;
    }

    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksFolder)", unbind="-")
    protected void setStagedModelRepository(StagedModelRepository<BookmarksFolder> stagedModelRepository) {
        this._stagedModelRepository = stagedModelRepository;
    }
}

