/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.exportimport.data.handler;

import com.liferay.bookmarks.internal.exportimport.staged.model.repository.BookmarksEntryStagedModelRepository;
import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class BookmarksEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<BookmarksEntry> {
    public static final String[] CLASS_NAMES = new String[]{BookmarksEntry.class.getName()};
    @Reference(service=BookmarksEntryStagedModelRepository.class, target="(model.class.name=com.liferay.bookmarks.model.BookmarksEntry)")
    private BookmarksEntryStagedModelRepository _bookmarksEntryStagedModelRepository;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(BookmarksEntry entry) {
        return entry.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, BookmarksEntry entry) throws Exception {
        if (entry.getFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)entry, (StagedModel)entry.getFolder(), (String)"parent");
        }
        Element entryElement = portletDataContext.getExportDataElement((ClassedModel)entry);
        portletDataContext.addClassedModel(entryElement, ExportImportPathUtil.getModelPath((StagedModel)entry), (ClassedModel)entry);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long entryId) throws Exception {
        BookmarksEntry existingEntry = (BookmarksEntry)this.fetchMissingReference(uuid, groupId);
        if (existingEntry == null) {
            return;
        }
        Map entryIds = portletDataContext.getNewPrimaryKeysMap(BookmarksEntry.class);
        entryIds.put(entryId, existingEntry.getEntryId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, BookmarksEntry entry) throws Exception {
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(BookmarksFolder.class);
        long folderId = MapUtil.getLong((Map)folderIds, (long)entry.getFolderId(), (long)entry.getFolderId());
        BookmarksEntry importedEntry = (BookmarksEntry)entry.clone();
        importedEntry.setGroupId(portletDataContext.getScopeGroupId());
        importedEntry.setFolderId(folderId);
        BookmarksEntry existingEntry = this._bookmarksEntryStagedModelRepository.fetchStagedModelByUuidAndGroupId(entry.getUuid(), portletDataContext.getScopeGroupId());
        importedEntry = existingEntry == null || !portletDataContext.isDataStrategyMirror() ? this._bookmarksEntryStagedModelRepository.addStagedModel(portletDataContext, importedEntry) : this._bookmarksEntryStagedModelRepository.updateStagedModel(portletDataContext, importedEntry, existingEntry.getEntryId());
        portletDataContext.importClassedModel((ClassedModel)entry, (ClassedModel)importedEntry);
    }

    protected StagedModelRepository<BookmarksEntry> getStagedModelRepository() {
        return this._bookmarksEntryStagedModelRepository;
    }
}

