/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.internal.exportimport.data.handler;

import com.liferay.bookmarks.internal.exportimport.data.handler.BookmarksPortletDataHandler;
import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.exportimport.portlet.data.handler.helper.PortletDataHandlerHelper;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksAdminPortlet"}, service={PortletDataHandler.class})
public class BookmarksAdminPortletDataHandler
extends BasePortletDataHandler {
    public static final String[] CLASS_NAMES = new String[]{BookmarksEntry.class.getName(), BookmarksFolder.class.getName()};
    public static final String NAMESPACE = "bookmarks";
    public static final String SCHEMA_VERSION = "1.0.0";
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksEntry)")
    private StagedModelRepository<BookmarksEntry> _bookmarksEntryStagedModelRepository;
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksFolder)")
    private StagedModelRepository<BookmarksFolder> _bookmarksFolderStagedModelRepository;
    @Reference
    private PortletDataHandlerHelper _portletDataHandlerHelper;
    @Reference
    private Staging _staging;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public String getServiceName() {
        return "com.liferay.bookmarks";
    }

    public boolean validateSchemaVersion(String schemaVersion) {
        return this._portletDataHandlerHelper.validateSchemaVersion(schemaVersion, this.getSchemaVersion());
    }

    @Activate
    protected void activate() {
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(BookmarksEntry.class), new StagedModelType(BookmarksFolder.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "folders", true, false, null, BookmarksFolder.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "entries", true, false, null, BookmarksEntry.class.getName())});
        this.setStagingControls(this.getExportControls());
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(BookmarksPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        this._bookmarksEntryStagedModelRepository.deleteStagedModels(portletDataContext);
        this._bookmarksFolderStagedModelRepository.deleteStagedModels(portletDataContext);
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortletPermissions("com.liferay.bookmarks");
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        if (portletDataContext.getBooleanParameter(NAMESPACE, "folders")) {
            ExportActionableDynamicQuery folderActionableDynamicQuery = this._bookmarksFolderStagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
            folderActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "entries")) {
            ExportActionableDynamicQuery entryActionableDynamicQuery = this._bookmarksEntryStagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
            entryActionableDynamicQuery.performActions();
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortletPermissions("com.liferay.bookmarks");
        if (portletDataContext.getBooleanParameter(NAMESPACE, "folders")) {
            Element foldersElement = portletDataContext.getImportDataGroupElement(BookmarksFolder.class);
            List folderElements = foldersElement.elements();
            for (Element folderElement : folderElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)folderElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "entries")) {
            Element entriesElement = portletDataContext.getImportDataGroupElement(BookmarksEntry.class);
            List entryElements = entriesElement.elements();
            for (Element entryElement : entryElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)entryElement);
            }
        }
        return portletPreferences;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        if (ExportImportDateUtil.isRangeFromLastPublishDate((PortletDataContext)portletDataContext)) {
            this._staging.populateLastPublishDateCounts(portletDataContext, new StagedModelType[]{new StagedModelType(BookmarksEntry.class.getName()), new StagedModelType(BookmarksFolder.class.getName())});
            return;
        }
        ExportActionableDynamicQuery entryExportActionableDynamicQuery = this._bookmarksEntryStagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
        entryExportActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery folderExportActionableDynamicQuery = this._bookmarksFolderStagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
        folderExportActionableDynamicQuery.performCount();
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }
}

