/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.verify;

import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.verify.VerifyProcess;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={VerifyProcess.class})
public class BlogsServiceVerifyProcess
extends VerifyProcess {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.blogs.service)(release.schema.version>=3.1.0))")
    private Release _release;
    @Reference
    private Staging _staging;

    protected void doVerify() throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-157670")) {
            return;
        }
        this.updateStagedPortletNames();
    }

    protected void updateStagedPortletNames() throws PortalException {
        ActionableDynamicQuery groupActionableDynamicQuery = this._groupLocalService.getActionableDynamicQuery();
        groupActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property siteProperty = PropertyFactoryUtil.forName((String)"site");
            dynamicQuery.add(siteProperty.eq((Object)Boolean.TRUE));
        });
        groupActionableDynamicQuery.setPerformActionMethod(group -> {
            UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
            if (typeSettingsUnicodeProperties == null) {
                return;
            }
            String propertyKey = this._staging.getStagedPortletId("com_liferay_blogs_web_portlet_BlogsPortlet");
            String propertyValue = typeSettingsUnicodeProperties.getProperty(propertyKey);
            if (Validator.isNull((String)propertyValue)) {
                return;
            }
            typeSettingsUnicodeProperties.remove((Object)propertyKey);
            propertyKey = this._staging.getStagedPortletId("com_liferay_blogs_web_portlet_BlogsAdminPortlet");
            typeSettingsUnicodeProperties.put(propertyKey, propertyValue);
            group.setTypeSettingsProperties(typeSettingsUnicodeProperties);
            this._groupLocalService.updateGroup(group);
        });
        groupActionableDynamicQuery.performActions();
    }
}

