/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.upgrade;

import com.liferay.blogs.internal.upgrade.v1_1_0.BlogsEntryUpgradeProcess;
import com.liferay.blogs.internal.upgrade.v1_1_0.UpgradeClassNames;
import com.liferay.blogs.internal.upgrade.v1_1_2.BlogsImagesUpgradeProcess;
import com.liferay.blogs.internal.upgrade.v2_0_0.util.BlogsEntryTable;
import com.liferay.blogs.internal.upgrade.v2_0_0.util.BlogsStatsUserTable;
import com.liferay.blogs.internal.upgrade.v2_2_0.BlogsEntryExternalReferenceCodeUpgradeProcess;
import com.liferay.blogs.internal.upgrade.v3_0_0.BlogsStatsUserUpgradeProcess;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.comment.upgrade.UpgradeDiscussionSubscriptionClassName;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.petra.function.UnsafeBiFunction;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.upgrade.BaseSQLServerDatetimeUpgradeProcess;
import com.liferay.portal.kernel.upgrade.CTModelUpgradeProcess;
import com.liferay.portal.kernel.upgrade.DummyUpgradeProcess;
import com.liferay.portal.kernel.upgrade.DummyUpgradeStep;
import com.liferay.portal.kernel.upgrade.MVCCVersionUpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import com.liferay.portlet.documentlibrary.store.StoreFactory;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UpgradeStepRegistrator.class})
public class BlogsServiceUpgrade
implements UpgradeStepRegistrator {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference(target="(dl.store.impl.enabled=true)")
    private StoreFactory _storeFactory;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    public void register(UpgradeStepRegistrator.Registry registry) {
        registry.register("0.0.1", "1.0.0", new UpgradeStep[]{new UpgradeClassNames()});
        registry.register("1.0.0", "1.1.0", new UpgradeStep[]{new BlogsEntryUpgradeProcess(this._classNameLocalService, this._friendlyURLEntryLocalService)});
        registry.register("1.1.0", "1.1.1", new UpgradeStep[]{new com.liferay.blogs.internal.upgrade.v1_1_1.BlogsEntryUpgradeProcess()});
        registry.register("1.1.1", "1.1.2", new UpgradeStep[]{new BlogsImagesUpgradeProcess(this._imageLocalService, this._portletFileRepository)});
        registry.register("1.1.2", "1.1.3", new UpgradeStep[]{new UpgradeDiscussionSubscriptionClassName(this._classNameLocalService, this._subscriptionLocalService, BlogsEntry.class.getName(), this._getUpgradeDiscussionSubscriptionClassNameUnsafeBiFunction())});
        registry.register("1.1.3", "2.0.0", new UpgradeStep[]{new BaseSQLServerDatetimeUpgradeProcess(new Class[]{BlogsEntryTable.class, BlogsStatsUserTable.class})});
        registry.register("2.0.0", "2.0.1", new UpgradeStep[]{new DummyUpgradeProcess()});
        registry.register("2.0.1", "2.1.0", new UpgradeStep[]{new MVCCVersionUpgradeProcess(){

            protected String[] getModuleTableNames() {
                return new String[]{"BlogsEntry", "BlogsStatsUser"};
            }
        }});
        registry.register("2.1.0", "2.1.1", new UpgradeStep[]{new com.liferay.blogs.internal.upgrade.v2_1_1.BlogsEntryUpgradeProcess()});
        registry.register("2.1.1", "2.1.2", new UpgradeStep[]{new DummyUpgradeStep()});
        registry.register("2.1.2", "2.2.0", new UpgradeStep[]{new BlogsEntryExternalReferenceCodeUpgradeProcess()});
        registry.register("2.2.0", "3.0.0", new UpgradeStep[]{new BlogsStatsUserUpgradeProcess()});
        registry.register("3.0.0", "3.1.0", new UpgradeStep[]{new CTModelUpgradeProcess(new String[]{"BlogsEntry"})});
    }

    private UnsafeBiFunction<String, Connection, Boolean, Exception> _getUpgradeDiscussionSubscriptionClassNameUnsafeBiFunction() {
        return (className, connection) -> {
            try (PreparedStatement preparedStatement = connection.prepareStatement(SQLTransformer.transform((String)StringBundler.concat((String[])new String[]{"update Subscription set classNameId = ? ", "where classNameId = ? and classPK not in ", "(select groupId from Group_ where site = ", "[$TRUE$])"})));){
                preparedStatement.setLong(1, this._classNameLocalService.getClassNameId(MBDiscussion.class.getName() + "_" + BlogsEntry.class.getName()));
                preparedStatement.setLong(2, this._classNameLocalService.getClassNameId(className));
                preparedStatement.executeUpdate();
            }
            return true;
        };
    }
}

