/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.blogs.internal.model.listener;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.staging.model.listener.StagingModelListener;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Akos Thurzo
 */
@Component(immediate = true, service = ModelListener.class)
public class BlogsEntryStagingModelListener
	extends BaseModelListener<BlogsEntry> {

	@Override
	public void onAfterCreate(BlogsEntry blogsEntry)
		throws ModelListenerException {

		_stagingModelListener.onAfterCreate(blogsEntry);
	}

	@Override
	public void onAfterRemove(BlogsEntry blogsEntry)
		throws ModelListenerException {

		_stagingModelListener.onAfterRemove(blogsEntry);
	}

	@Override
	public void onAfterUpdate(
			BlogsEntry originalBlogsEntry, BlogsEntry blogsEntry)
		throws ModelListenerException {

		_stagingModelListener.onAfterUpdate(blogsEntry);
	}

	@Reference
	private StagingModelListener<BlogsEntry> _stagingModelListener;

}