/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.blogs.internal.exportimport.data.handler;

import com.liferay.blogs.constants.BlogsConstants;
import com.liferay.document.library.exportimport.data.handler.DLExportableRepositoryPublisher;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.service.RepositoryLocalService;

import java.util.function.Consumer;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Adolfo Pérez
 */
@Component(immediate = true, service = DLExportableRepositoryPublisher.class)
public class BlogsDLExportableRepositoryPublisher
	implements DLExportableRepositoryPublisher {

	@Override
	public void publish(long groupId, Consumer<Long> repositoryIdConsumer) {
		Repository repository = _repositoryLocalService.fetchRepository(
			groupId, BlogsConstants.SERVICE_NAME);

		if (repository != null) {
			repositoryIdConsumer.accept(repository.getRepositoryId());
		}
	}

	@Reference
	private RepositoryLocalService _repositoryLocalService;

}